/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.lucene.docset.GetDocSet;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldData;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldDataType;
import org.elasticsearch.index.search.geo.GeoDistance;

public class GeoDistanceRangeFilter
extends Filter {
    private final double lat;
    private final double lon;
    private final double inclusiveLowerPoint;
    private final double inclusiveUpperPoint;
    private final GeoDistance geoDistance;
    private final String fieldName;
    private final FieldDataCache fieldDataCache;

    public GeoDistanceRangeFilter(double lat, double lon, Double lowerVal, Double upperVal, boolean includeLower, boolean includeUpper, GeoDistance geoDistance, String fieldName, FieldDataCache fieldDataCache) {
        long i;
        double f;
        this.lat = lat;
        this.lon = lon;
        this.geoDistance = geoDistance;
        this.fieldName = fieldName;
        this.fieldDataCache = fieldDataCache;
        if (lowerVal != null) {
            f = lowerVal;
            i = NumericUtils.doubleToSortableLong(f);
            this.inclusiveLowerPoint = NumericUtils.sortableLongToDouble(includeLower ? i : i + 1L);
        } else {
            this.inclusiveLowerPoint = Double.NEGATIVE_INFINITY;
        }
        if (upperVal != null) {
            f = upperVal;
            i = NumericUtils.doubleToSortableLong(f);
            this.inclusiveUpperPoint = NumericUtils.sortableLongToDouble(includeUpper ? i : i - 1L);
        } else {
            this.inclusiveUpperPoint = Double.POSITIVE_INFINITY;
        }
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    public String fieldName() {
        return this.fieldName;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        final GeoPointFieldData fieldData = (GeoPointFieldData)this.fieldDataCache.cache(GeoPointFieldDataType.TYPE, reader, this.fieldName);
        return new GetDocSet(reader.maxDoc()){

            @Override
            public boolean isCacheable() {
                return false;
            }

            @Override
            public boolean get(int doc) throws IOException {
                if (!fieldData.hasValue(doc)) {
                    return false;
                }
                if (fieldData.multiValued()) {
                    double[] lats = fieldData.latValues(doc);
                    double[] lons = fieldData.lonValues(doc);
                    for (int i = 0; i < lats.length; ++i) {
                        double d = GeoDistanceRangeFilter.this.geoDistance.calculate(GeoDistanceRangeFilter.this.lat, GeoDistanceRangeFilter.this.lon, lats[i], lons[i], DistanceUnit.MILES);
                        if (!(d >= GeoDistanceRangeFilter.this.inclusiveLowerPoint) || !(d <= GeoDistanceRangeFilter.this.inclusiveUpperPoint)) continue;
                        return true;
                    }
                    return false;
                }
                double d = GeoDistanceRangeFilter.this.geoDistance.calculate(GeoDistanceRangeFilter.this.lat, GeoDistanceRangeFilter.this.lon, fieldData.latValue(doc), fieldData.lonValue(doc), DistanceUnit.MILES);
                return d >= GeoDistanceRangeFilter.this.inclusiveLowerPoint && d <= GeoDistanceRangeFilter.this.inclusiveUpperPoint;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoDistanceRangeFilter filter = (GeoDistanceRangeFilter)o;
        if (Double.compare(filter.inclusiveLowerPoint, this.inclusiveLowerPoint) != 0) {
            return false;
        }
        if (Double.compare(filter.inclusiveUpperPoint, this.inclusiveUpperPoint) != 0) {
            return false;
        }
        if (Double.compare(filter.lat, this.lat) != 0) {
            return false;
        }
        if (Double.compare(filter.lon, this.lon) != 0) {
            return false;
        }
        if (this.fieldName != null ? !this.fieldName.equals(filter.fieldName) : filter.fieldName != null) {
            return false;
        }
        return this.geoDistance == filter.geoDistance;
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.inclusiveLowerPoint != 0.0 ? Double.doubleToLongBits(this.inclusiveLowerPoint) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.inclusiveUpperPoint != 0.0 ? Double.doubleToLongBits(this.inclusiveUpperPoint) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.geoDistance != null ? this.geoDistance.hashCode() : 0);
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        return result;
    }
}

