/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.cluster;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.action.index.NodeIndexCreatedAction;
import org.elasticsearch.cluster.action.index.NodeIndexDeletedAction;
import org.elasticsearch.cluster.action.index.NodeMappingCreatedAction;
import org.elasticsearch.cluster.action.index.NodeMappingRefreshAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.IndexShardAlreadyExistsException;
import org.elasticsearch.index.IndexShardMissingException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.gateway.IndexShardGatewayService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.recovery.RecoveryFailedException;
import org.elasticsearch.index.shard.recovery.RecoverySource;
import org.elasticsearch.index.shard.recovery.RecoveryTarget;
import org.elasticsearch.index.shard.recovery.StartRecoveryRequest;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesClusterStateService
extends AbstractLifecycleComponent<IndicesClusterStateService>
implements ClusterStateListener {
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final RecoverySource recoverySource;
    private final RecoveryTarget recoveryTarget;
    private final ShardStateAction shardStateAction;
    private final NodeIndexCreatedAction nodeIndexCreatedAction;
    private final NodeIndexDeletedAction nodeIndexDeletedAction;
    private final NodeMappingCreatedAction nodeMappingCreatedAction;
    private final NodeMappingRefreshAction nodeMappingRefreshAction;
    private final ConcurrentMap<Tuple<String, String>, Boolean> seenMappings = ConcurrentCollections.newConcurrentMap();
    private final Object mutex = new Object();
    private final FailedEngineHandler failedEngineHandler = new FailedEngineHandler();

    @Inject
    public IndicesClusterStateService(Settings settings, IndicesService indicesService, ClusterService clusterService, ThreadPool threadPool, RecoveryTarget recoveryTarget, RecoverySource recoverySource, ShardStateAction shardStateAction, NodeIndexCreatedAction nodeIndexCreatedAction, NodeIndexDeletedAction nodeIndexDeletedAction, NodeMappingCreatedAction nodeMappingCreatedAction, NodeMappingRefreshAction nodeMappingRefreshAction) {
        super(settings);
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.recoverySource = recoverySource;
        this.recoveryTarget = recoveryTarget;
        this.shardStateAction = shardStateAction;
        this.nodeIndexCreatedAction = nodeIndexCreatedAction;
        this.nodeIndexDeletedAction = nodeIndexDeletedAction;
        this.nodeMappingCreatedAction = nodeMappingCreatedAction;
        this.nodeMappingRefreshAction = nodeMappingRefreshAction;
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        this.clusterService.add(this);
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.clusterService.remove(this);
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        this.recoverySource.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!this.indicesService.changesAllowed()) {
            return;
        }
        if (!this.lifecycle.started()) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.applyNewIndices(event);
            this.applyMappings(event);
            this.applyNewOrUpdatedShards(event);
            this.applyDeletedIndices(event);
            this.applyDeletedShards(event);
            this.applyCleanedIndices(event);
            this.applySettings(event);
        }
    }

    private void applyCleanedIndices(ClusterChangedEvent event) {
        for (String index : this.indicesService.indices()) {
            IndexMetaData indexMetaData = event.state().metaData().index(index);
            if (indexMetaData == null || indexMetaData.state() != IndexMetaData.State.CLOSE) continue;
            IndexService indexService = this.indicesService.indexService(index);
            for (Integer shardId : indexService.shardIds()) {
                this.logger.debug("[{}][{}] removing shard (index is closed)", index, shardId);
                try {
                    indexService.removeShard(shardId, "removing shard (index is closed)");
                }
                catch (Exception e) {
                    this.logger.warn("[{}] failed to remove shard (index is closed)", e, index);
                }
            }
        }
        for (String index : this.indicesService.indices()) {
            if (!this.indicesService.indexService(index).shardIds().isEmpty()) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}] cleaning index (no shards allocated)", index);
            }
            try {
                this.indicesService.cleanIndex(index, "cleaning index (no shards allocated)");
            }
            catch (Exception e) {
                this.logger.warn("[{}] failed to clean index (no shards of that index are allocated on this node)", e, index);
            }
        }
    }

    private void applyDeletedIndices(final ClusterChangedEvent event) {
        for (final String index : this.indicesService.indices()) {
            if (event.state().metaData().hasIndex(index)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}] deleting index", index);
            }
            try {
                this.indicesService.deleteIndex(index, "deleting index");
                this.threadPool.cached().execute(new Runnable(){

                    @Override
                    public void run() {
                        IndicesClusterStateService.this.nodeIndexDeletedAction.nodeIndexDeleted(index, event.state().nodes().localNodeId());
                    }
                });
            }
            catch (Exception e) {
                this.logger.warn("failed to delete index", e, new Object[0]);
            }
        }
    }

    private void applyDeletedShards(ClusterChangedEvent event) {
        RoutingNode routingNodes = event.state().readOnlyRoutingNodes().nodesToShards().get(event.state().nodes().localNodeId());
        if (routingNodes == null) {
            return;
        }
        for (String index : this.indicesService.indices()) {
            IndexMetaData indexMetaData = event.state().metaData().index(index);
            if (indexMetaData == null) continue;
            HashSet<Integer> newShardIds = Sets.newHashSet();
            for (MutableShardRouting shardRouting : routingNodes) {
                if (!shardRouting.index().equals(index)) continue;
                newShardIds.add(shardRouting.id());
            }
            IndexService indexService = this.indicesService.indexService(index);
            if (indexService == null) continue;
            for (Integer existingShardId : indexService.shardIds()) {
                if (newShardIds.contains(existingShardId)) continue;
                if (indexMetaData.state() == IndexMetaData.State.CLOSE) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("[{}][{}] removing shard (index is closed)", index, existingShardId);
                    }
                    indexService.removeShard(existingShardId, "removing shard (index is closed)");
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}] cleaning shard locally (not allocated)", index, existingShardId);
                }
                indexService.cleanShard(existingShardId, "cleaning shard locally (not allocated)");
            }
        }
    }

    private void applyNewIndices(final ClusterChangedEvent event) {
        RoutingNode routingNode = event.state().readOnlyRoutingNodes().nodesToShards().get(event.state().nodes().localNodeId());
        if (routingNode == null) {
            return;
        }
        for (MutableShardRouting shard : routingNode) {
            if (this.indicesService.hasIndex(shard.index())) continue;
            final IndexMetaData indexMetaData = event.state().metaData().index(shard.index());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}] creating index", indexMetaData.index());
            }
            this.indicesService.createIndex(indexMetaData.index(), indexMetaData.settings(), event.state().nodes().localNode().id());
            this.threadPool.cached().execute(new Runnable(){

                @Override
                public void run() {
                    IndicesClusterStateService.this.nodeIndexCreatedAction.nodeIndexCreated(indexMetaData.index(), event.state().nodes().localNodeId());
                }
            });
        }
    }

    private void applySettings(ClusterChangedEvent event) {
        for (IndexMetaData indexMetaData : event.state().metaData()) {
            if (!this.indicesService.hasIndex(indexMetaData.index())) continue;
            String index = indexMetaData.index();
            IndexService indexService = this.indicesService.indexServiceSafe(index);
            IndexSettingsService indexSettingsService = indexService.injector().getInstance(IndexSettingsService.class);
            indexSettingsService.refreshSettings(indexMetaData.settings());
        }
    }

    private void applyMappings(ClusterChangedEvent event) {
        for (IndexMetaData indexMetaData : event.state().metaData()) {
            if (!this.indicesService.hasIndex(indexMetaData.index())) continue;
            ArrayList<String> typesToRefresh = null;
            String index = indexMetaData.index();
            IndexService indexService = this.indicesService.indexServiceSafe(index);
            MapperService mapperService = indexService.mapperService();
            if (indexMetaData.mappings().containsKey("_default_")) {
                this.processMapping(event, index, mapperService, "_default_", indexMetaData.mapping("_default_").source());
            }
            for (MappingMetaData mappingMd : indexMetaData.mappings().values()) {
                boolean requireRefresh;
                String mappingType = mappingMd.type();
                CompressedString mappingSource = mappingMd.source();
                if (mappingType.equals("_default_") || !(requireRefresh = this.processMapping(event, index, mapperService, mappingType, mappingSource))) continue;
                if (typesToRefresh == null) {
                    typesToRefresh = Lists.newArrayList();
                }
                typesToRefresh.add(mappingType);
            }
            if (typesToRefresh != null) {
                this.nodeMappingRefreshAction.nodeMappingRefresh(new NodeMappingRefreshAction.NodeMappingRefreshRequest(index, typesToRefresh.toArray(new String[typesToRefresh.size()]), event.state().nodes().localNodeId()));
            }
            for (DocumentMapper documentMapper : mapperService) {
                if (!this.seenMappings.containsKey(new Tuple<String, String>(index, documentMapper.type())) || indexMetaData.mappings().containsKey(documentMapper.type())) continue;
                mapperService.remove(documentMapper.type());
                this.seenMappings.remove(new Tuple<String, String>(index, documentMapper.type()));
            }
        }
    }

    private boolean processMapping(ClusterChangedEvent event, String index, MapperService mapperService, String mappingType, CompressedString mappingSource) {
        if (!this.seenMappings.containsKey(new Tuple<String, String>(index, mappingType))) {
            this.seenMappings.put(new Tuple<String, String>(index, mappingType), true);
        }
        boolean requiresRefresh = false;
        try {
            if (!mapperService.hasMapping(mappingType)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}] adding mapping [{}], source [{}]", index, mappingType, mappingSource.string());
                }
                mapperService.add(mappingType, mappingSource.string());
                if (!mapperService.documentMapper(mappingType).mappingSource().equals(mappingSource)) {
                    this.logger.debug("[{}] parsed mapping [{}], and got different sources\noriginal:\n{}\nparsed:\n{}", index, mappingType, mappingSource, mapperService.documentMapper(mappingType).mappingSource());
                    requiresRefresh = true;
                }
                this.nodeMappingCreatedAction.nodeMappingCreated(new NodeMappingCreatedAction.NodeMappingCreatedResponse(index, mappingType, event.state().nodes().localNodeId()));
            } else {
                DocumentMapper existingMapper = mapperService.documentMapper(mappingType);
                if (!mappingSource.equals(existingMapper.mappingSource())) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("[{}] updating mapping [{}], source [{}]", index, mappingType, mappingSource.string());
                    }
                    mapperService.add(mappingType, mappingSource.string());
                    if (!mapperService.documentMapper(mappingType).mappingSource().equals(mappingSource)) {
                        requiresRefresh = true;
                        this.logger.debug("[{}] parsed mapping [{}], and got different sources\noriginal:\n{}\nparsed:\n{}", index, mappingType, mappingSource, mapperService.documentMapper(mappingType).mappingSource());
                    }
                    this.nodeMappingCreatedAction.nodeMappingCreated(new NodeMappingCreatedAction.NodeMappingCreatedResponse(index, mappingType, event.state().nodes().localNodeId()));
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("[{}] failed to add mapping [{}], source [{}]", e, index, mappingType, mappingSource);
        }
        return requiresRefresh;
    }

    private void applyNewOrUpdatedShards(ClusterChangedEvent event) throws ElasticSearchException {
        if (!this.indicesService.changesAllowed()) {
            return;
        }
        RoutingTable routingTable = event.state().routingTable();
        RoutingNode routingNodes = event.state().readOnlyRoutingNodes().nodesToShards().get(event.state().nodes().localNodeId());
        if (routingNodes == null) {
            return;
        }
        DiscoveryNodes nodes = event.state().nodes();
        for (MutableShardRouting shardRouting : routingNodes) {
            InternalIndexShard indexShard;
            IndexService indexService = this.indicesService.indexService(shardRouting.index());
            if (indexService == null) continue;
            int shardId = shardRouting.id();
            if (!indexService.hasShard(shardId) && shardRouting.started()) {
                this.logger.warn("[{}][{}] master [{}] marked shard as started, but shard have not been created, mark shard as failed", shardRouting.index(), shardId, nodes.masterNode());
                this.shardStateAction.shardFailed(shardRouting, "master " + nodes.masterNode() + " marked shard as started, but shard have not been created, mark shard as failed");
                continue;
            }
            if (indexService.hasShard(shardId) && !((Object)shardRouting).equals((indexShard = (InternalIndexShard)indexService.shard(shardId)).routingEntry())) {
                indexShard.routingEntry(shardRouting);
                indexService.shardInjector(shardId).getInstance(IndexShardGatewayService.class).routingStateChanged();
            }
            if (!shardRouting.initializing()) continue;
            this.applyInitializingShard(routingTable, nodes, shardRouting);
        }
    }

    private void applyInitializingShard(RoutingTable routingTable, DiscoveryNodes nodes, final ShardRouting shardRouting) throws ElasticSearchException {
        IndexShard indexShard;
        int shardId;
        final IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.index());
        if (indexService.hasShard(shardId = shardRouting.id())) {
            indexShard = indexService.shardSafe(shardId);
            if (indexShard.state() == IndexShardState.STARTED) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[{}][{}] master [{}] marked shard as initializing, but shard already created, mark shard as started", new Object[0]);
                }
                this.shardStateAction.shardStarted(shardRouting, "master " + nodes.masterNode() + " marked shard as initializing, but shard already started, mark shard as started");
                return;
            }
            if (indexShard.ignoreRecoveryAttempt()) {
                return;
            }
        }
        if (!indexService.hasShard(shardId)) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}] creating shard", shardRouting.index(), shardId);
                }
                indexShard = (InternalIndexShard)indexService.createShard(shardId);
                ((InternalIndexShard)indexShard).routingEntry(shardRouting);
                ((InternalIndexShard)indexShard).engine().addFailedEngineListener(this.failedEngineHandler);
            }
            catch (IndexShardAlreadyExistsException e) {
            }
            catch (Exception e) {
                this.logger.warn("[{}][{}] failed to create shard", e, shardRouting.index(), shardRouting.id());
                try {
                    indexService.removeShard(shardId, "failed to create [" + ExceptionsHelper.detailedMessage(e) + "]");
                }
                catch (IndexShardMissingException e1) {
                }
                catch (Exception e1) {
                    this.logger.warn("[{}][{}] failed to remove shard after failed creation", e1, shardRouting.index(), shardRouting.id());
                }
                this.shardStateAction.shardFailed(shardRouting, "Failed to create shard, message [" + ExceptionsHelper.detailedMessage(e) + "]");
                return;
            }
            catch (OutOfMemoryError e) {
                this.logger.warn("[{}][{}] failed to create shard", e, shardRouting.index(), shardRouting.id());
                try {
                    indexService.removeShard(shardId, "failed to create [" + ExceptionsHelper.detailedMessage(e) + "]");
                }
                catch (IndexShardMissingException e1) {
                }
                catch (Exception e1) {
                    this.logger.warn("[{}][{}] failed to remove shard after failed creation", e1, shardRouting.index(), shardRouting.id());
                }
                this.shardStateAction.shardFailed(shardRouting, "Failed to create shard, message [" + ExceptionsHelper.detailedMessage(e) + "]");
                return;
            }
        }
        if (((InternalIndexShard)(indexShard = (InternalIndexShard)indexService.shardSafe(shardId))).ignoreRecoveryAttempt()) {
            return;
        }
        if (!shardRouting.primary()) {
            IndexShardRoutingTable shardRoutingTable = routingTable.index(shardRouting.index()).shard(shardRouting.id());
            for (ShardRouting entry : shardRoutingTable) {
                if (!entry.primary() || !entry.started()) continue;
                DiscoveryNode sourceNode = nodes.get(entry.currentNodeId());
                try {
                    StartRecoveryRequest request = new StartRecoveryRequest(((AbstractIndexShardComponent)((Object)indexShard)).shardId(), sourceNode, nodes.localNode(), false, ((InternalIndexShard)indexShard).store().list());
                    this.recoveryTarget.startRecovery(request, false, new PeerRecoveryListener(request, shardRouting, indexService));
                }
                catch (Exception e) {
                    this.handleRecoveryFailure(indexService, shardRouting, true, e);
                }
                break;
            }
        } else if (shardRouting.relocatingNodeId() == null) {
            IndexShardGatewayService shardGatewayService = indexService.shardInjector(shardId).getInstance(IndexShardGatewayService.class);
            shardGatewayService.recover(new IndexShardGatewayService.RecoveryListener(){

                @Override
                public void onRecoveryDone() {
                    IndicesClusterStateService.this.shardStateAction.shardStarted(shardRouting, "after recovery from gateway");
                }

                @Override
                public void onIgnoreRecovery(String reason) {
                }

                @Override
                public void onRecoveryFailed(IndexShardGatewayRecoveryException e) {
                    IndicesClusterStateService.this.handleRecoveryFailure(indexService, shardRouting, true, e);
                }
            });
        } else {
            DiscoveryNode sourceNode = nodes.get(shardRouting.relocatingNodeId());
            try {
                StartRecoveryRequest request = new StartRecoveryRequest(((AbstractIndexShardComponent)((Object)indexShard)).shardId(), sourceNode, nodes.localNode(), false, ((InternalIndexShard)indexShard).store().list());
                this.recoveryTarget.startRecovery(request, false, new PeerRecoveryListener(request, shardRouting, indexService));
            }
            catch (Exception e) {
                this.handleRecoveryFailure(indexService, shardRouting, true, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecoveryFailure(IndexService indexService, ShardRouting shardRouting, boolean sendShardFailure, Throwable failure) {
        this.logger.warn("[{}][{}] failed to start shard", failure, indexService.index().name(), shardRouting.shardId().id());
        Object object = this.mutex;
        synchronized (object) {
            if (indexService.hasShard(shardRouting.shardId().id())) {
                try {
                    indexService.removeShard(shardRouting.shardId().id(), "recovery failure [" + ExceptionsHelper.detailedMessage(failure) + "]");
                }
                catch (IndexShardMissingException e) {
                }
                catch (Exception e1) {
                    this.logger.warn("[{}][{}] failed to delete shard after failed startup", e1, indexService.index().name(), shardRouting.shardId().id());
                }
            }
            if (sendShardFailure) {
                try {
                    this.shardStateAction.shardFailed(shardRouting, "Failed to start shard, message [" + ExceptionsHelper.detailedMessage(failure) + "]");
                }
                catch (Exception e1) {
                    this.logger.warn("[{}][{}] failed to mark shard as failed after a failed start", e1, indexService.index().name(), shardRouting.id());
                }
            }
        }
    }

    private class FailedEngineHandler
    implements Engine.FailedEngineListener {
        private FailedEngineHandler() {
        }

        @Override
        public void onFailedEngine(final ShardId shardId, final Throwable failure) {
            IndexShard indexShard;
            ShardRouting shardRouting = null;
            final IndexService indexService = IndicesClusterStateService.this.indicesService.indexService(shardId.index().name());
            if (indexService != null && (indexShard = indexService.shard(shardId.id())) != null) {
                shardRouting = indexShard.routingEntry();
            }
            if (shardRouting == null) {
                IndicesClusterStateService.this.logger.warn("[{}][{}] engine failed, but can't find index shard", shardId.index().name(), shardId.id());
                return;
            }
            final ShardRouting fShardRouting = shardRouting;
            IndicesClusterStateService.this.threadPool.cached().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = IndicesClusterStateService.this.mutex;
                    synchronized (object) {
                        if (indexService.hasShard(shardId.id())) {
                            try {
                                indexService.removeShard(shardId.id(), "engine failure [" + ExceptionsHelper.detailedMessage(failure) + "]");
                            }
                            catch (IndexShardMissingException e) {
                            }
                            catch (Exception e1) {
                                IndicesClusterStateService.this.logger.warn("[{}][{}] failed to delete shard after failed engine", e1, indexService.index().name(), shardId.id());
                            }
                        }
                        try {
                            IndicesClusterStateService.this.shardStateAction.shardFailed(fShardRouting, "engine failure, message [" + ExceptionsHelper.detailedMessage(failure) + "]");
                        }
                        catch (Exception e1) {
                            IndicesClusterStateService.this.logger.warn("[{}][{}] failed to mark shard as failed after a failed engine", e1, indexService.index().name(), shardId.id());
                        }
                    }
                }
            });
        }
    }

    private class PeerRecoveryListener
    implements RecoveryTarget.RecoveryListener {
        private final StartRecoveryRequest request;
        private final ShardRouting shardRouting;
        private final IndexService indexService;

        private PeerRecoveryListener(StartRecoveryRequest request, ShardRouting shardRouting, IndexService indexService) {
            this.request = request;
            this.shardRouting = shardRouting;
            this.indexService = indexService;
        }

        @Override
        public void onRecoveryDone() {
            IndicesClusterStateService.this.shardStateAction.shardStarted(this.shardRouting, "after recovery (replica) from node [" + this.request.sourceNode() + "]");
        }

        @Override
        public void onRetryRecovery(TimeValue retryAfter) {
            IndicesClusterStateService.this.threadPool.schedule(retryAfter, "cached", new Runnable(){

                @Override
                public void run() {
                    IndicesClusterStateService.this.recoveryTarget.startRecovery(PeerRecoveryListener.this.request, true, PeerRecoveryListener.this);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onIgnoreRecovery(boolean removeShard, String reason) {
            if (!removeShard) {
                return;
            }
            Object object = IndicesClusterStateService.this.mutex;
            synchronized (object) {
                if (this.indexService.hasShard(this.shardRouting.shardId().id())) {
                    if (IndicesClusterStateService.this.logger.isDebugEnabled()) {
                        IndicesClusterStateService.this.logger.debug("[{}][{}] removing shard on ignored recovery, reason [{}]", this.shardRouting.index(), this.shardRouting.shardId().id(), reason);
                    }
                    try {
                        this.indexService.removeShard(this.shardRouting.shardId().id(), "ignore recovery: " + reason);
                    }
                    catch (IndexShardMissingException e) {
                    }
                    catch (Exception e1) {
                        IndicesClusterStateService.this.logger.warn("[{}][{}] failed to delete shard after ignore recovery", e1, this.indexService.index().name(), this.shardRouting.shardId().id());
                    }
                }
            }
        }

        @Override
        public void onRecoveryFailure(RecoveryFailedException e, boolean sendShardFailure) {
            IndicesClusterStateService.this.handleRecoveryFailure(this.indexService, this.shardRouting, sendShardFailure, e);
        }
    }
}

