/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.query;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.xcontent.XContentIndexQueryParser;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetCollector;
import org.elasticsearch.search.facet.FacetProcessor;
import org.elasticsearch.search.facet.query.InternalQueryFacet;
import org.elasticsearch.search.facet.query.QueryFacet;
import org.elasticsearch.search.facet.query.QueryFacetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class QueryFacetProcessor
extends AbstractComponent
implements FacetProcessor {
    @Inject
    public QueryFacetProcessor(Settings settings) {
        super(settings);
        InternalQueryFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"query"};
    }

    @Override
    public FacetCollector parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentIndexQueryParser indexQueryParser = (XContentIndexQueryParser)context.queryParser();
        Query facetQuery = indexQueryParser.parse(parser).query();
        return new QueryFacetCollector(facetName, facetQuery, context.filterCache());
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        int count = 0;
        for (Facet facet : facets) {
            if (!facet.name().equals(name)) continue;
            count = (int)((long)count + ((QueryFacet)facet).count());
        }
        return new InternalQueryFacet(name, count);
    }
}

