/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.digest;

import java.security.Provider;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.jasypt.commons.CommonUtils;
import org.jasypt.digest.StandardByteDigester;
import org.jasypt.digest.StringDigester;
import org.jasypt.digest.config.DigesterConfig;
import org.jasypt.digest.config.StringDigesterConfig;
import org.jasypt.exceptions.AlreadyInitializedException;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.normalization.Normalizer;
import org.jasypt.salt.SaltGenerator;

public final class StandardStringDigester
implements StringDigester {
    public static final String MESSAGE_CHARSET = "UTF-8";
    public static final String DIGEST_CHARSET = "US-ASCII";
    public static final boolean DEFAULT_UNICODE_NORMALIZATION_IGNORED = false;
    public static final String DEFAULT_STRING_OUTPUT_TYPE = "base64";
    private final StandardByteDigester byteDigester = new StandardByteDigester();
    private StringDigesterConfig stringDigesterConfig = null;
    private boolean unicodeNormalizationIgnored = false;
    private String stringOutputType = "base64";
    private boolean stringOutputTypeBase64 = true;
    private boolean unicodeNormalizationIgnoredSet = false;
    private boolean stringOutputTypeSet = false;
    private final Base64 base64 = new Base64();

    public synchronized void setConfig(DigesterConfig config) {
        this.byteDigester.setConfig(config);
        if (config != null && config instanceof StringDigesterConfig) {
            this.stringDigesterConfig = (StringDigesterConfig)config;
        }
    }

    public void setAlgorithm(String algorithm) {
        this.byteDigester.setAlgorithm(algorithm);
    }

    public void setSaltSizeBytes(int saltSizeBytes) {
        this.byteDigester.setSaltSizeBytes(saltSizeBytes);
    }

    public void setIterations(int iterations) {
        this.byteDigester.setIterations(iterations);
    }

    public void setSaltGenerator(SaltGenerator saltGenerator) {
        this.byteDigester.setSaltGenerator(saltGenerator);
    }

    public void setProviderName(String providerName) {
        this.byteDigester.setProviderName(providerName);
    }

    public void setProvider(Provider provider) {
        this.byteDigester.setProvider(provider);
    }

    public synchronized void setUnicodeNormalizationIgnored(boolean unicodeNormalizationIgnored) {
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.unicodeNormalizationIgnored = unicodeNormalizationIgnored;
        this.unicodeNormalizationIgnoredSet = true;
    }

    public synchronized void setStringOutputType(String stringOutputType) {
        Validate.notEmpty((String)stringOutputType, (String)"String output type cannot be set empty");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.stringOutputType = CommonUtils.getStandardStringOutputType(stringOutputType);
        this.stringOutputTypeSet = true;
    }

    public synchronized boolean isInitialized() {
        return this.byteDigester.isInitialized();
    }

    public synchronized void initialize() {
        if (!this.isInitialized()) {
            if (this.stringDigesterConfig != null) {
                Boolean configUnicodeNormalizationIgnored = this.stringDigesterConfig.isUnicodeNormalizationIgnored();
                String configStringOutputType = this.stringDigesterConfig.getStringOutputType();
                this.unicodeNormalizationIgnored = this.unicodeNormalizationIgnoredSet || configUnicodeNormalizationIgnored == null ? this.unicodeNormalizationIgnored : configUnicodeNormalizationIgnored;
                this.stringOutputType = this.stringOutputTypeSet || configStringOutputType == null ? this.stringOutputType : configStringOutputType;
            }
            this.stringOutputTypeBase64 = DEFAULT_STRING_OUTPUT_TYPE.equalsIgnoreCase(this.stringOutputType);
            this.byteDigester.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String digest(String message) {
        if (message == null) {
            return null;
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        try {
            String normalizedMessage = null;
            normalizedMessage = !this.unicodeNormalizationIgnored ? Normalizer.normalizeToNfc(message) : message;
            byte[] messageBytes = normalizedMessage.getBytes(MESSAGE_CHARSET);
            byte[] digest = this.byteDigester.digest(messageBytes);
            String result = null;
            if (this.stringOutputTypeBase64) {
                Base64 base64 = this.base64;
                synchronized (base64) {
                    digest = this.base64.encode(digest);
                }
                result = new String(digest, DIGEST_CHARSET);
            } else {
                result = CommonUtils.toHexadecimal(digest);
            }
            return result;
        }
        catch (EncryptionInitializationException e) {
            throw e;
        }
        catch (EncryptionOperationNotPossibleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncryptionOperationNotPossibleException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(String message, String digest) {
        if (message == null) {
            return digest == null;
        }
        if (digest == null) {
            return false;
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        try {
            String normalizedMessage = null;
            normalizedMessage = !this.unicodeNormalizationIgnored ? Normalizer.normalizeToNfc(message) : message;
            byte[] messageBytes = normalizedMessage.getBytes(MESSAGE_CHARSET);
            byte[] digestBytes = null;
            if (this.stringOutputTypeBase64) {
                digestBytes = digest.getBytes(DIGEST_CHARSET);
                Base64 base64 = this.base64;
                synchronized (base64) {
                    digestBytes = this.base64.decode(digestBytes);
                }
            } else {
                digestBytes = CommonUtils.fromHexadecimal(digest);
            }
            return this.byteDigester.matches(messageBytes, digestBytes);
        }
        catch (EncryptionInitializationException e) {
            throw e;
        }
        catch (EncryptionOperationNotPossibleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncryptionOperationNotPossibleException();
        }
    }
}

