/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi;

import java.io.File;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.fusesource.fabric.fab.osgi.ServiceConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabDeploymentListener
implements ArtifactUrlTransformer {
    private final Logger logger = LoggerFactory.getLogger(FabDeploymentListener.class);
    private DocumentBuilderFactory dbf;
    private boolean deployNonBundles = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canHandle(File artifact) {
        boolean bl;
        String path = artifact.getPath();
        if (path.endsWith(".fab")) {
            return true;
        }
        if (!path.endsWith(".jar")) {
            return false;
        }
        JarFile jar = new JarFile(artifact);
        try {
            Manifest manifest = jar.getManifest();
            boolean answer = false;
            boolean bundle = false;
            if (manifest != null) {
                Attributes attributes = manifest.getMainAttributes();
                bundle = this.isBundle(attributes);
                for (String name : ServiceConstants.FAB_PROPERTY_NAMES) {
                    if (attributes.getValue(name) == null) continue;
                    answer = true;
                    break;
                }
            }
            if (!answer && this.isDeployNonBundles()) {
                boolean bl2 = answer = !bundle;
                if (answer) {
                    this.logger.info("Interpreting the non-bundle jar as a FAB: " + artifact);
                }
            }
            System.out.println("Fab deploy of a jar answer: " + answer + " bundle: " + bundle + " isDeployNonBundles: " + this.isDeployNonBundles() + " manifest: " + manifest);
            bl = answer;
        }
        catch (Throwable throwable) {
            try {
                jar.close();
                throw throwable;
            }
            catch (Exception e) {
                this.logger.error("Unable to parse deployed file " + artifact.getAbsolutePath(), (Throwable)e);
                return false;
            }
        }
        jar.close();
        return bl;
    }

    protected boolean isBundle(Attributes attributes) {
        return attributes.getValue("Bundle-SymbolicName") != null;
    }

    public URL transform(URL artifact) {
        try {
            return new URL("fab", null, artifact.toString());
        }
        catch (Exception e) {
            this.logger.error("Unable to build blueprint application bundle", (Throwable)e);
            return null;
        }
    }

    public boolean isDeployNonBundles() {
        return this.deployNonBundles;
    }

    public void setDeployNonBundles(boolean deployNonBundles) {
        this.deployNonBundles = deployNonBundles;
    }
}

