/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.commands;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.fusesource.fabric.fab.osgi.FabURLHandler;
import org.fusesource.fabric.fab.osgi.internal.BundleFabFacade;
import org.fusesource.fabric.fab.osgi.internal.FabClassPathResolver;
import org.fusesource.fabric.fab.osgi.internal.FabConnection;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.sonatype.aether.RepositoryException;

public abstract class CommandSupport
extends OsgiCommandSupport {
    private PackageAdmin admin;

    protected PackageAdmin getPackageAdmin() {
        if (this.admin == null) {
            ServiceReference ref = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
            if (ref == null) {
                System.out.println("PackageAdmin service is unavailable.");
                return null;
            }
            this.admin = (PackageAdmin)this.getService(PackageAdmin.class, ref);
        }
        return this.admin;
    }

    protected void println() {
        this.session.getConsole().println();
    }

    protected void println(String msg, Object ... args) {
        this.session.getConsole().println(String.format(msg, args));
    }

    protected FabClassPathResolver createFabResolver(Bundle bundle) throws RepositoryException, IOException, XmlPullParserException, BundleException {
        Properties instructions = new Properties();
        Dictionary headers = bundle.getHeaders();
        Enumeration e = headers.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = headers.get(key);
            if (!(key instanceof String) || !(value instanceof String)) continue;
            instructions.setProperty((String)key, (String)value);
        }
        BundleFabFacade facade = new BundleFabFacade(bundle);
        HashMap<String, Object> embeddedResources = new HashMap<String, Object>();
        FabClassPathResolver resolver = new FabClassPathResolver(facade, instructions, embeddedResources);
        resolver.resolve();
        return resolver;
    }

    protected FabURLHandler findURLHandler() throws InvalidSyntaxException {
        ServiceReference[] references;
        for (ServiceReference reference : references = this.bundleContext.getServiceReferences("org.osgi.service.url.URLStreamHandlerService", null)) {
            Object service = this.bundleContext.getService(reference);
            if (!(service instanceof FabURLHandler)) continue;
            return (FabURLHandler)((Object)service);
        }
        return null;
    }

    protected FabClassPathResolver createResolver(String arg) throws RepositoryException, IOException, XmlPullParserException, BundleException, InvalidSyntaxException {
        FabClassPathResolver resolver = null;
        if (arg.matches("\\d+")) {
            Long id = null;
            try {
                id = Long.parseLong(arg);
            }
            catch (NumberFormatException e) {
                System.err.println("Failed to parse bundle ID: " + arg + ". Reason: " + e);
            }
            Bundle bundle = this.bundleContext.getBundle(id.longValue());
            if (bundle != null) {
                resolver = this.createFabResolver(bundle);
            } else {
                System.err.println("Bundle ID " + id + " is invalid");
            }
        } else {
            FabURLHandler handler = this.findURLHandler();
            if (handler != null) {
                File file = new File(arg);
                String u = arg;
                if (file.exists()) {
                    u = file.toURI().toURL().toString();
                }
                if (!arg.startsWith("fab:")) {
                    u = "fab:" + u;
                }
                FabConnection urlConnection = handler.openConnection(new URL(u));
                resolver = urlConnection.resolve();
            } else {
                this.println("ERROR: could not resolve FabURLHandler service in OSGi", new Object[0]);
            }
        }
        return resolver;
    }

    public static class Table {
        final String format;
        private final int[] col;
        final ArrayList<ArrayList<Object>> table = new ArrayList();

        public Table(String format, int ... col) {
            this.format = format;
            this.col = col;
        }

        public void add(Object ... values) {
            if (values.length != this.col.length) {
                throw new IllegalArgumentException("Expected " + this.col.length + " arguments");
            }
            this.table.add(new ArrayList<Object>(Arrays.asList(values)));
        }

        public void print(PrintStream out) {
            String fmt = this.format;
            for (int i = 0; i < this.col.length; ++i) {
                String token = "{" + (i + 1) + "}";
                if (!fmt.contains(token)) continue;
                if (this.col[i] != 0) {
                    int len = Math.abs(this.col[i]);
                    for (ArrayList<Object> row : this.table) {
                        Object o = row.get(i);
                        if (o == null) {
                            o = "";
                        }
                        String s = o.toString();
                        row.set(i, s);
                        len = Math.max(s.length(), len);
                    }
                    if (this.col[i] < 0) {
                        len *= -1;
                    }
                    fmt = fmt.replaceAll(Pattern.quote(token), "%" + len + "s");
                    continue;
                }
                fmt = fmt.replaceAll(Pattern.quote(token), "%s");
            }
            for (ArrayList<Object> row : this.table) {
                out.println(String.format(fmt, row.toArray()));
            }
        }
    }
}

