/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.internal;

import aQute.lib.osgi.Analyzer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fusesource.fabric.fab.osgi.internal.VersionResolver;
import org.fusesource.fabric.fab.osgi.internal.Versions;
import org.fusesource.fabric.fab.util.Objects;
import org.fusesource.fabric.fab.util.Strings;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class Bundles {
    public static boolean isInstalled(BundleContext bundleContext, String name, String version) {
        return Bundles.findBundle(bundleContext, name, version) != null;
    }

    public static Set<String> filterInstalled(BundleContext bundleContext, Collection<String> packages, VersionResolver resolver) {
        HashSet<String> rc = new HashSet<String>(packages);
        for (Bundle bundle : bundleContext.getBundles()) {
            if (rc.isEmpty()) break;
            String value = (String)bundle.getHeaders().get("Export-Package");
            if (!Strings.notEmpty(value)) continue;
            Map values = new Analyzer().parseHeader(value);
            for (String packageName : packages) {
                String importedVersion;
                String version;
                Map map = (Map)values.get(packageName);
                if (map == null || (version = (String)map.get("version")) == null || (importedVersion = resolver.resolvePackageVersion(packageName)) == null || !Versions.inRange(version, importedVersion)) continue;
                rc.remove(packageName);
            }
        }
        return rc;
    }

    public static Bundle findBundle(BundleContext bundleContext, String name, String version) {
        Bundle[] bundles;
        Version v = Versions.fromMavenVersion(version);
        for (Bundle bundle : bundles = bundleContext.getBundles()) {
            if (!Objects.equal(bundle.getSymbolicName(), name) || !Objects.equal(bundle.getVersion(), v)) continue;
            return bundle;
        }
        return null;
    }

    public static boolean isFragment(Bundle bundle) {
        return Strings.notEmpty((String)bundle.getHeaders().get("Fragment-Host"));
    }
}

