/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.internal;

import aQute.lib.osgi.Analyzer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.utils.version.VersionCleaner;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.fusesource.fabric.fab.DependencyTree;
import org.fusesource.fabric.fab.MavenResolver;
import org.fusesource.fabric.fab.PomDetails;
import org.fusesource.fabric.fab.VersionedDependencyId;
import org.fusesource.fabric.fab.osgi.internal.BndUtils;
import org.fusesource.fabric.fab.osgi.internal.Bundles;
import org.fusesource.fabric.fab.osgi.internal.Configuration;
import org.fusesource.fabric.fab.osgi.internal.FabClassPathResolver;
import org.fusesource.fabric.fab.osgi.internal.FabFacade;
import org.fusesource.fabric.fab.osgi.internal.OverwriteMode;
import org.fusesource.fabric.fab.osgi.internal.VersionResolver;
import org.fusesource.fabric.fab.osgi.internal.Versions;
import org.fusesource.fabric.fab.util.Files;
import org.fusesource.fabric.fab.util.Filter;
import org.fusesource.fabric.fab.util.Objects;
import org.fusesource.fabric.fab.util.Strings;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.lang.PreConditionException;
import org.ops4j.net.URLUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.graph.Dependency;

public class FabConnection
extends URLConnection
implements FabFacade,
VersionResolver {
    private static final transient Logger LOG = LoggerFactory.getLogger(FabConnection.class);
    private Configuration configuration;
    private String[] mavenRepositories;
    private final BundleContext bundleContext;
    private PomDetails pomDetails;
    private MavenResolver resolver = new MavenResolver();
    private boolean includeSharedResources = true;
    private FabClassPathResolver classPathResolver;
    private Model model;
    private DependencyTree rootTree;

    public FabConnection(URL url, Configuration config, BundleContext bundleContext) throws MalformedURLException {
        super(url);
        this.bundleContext = bundleContext;
        NullArgumentException.validateNotNull((Object)url, (String)"URL");
        NullArgumentException.validateNotNull((Object)((Object)config), (String)"Configuration");
        String path = url.getPath();
        if (path == null || path.trim().length() == 0) {
            throw new MalformedURLException("Path cannot empty");
        }
        this.configuration = config;
        String[] repositories = this.configuration.getMavenRepositories();
        if (repositories != null) {
            this.resolver.setRepositories(repositories);
        }
    }

    @Override
    public void connect() {
    }

    @Override
    public DependencyTree collectDependencyTree(boolean offline, Filter<Dependency> excludeDependencyFilter) throws RepositoryException, IOException, XmlPullParserException {
        if (this.rootTree == null) {
            PomDetails details = this.resolvePomDetails();
            Objects.notNull(details, "pomDetails");
            try {
                this.rootTree = this.getResolver().collectDependencies(details, offline, excludeDependencyFilter).getTree();
            }
            catch (IOException e) {
                this.logFailure(e);
                throw e;
            }
            catch (XmlPullParserException e) {
                this.logFailure((Exception)((Object)e));
                throw e;
            }
            catch (RepositoryException e) {
                this.logFailure((Exception)((Object)e));
                throw e;
            }
        }
        return this.rootTree;
    }

    public void setRootTree(DependencyTree rootTree) {
        this.rootTree = rootTree;
    }

    protected void logFailure(Exception e) {
        LOG.error(e.getMessage());
        Throwable cause = e.getCause();
        if (cause != null && cause != e) {
            LOG.error("Caused by: " + e, (Throwable)e);
        }
    }

    @Override
    public VersionedDependencyId getVersionedDependencyId() throws IOException, XmlPullParserException {
        PomDetails pomDetails = this.resolvePomDetails();
        if (pomDetails == null || !pomDetails.isValid()) {
            LOG.warn("Cannot resolve pom.xml for " + this.getJarFile());
            return null;
        }
        this.model = pomDetails.getModel();
        return new VersionedDependencyId(this.model);
    }

    @Override
    public String getProjectDescription() {
        if (this.model != null) {
            return this.model.getDescription();
        }
        return null;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public MavenResolver getResolver() {
        return this.resolver;
    }

    public PomDetails getPomDetails() {
        return this.pomDetails;
    }

    public void setPomDetails(PomDetails pomDetails) {
        this.pomDetails = pomDetails;
    }

    @Override
    public File getJarFile() throws IOException {
        return Files.urlToFile(this.getURL(), "fabric-tmp-fab-", ".fab");
    }

    @Override
    public boolean isIncludeSharedResources() {
        return this.includeSharedResources;
    }

    public void setIncludeSharedResources(boolean includeSharedResources) {
        this.includeSharedResources = includeSharedResources;
    }

    public FabConnection createChild(URL url) throws MalformedURLException {
        return new FabConnection(url, this.configuration, this.bundleContext);
    }

    @Override
    public PomDetails resolvePomDetails() throws IOException {
        PomDetails pomDetails = this.getPomDetails();
        if (pomDetails == null) {
            File fileJar = this.getJarFile();
            pomDetails = this.getResolver().findPomFile(fileJar);
        }
        return pomDetails;
    }

    public FabClassPathResolver resolve() throws BundleException, RepositoryException, IOException, XmlPullParserException {
        HashMap<String, Object> embeddedResources = new HashMap<String, Object>();
        Properties instructions = this.createInstructions(embeddedResources);
        return this.classPathResolver;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        try {
            HashMap<String, Object> embeddedResources = new HashMap<String, Object>();
            Properties instructions = this.createInstructions(embeddedResources);
            PreConditionException.validateNotNull((Object)instructions, (String)"Instructions");
            String fabUri = instructions.getProperty("FAB-URL");
            if (fabUri == null || fabUri.trim().length() == 0) {
                throw new IOException("Instructions file must contain a property named FAB-URL");
            }
            HashSet<String> actualImports = new HashSet<String>();
            InputStream rc = BndUtils.createBundle(URLUtils.prepareInputStream((URL)new URL(fabUri), (boolean)this.configuration.getCertificateCheck()), instructions, fabUri, OverwriteMode.MERGE, embeddedResources, this.classPathResolver.getExtraImportPackages(), actualImports, this);
            if (this.getConfiguration().isInstallMissingDependencies()) {
                this.installMissingDependencies(actualImports);
            } else {
                LOG.info("Not installing dependencies as not enabled");
            }
            return rc;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected void installMissingDependencies(HashSet<String> actualImports) throws IOException, BundleException {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext == null) {
            LOG.warn("No BundleContext available so cannot install provided dependencies");
        } else {
            for (DependencyTree dependency : this.classPathResolver.getInstallDependencies()) {
                String importPackages;
                if (!dependency.isBundle() || !Strings.notEmpty(importPackages = dependency.getManifestEntry("Import-Package"))) continue;
                Map values = new Analyzer().parseHeader(importPackages);
                for (Map.Entry entry : values.entrySet()) {
                    String res = (String)((Map)entry.getValue()).get("resolution:");
                    if ("optional".equals(res)) continue;
                    actualImports.add((String)entry.getKey());
                }
            }
            for (DependencyTree dependency : this.classPathResolver.getInstallDependencies()) {
                String version;
                String name = dependency.getBundleSymbolicName();
                if (Bundles.isInstalled(bundleContext, name, version = dependency.getVersion())) {
                    LOG.info("Bundle already installed: " + name + " (" + version + ")");
                    continue;
                }
                HashSet<String> p = new HashSet<String>(dependency.getPackages());
                p.retainAll(actualImports);
                Set<String> missing = Bundles.filterInstalled(bundleContext, p, this);
                boolean hasNoPendingPackagesOrServices = false;
                if (missing.isEmpty()) {
                    String services = dependency.getManifestEntry("Export-Service");
                    if (Strings.notEmpty(services)) {
                        LOG.info("Bundle non-optional packages already installed for: " + name + " version: " + version + " but it exposes services so will install: " + services);
                    } else {
                        hasNoPendingPackagesOrServices = true;
                    }
                }
                if (hasNoPendingPackagesOrServices) {
                    LOG.info("Bundle non-optional packages already installed for: " + name + " version: " + version + " packages: " + p);
                    continue;
                }
                LOG.info("Packages not yet shared: " + missing);
                URL url = dependency.getJarURL();
                String installUri = url.toExternalForm();
                try {
                    Bundle bundle = null;
                    if (!dependency.isBundle()) {
                        FabConnection childConnection = this.createChild(url);
                        childConnection.setRootTree(dependency);
                        PomDetails pomDetails = childConnection.resolvePomDetails();
                        if (pomDetails != null && pomDetails.isValid()) {
                            LOG.info("Installing fabric bundle: " + name + " from: " + installUri);
                            bundle = bundleContext.installBundle(installUri, childConnection.getInputStream());
                            continue;
                        }
                        LOG.warn("Could not deduce the pom.xml for the jar " + installUri + " so cannot treat as FAB");
                        continue;
                    }
                    LOG.info("Installing bundle: " + name + " from: " + installUri);
                    bundle = bundleContext.installBundle(installUri);
                }
                catch (BundleException e) {
                    LOG.error("Failed to deploy " + installUri + " due to error: " + (Object)((Object)e), (Throwable)e);
                    throw e;
                }
                catch (IOException e) {
                    LOG.error("Failed to deploy " + installUri + " due to error: " + e, (Throwable)e);
                    throw e;
                }
                catch (RuntimeException e) {
                    LOG.error("Failed to deploy " + installUri + " due to error: " + e, (Throwable)e);
                    throw e;
                }
            }
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected Properties createInstructions(Map<String, Object> embeddedResources) throws IOException, RepositoryException, XmlPullParserException, BundleException {
        Properties instructions = BndUtils.parseInstructions(this.getURL().getQuery());
        String urlText = this.getURL().toExternalForm();
        instructions.setProperty("FAB-URL", urlText);
        this.configureInstructions(instructions, embeddedResources);
        return instructions;
    }

    protected void configureInstructions(Properties instructions, Map<String, Object> embeddedResources) throws RepositoryException, IOException, XmlPullParserException, BundleException {
        this.classPathResolver = new FabClassPathResolver(this, instructions, embeddedResources);
        this.classPathResolver.resolve();
    }

    @Override
    public String resolvePackageVersion(String packageName) {
        DependencyTree dependency = this.resolvePackageDependency(packageName);
        if (dependency != null) {
            String version;
            Map values;
            Map map;
            String exportPackages;
            if (dependency.isBundle() && Strings.notEmpty(exportPackages = dependency.getManifestEntry("Export-Package")) && (map = (Map)(values = new Analyzer().parseHeader(exportPackages)).get(packageName)) != null) {
                String version2 = (String)map.get("version");
                if (version2 == null) {
                    version2 = (String)map.get("specification-version");
                }
                if (version2 != null) {
                    return this.toVersionRange(version2);
                }
            }
            if ((version = dependency.getVersion()) != null) {
                String osgiVersion = VersionCleaner.clean((String)version);
                return this.toVersionRange(osgiVersion);
            }
        }
        return null;
    }

    @Override
    public String resolveExportPackageVersion(String packageName) {
        ArrayList<DependencyTree> dependencies = new ArrayList<DependencyTree>(this.classPathResolver.getSharedDependencies());
        dependencies.add(this.classPathResolver.getRootTree());
        DependencyTree dependency = this.resolvePackageDependency(packageName, dependencies);
        if (dependency != null) {
            return Versions.getOSGiPackageVersion(dependency, packageName);
        }
        return null;
    }

    @Override
    public boolean isPackageOptional(String packageName) {
        DependencyTree dependency = this.resolvePackageDependency(packageName);
        if (dependency != null) {
            return dependency.isThisOrDescendantOptional() && this.classPathResolver.getOptionalDependencyFilter().matches(dependency);
        }
        return true;
    }

    public DependencyTree resolvePackageDependency(String packageName) {
        return this.resolvePackageDependency(packageName, this.classPathResolver.getSharedDependencies());
    }

    protected DependencyTree resolvePackageDependency(String packageName, List<DependencyTree> dependencies) {
        for (DependencyTree dependency : dependencies) {
            try {
                Set<String> packages = dependency.getPackages();
                if (!packages.contains(packageName)) continue;
                return dependency;
            }
            catch (IOException e) {
                LOG.warn("Failed to get the packages on dependency: " + dependency + ". " + e, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String toVersionRange(String version) {
        int digits = 3;
        String value = this.classPathResolver.getManifestProperty("FAB-Version-Range-Digits");
        if (Strings.notEmpty(value)) {
            try {
                digits = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LOG.warn("Failed to parse manifest header FAB-Version-Range-Digits as a number. Got: '" + value + "' so ignoring it");
            }
            if (digits < 0 || digits > 4) {
                LOG.warn("Invalid value of manifest header FAB-Version-Range-Digits as value " + digits + " is out of range so ignoring it");
                digits = 3;
            }
        }
        return Versions.toVersionRange(version, digits);
    }
}

