/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.commands;

import java.util.List;
import org.apache.karaf.shell.console.Completer;
import org.apache.zookeeper.KeeperException;
import org.linkedin.zookeeper.client.IZKClient;

public class ZNodeCompleter
implements Completer {
    private IZKClient zk;

    public ZNodeCompleter() {
        this.zk = this.zk;
    }

    public void setZooKeeper(IZKClient zk) {
        this.zk = zk;
    }

    public int complete(String buffer, int cursor, List candidates) {
        if (buffer == null) {
            candidates.add("/");
            return 1;
        }
        if (!buffer.startsWith("/")) {
            return 0;
        }
        String path = buffer = buffer.substring(0, cursor);
        int idx = path.lastIndexOf("/") + 1;
        String prefix = path.substring(idx);
        try {
            String dir = idx == 1 ? "/" : path.substring(0, idx - 1);
            List children = this.zk.getChildren(dir, false);
            for (String child : children) {
                if (!child.startsWith(prefix)) continue;
                candidates.add(child);
            }
        }
        catch (InterruptedException e) {
            return 0;
        }
        catch (KeeperException e) {
            return 0;
        }
        return candidates.size() == 0 ? buffer.length() : buffer.lastIndexOf("/") + 1;
    }
}

