/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.transport.stomp.FrameTranslator;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;

public class LegacyFrameTranslator
implements FrameTranslator {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ActiveMQMessage convertFrame(ProtocolConverter converter, StompFrame command) throws JMSException, ProtocolException {
        void var4_20;
        Map<String, String> headers = command.getHeaders();
        if (headers.containsKey("amq-msg-type")) {
            String intendedType = headers.get("amq-msg-type");
            if (intendedType.equalsIgnoreCase("text")) {
                ActiveMQTextMessage text = new ActiveMQTextMessage();
                try {
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream(command.getContent().length + 4);
                    DataOutputStream data = new DataOutputStream(bytes);
                    data.writeInt(command.getContent().length);
                    data.write(command.getContent());
                    text.setContent(bytes.toByteSequence());
                }
                catch (Throwable e) {
                    throw new ProtocolException("Text could not bet set: " + e, false, e);
                }
                ActiveMQTextMessage activeMQTextMessage = text;
            } else {
                if (!intendedType.equalsIgnoreCase("bytes")) throw new ProtocolException("Unsupported message type '" + intendedType + "'", false);
                ActiveMQBytesMessage byteMessage = new ActiveMQBytesMessage();
                byteMessage.writeBytes(command.getContent());
                ActiveMQBytesMessage activeMQBytesMessage = byteMessage;
            }
        } else if (headers.containsKey("content-length")) {
            headers.remove("content-length");
            ActiveMQBytesMessage bm = new ActiveMQBytesMessage();
            bm.writeBytes(command.getContent());
            ActiveMQBytesMessage activeMQBytesMessage = bm;
        } else {
            ActiveMQTextMessage text = new ActiveMQTextMessage();
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream(command.getContent().length + 4);
                DataOutputStream data = new DataOutputStream(bytes);
                data.writeInt(command.getContent().length);
                data.write(command.getContent());
                text.setContent(bytes.toByteSequence());
            }
            catch (Throwable e) {
                throw new ProtocolException("Text could not bet set: " + e, false, e);
            }
            ActiveMQTextMessage activeMQTextMessage = text;
        }
        FrameTranslator.Helper.copyStandardHeadersFromFrameToMessage(converter, command, (ActiveMQMessage)var4_20, this);
        return var4_20;
    }

    @Override
    public StompFrame convertMessage(ProtocolConverter converter, ActiveMQMessage message) throws IOException, JMSException {
        StompFrame command = new StompFrame();
        command.setAction("MESSAGE");
        HashMap<String, String> headers = new HashMap<String, String>(25);
        command.setHeaders(headers);
        FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(converter, message, command, this);
        if (message.getDataStructureType() == 28) {
            if (!message.isCompressed() && message.getContent() != null) {
                ByteSequence msgContent = message.getContent();
                if (msgContent.getLength() > 4) {
                    byte[] content = new byte[msgContent.getLength() - 4];
                    System.arraycopy(msgContent.data, 4, content, 0, content.length);
                    command.setContent(content);
                }
            } else {
                ActiveMQTextMessage msg = (ActiveMQTextMessage)message.copy();
                command.setContent(msg.getText().getBytes("UTF-8"));
            }
        } else if (message.getDataStructureType() == 24) {
            ActiveMQBytesMessage msg = (ActiveMQBytesMessage)message.copy();
            msg.setReadOnlyBody(true);
            byte[] data = new byte[(int)msg.getBodyLength()];
            msg.readBytes(data);
            headers.put("content-length", Integer.toString(data.length));
            command.setContent(data);
        } else if (message.getDataStructureType() == 23 && "Advisory".equals(message.getType())) {
            FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(converter, message, command, this);
            String body = this.marshallAdvisory(message.getDataStructure());
            command.setContent(body.getBytes("UTF-8"));
        }
        return command;
    }

    @Override
    public String convertDestination(ProtocolConverter converter, Destination d) {
        if (d == null) {
            return null;
        }
        ActiveMQDestination activeMQDestination = (ActiveMQDestination)d;
        String physicalName = activeMQDestination.getPhysicalName();
        String rc = converter.getCreatedTempDestinationName(activeMQDestination);
        if (rc != null) {
            return rc;
        }
        StringBuilder buffer = new StringBuilder();
        if (activeMQDestination.isQueue()) {
            if (activeMQDestination.isTemporary()) {
                buffer.append("/remote-temp-queue/");
            } else {
                buffer.append("/queue/");
            }
        } else if (activeMQDestination.isTemporary()) {
            buffer.append("/remote-temp-topic/");
        } else {
            buffer.append("/topic/");
        }
        buffer.append(physicalName);
        return buffer.toString();
    }

    @Override
    public ActiveMQDestination convertDestination(ProtocolConverter converter, String name, boolean forceFallback) throws ProtocolException {
        if (name == null) {
            return null;
        }
        if (name.startsWith("/queue/")) {
            String qName = name.substring("/queue/".length(), name.length());
            return ActiveMQDestination.createDestination(qName, (byte)1);
        }
        if (name.startsWith("/topic/")) {
            String tName = name.substring("/topic/".length(), name.length());
            return ActiveMQDestination.createDestination(tName, (byte)2);
        }
        if (name.startsWith("/remote-temp-queue/")) {
            String tName = name.substring("/remote-temp-queue/".length(), name.length());
            return ActiveMQDestination.createDestination(tName, (byte)5);
        }
        if (name.startsWith("/remote-temp-topic/")) {
            String tName = name.substring("/remote-temp-topic/".length(), name.length());
            return ActiveMQDestination.createDestination(tName, (byte)6);
        }
        if (name.startsWith("/temp-queue/")) {
            return converter.createTempQueue(name);
        }
        if (name.startsWith("/temp-topic/")) {
            return converter.createTempTopic(name);
        }
        if (forceFallback) {
            try {
                ActiveMQDestination fallback = ActiveMQDestination.getUnresolvableDestinationTransformer().transform(name);
                if (fallback != null) {
                    return fallback;
                }
            }
            catch (JMSException e) {
                throw new ProtocolException("Illegal destination name: [" + name + "] -- ActiveMQ STOMP destinations " + "must begin with one of: /queue/ /topic/ /temp-queue/ /temp-topic/", false, e);
            }
        }
        throw new ProtocolException("Illegal destination name: [" + name + "] -- ActiveMQ STOMP destinations " + "must begin with one of: /queue/ /topic/ /temp-queue/ /temp-topic/");
    }

    protected String marshallAdvisory(DataStructure ds) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
        xstream.setMode(1001);
        xstream.aliasPackage("", "org.apache.activemq.command");
        return xstream.toXML((Object)ds);
    }
}

