/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.karaf.admin.management.AdminServiceMBean;
import org.fusesource.fabric.api.Agent;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.service.AgentCachingJmxTemplate;
import org.fusesource.fabric.service.FabricServiceImplMBean;
import org.fusesource.fabric.service.JmxTemplateSupport;
import org.fusesource.fabric.service.NonCachingJmxTemplate;
import org.fusesource.insight.log.service.LogQueryCallback;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.ServiceStateMBean;

public class AgentTemplate {
    private final Agent agent;
    private final JmxTemplateSupport jmxTemplate;
    protected String login = "admin";
    protected String password = "admin";

    public AgentTemplate(Agent agent, boolean cacheJmx) {
        this.agent = agent;
        this.jmxTemplate = cacheJmx ? new AgentCachingJmxTemplate(this) : new NonCachingJmxTemplate(){

            @Override
            protected JMXConnector createConnector() {
                return AgentTemplate.this.createConnector();
            }
        };
    }

    public AgentTemplate(Agent agent, boolean cacheJmx, String login, String password) {
        this(agent, cacheJmx);
        this.login = login;
        this.password = password;
    }

    public AgentTemplate(Agent agent, JmxTemplateSupport jmxTemplate) {
        this.jmxTemplate = jmxTemplate;
        this.agent = agent;
    }

    public <T> T execute(JmxTemplateSupport.JmxConnectorCallback<T> callback) {
        return this.jmxTemplate.execute(callback);
    }

    public <T> T execute(LogQueryCallback<T> callback) {
        return this.jmxTemplate.execute(callback);
    }

    public <T> T execute(final AdminServiceCallback<T> callback) {
        return this.jmxTemplate.execute(new JmxTemplateSupport.JmxConnectorCallback<T>(){

            @Override
            public T doWithJmxConnector(JMXConnector connector) throws Exception {
                String[] bean = new String[]{"type", "admin", "name", AgentTemplate.this.agent.getId()};
                return callback.doWithAdminService(AgentTemplate.this.jmxTemplate.getMBean(connector, AdminServiceMBean.class, "org.apache.karaf", bean));
            }
        });
    }

    public <T> T execute(final FabricServiceCallback<T> callback) {
        return this.jmxTemplate.execute(new JmxTemplateSupport.JmxConnectorCallback<T>(){

            @Override
            public T doWithJmxConnector(JMXConnector connector) throws Exception {
                String[] bean = new String[]{"type", "FabricService"};
                return callback.doWithFabricService(AgentTemplate.this.jmxTemplate.getMBean(connector, FabricServiceImplMBean.class, "org.fusesource.fabric", bean));
            }
        });
    }

    public <T> T execute(final BundleStateCallback<T> callback) {
        return this.jmxTemplate.execute(new JmxTemplateSupport.JmxConnectorCallback<T>(){

            @Override
            public T doWithJmxConnector(JMXConnector connector) throws Exception {
                String[] bean = new String[]{"type", "bundleState", "version", "1.5"};
                return callback.doWithBundleState(AgentTemplate.this.jmxTemplate.getMBean(connector, BundleStateMBean.class, "osgi.core", bean));
            }
        });
    }

    public <T> T execute(final ServiceStateCallback<T> callback) {
        return this.jmxTemplate.execute(new JmxTemplateSupport.JmxConnectorCallback<T>(){

            @Override
            public T doWithJmxConnector(JMXConnector connector) throws Exception {
                String[] bean = new String[]{"type", "serviceState", "version", "1.5"};
                return callback.doWithServiceState(AgentTemplate.this.jmxTemplate.getMBean(connector, ServiceStateMBean.class, "osgi.core", bean));
            }
        });
    }

    public static Map getEnvCred(String login, String password) {
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        env.put("jmx.remote.credentials", new String[]{login, password});
        return env;
    }

    public Map getEnvironmentCredentials() {
        return AgentTemplate.getEnvCred(this.login, this.password);
    }

    public Agent getAgent() {
        return this.agent;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public JmxTemplateSupport getJmxTemplate() {
        return this.jmxTemplate;
    }

    public JMXConnector createConnector() {
        JMXConnector connector;
        String rootUrl = this.agent.getJmxUrl();
        if (rootUrl == null) {
            return null;
        }
        try {
            connector = JMXConnectorFactory.connect(new JMXServiceURL(rootUrl), this.getEnvironmentCredentials());
        }
        catch (IOException e) {
            throw new FabricException(e);
        }
        return connector;
    }

    public static interface ServiceStateCallback<T> {
        public T doWithServiceState(ServiceStateMBean var1) throws Exception;
    }

    public static interface BundleStateCallback<T> {
        public T doWithBundleState(BundleStateMBean var1) throws Exception;
    }

    public static interface FabricServiceCallback<T> {
        public T doWithFabricService(FabricServiceImplMBean var1) throws Exception;
    }

    public static interface AdminServiceCallback<T> {
        public T doWithAdminService(AdminServiceMBean var1) throws Exception;
    }
}

