/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.api.monitor;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonProperty;
import org.fusesource.fabric.api.monitor.PollDTO;

@XmlRootElement(name="data_source")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataSourceDTO {
    @JsonProperty
    @XmlAttribute
    public String id;
    @JsonProperty
    @XmlAttribute
    public String name;
    @JsonProperty
    @XmlAttribute
    public String description;
    @JsonProperty
    @XmlAttribute
    public String kind;
    @JsonProperty
    @XmlAttribute
    public String heartbeat;
    @JsonProperty
    @XmlAttribute
    public double min = Double.NaN;
    @JsonProperty
    @XmlAttribute
    public double max = Double.NaN;
    @JsonProperty
    @XmlElement
    public PollDTO poll;

    public DataSourceDTO() {
    }

    public DataSourceDTO(String id, String name, String description, String kind, String heartbeat, double min, double max, PollDTO poll2) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.kind = kind;
        this.heartbeat = heartbeat;
        this.min = min;
        this.max = max;
        this.poll = poll2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceDTO that = (DataSourceDTO)o;
        if (Double.compare(that.max, this.max) != 0) {
            return false;
        }
        if (Double.compare(that.min, this.min) != 0) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.poll != null ? !this.poll.equals(that.poll) : that.poll != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
        result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
        long temp = this.min != 0.0 ? Double.doubleToLongBits(this.min) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.max != 0.0 ? Double.doubleToLongBits(this.max) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.poll != null ? this.poll.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DataSourceDTO{description='" + this.description + '\'' + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", kind='" + this.kind + '\'' + ", heartbeat='" + this.heartbeat + '\'' + ", min=" + this.min + ", max=" + this.max + ", poll=" + this.poll + '}';
    }
}

