/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.C24IOContentType;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="c24io")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class C24IODataFormat
extends DataFormatDefinition {
    @XmlAttribute(required=false)
    private String elementTypeName;
    @XmlAttribute(required=false)
    private String format;
    @XmlAttribute(required=false)
    private Class<?> elementType;
    @XmlAttribute(required=false)
    private C24IOContentType contentType;

    public C24IODataFormat() {
        super("org.fusesource.fabric.camel.c24io.C24IOFormat");
    }

    public C24IODataFormat(Class<?> elementType) {
        this();
        this.elementType = elementType;
    }

    public C24IODataFormat(Class<?> elementType, C24IOContentType contentType) {
        this();
        this.elementType = elementType;
        this.contentType = contentType;
    }

    public C24IODataFormat(C24IOContentType contentType) {
        this();
        this.contentType = contentType;
    }

    public String getElementTypeName() {
        return this.elementTypeName;
    }

    public void setElementTypeName(String elementTypeName) {
        this.elementTypeName = elementTypeName;
    }

    public C24IOContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(C24IOContentType contentType) {
        this.contentType = contentType;
    }

    public Class<?> getElementType() {
        if (this.elementType == null && this.elementTypeName != null) {
            this.elementType = ObjectHelper.loadClass(this.elementTypeName, this.getClass().getClassLoader());
            if (this.elementType == null) {
                throw new IllegalArgumentException("The C24IO Element class " + this.elementTypeName + " is not on the classpath! Cannot use the dataFormat " + this);
            }
        }
        return this.elementType;
    }

    public void setElementType(Class<?> elementType) {
        this.elementType = elementType;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat) {
        C24IOContentType content;
        Class<?> type = this.getElementType();
        if (type != null) {
            this.setProperty(dataFormat, "elementType", type);
        }
        if ((content = this.getContentType()) != null) {
            this.setProperty(dataFormat, "contentType", (Object)content);
        }
    }
}

