/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;

public class ThreadsProcessor
extends ServiceSupport
implements AsyncProcessor {
    private final ExecutorService executorService;
    private final AtomicBoolean shutdown = new AtomicBoolean(true);
    private boolean callerRunsWhenRejected = true;

    public ThreadsProcessor(CamelContext camelContext, ExecutorService executorService) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(executorService, "executorService");
        this.executorService = executorService;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.shutdown.get()) {
            throw new IllegalStateException("ThreadsProcessor is not running.");
        }
        ProcessCall call = new ProcessCall(exchange, callback);
        try {
            this.executorService.submit(call);
            return false;
        }
        catch (RejectedExecutionException e) {
            if (this.isCallerRunsWhenRejected()) {
                if (this.shutdown.get()) {
                    exchange.setException(new RejectedExecutionException());
                } else {
                    callback.done(true);
                }
            } else {
                exchange.setException(e);
            }
            return true;
        }
    }

    public boolean isCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(boolean callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    public String toString() {
        return "Threads";
    }

    @Override
    protected void doStart() throws Exception {
        this.shutdown.set(false);
    }

    @Override
    protected void doStop() throws Exception {
        this.shutdown.set(true);
    }

    private final class ProcessCall
    implements Runnable {
        private final Exchange exchange;
        private final AsyncCallback callback;

        public ProcessCall(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
        }

        @Override
        public void run() {
            if (ThreadsProcessor.this.shutdown.get()) {
                this.exchange.setException(new RejectedExecutionException("ThreadsProcessor is not running."));
            }
            this.callback.done(false);
        }
    }
}

