/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.configadmin;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.fusesource.fabric.configadmin.InterpolationHelper;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.linkedin.zookeeper.tracker.NodeEvent;
import org.linkedin.zookeeper.tracker.NodeEventsListener;
import org.linkedin.zookeeper.tracker.TrackedNode;
import org.linkedin.zookeeper.tracker.ZKDataReader;
import org.linkedin.zookeeper.tracker.ZKStringDataReader;
import org.linkedin.zookeeper.tracker.ZooKeeperTreeTracker;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ZooKeeperConfigAdminBridge
implements NodeEventsListener<String>,
LifecycleListener {
    public static final String DELETED = "#deleted#";
    public static final String FABRIC_ZOOKEEPER_PID = "fabric.zookeeper.pid";
    public static final String FILEINSTALL = "felix.fileinstall.filename";
    private static final Logger LOGGER = Logger.getLogger(ZooKeeperConfigAdminBridge.class.getName());
    private IZKClient zooKeeper;
    private ConfigurationAdmin configAdmin;
    private String name;
    private String version;
    private String node;
    private Map<String, ZooKeeperTreeTracker<String>> trees = new ConcurrentHashMap<String, ZooKeeperTreeTracker<String>>();
    private boolean tracking = false;

    public void init() throws Exception {
    }

    public void destroy() throws Exception {
        for (ZooKeeperTreeTracker<String> tree : this.trees.values()) {
            tree.destroy();
        }
        this.trees.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected() {
        try {
            this.version = this.zooKeeper.getStringData(ZkPath.CONFIG_AGENT.getPath(this.name));
            if (this.version == null) {
                throw new IllegalStateException("Configuration for node " + this.name + " not found at " + ZkPath.CONFIG_AGENT.getPath(this.name));
            }
            this.node = ZkPath.CONFIG_VERSIONS_AGENT.getPath(this.version, this.name);
            if (this.zooKeeper.exists(this.node) == null) {
                this.zooKeeper.createWithParents(this.node, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            this.trees = new ConcurrentHashMap<String, ZooKeeperTreeTracker<String>>();
            this.tracking = true;
            try {
                this.track(this.node);
            }
            finally {
                this.tracking = false;
            }
            this.onEvents(null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception when tracking configurations", e);
        }
    }

    public void onDisconnected() {
    }

    protected ZooKeeperTreeTracker<String> track(String path) throws InterruptedException, KeeperException {
        ZooKeeperTreeTracker tree = this.trees.get(path);
        if (tree == null) {
            if (this.zooKeeper.exists(path) != null) {
                tree = new ZooKeeperTreeTracker(this.zooKeeper, (ZKDataReader)new ZKStringDataReader(), path);
                this.trees.put(path, (ZooKeeperTreeTracker<String>)tree);
                tree.track((NodeEventsListener)this);
                String data = (String)((TrackedNode)tree.getTree().get(path)).getData();
                if (data != null) {
                    String[] parents;
                    data = data.trim();
                    for (String parent : parents = data.split(" ")) {
                        this.track(ZkPath.CONFIG_VERSIONS_PROFILE.getPath(this.version, parent));
                    }
                }
            } else {
                String p = ZkPath.CONFIG_VERSIONS_PROFILES.getPath(this.version);
                if (!this.trees.containsKey(p)) {
                    tree = new ZooKeeperTreeTracker(this.zooKeeper, (ZKDataReader)new ZKStringDataReader(), p, 1);
                    this.trees.put(p, (ZooKeeperTreeTracker<String>)tree);
                    tree.track((NodeEventsListener)this);
                }
                return null;
            }
        }
        return tree;
    }

    public static Properties toProperties(String source) throws IOException {
        Properties rc = new Properties();
        rc.load(new StringReader(source));
        return rc;
    }

    public static String stripSuffix(String value, String suffix) {
        if (value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    public Dictionary load(String pid) throws IOException {
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            this.load(pid, this.node, props);
            InterpolationHelper.performSubstitution(props, new InterpolationHelper.SubstitutionCallback(){

                @Override
                public String getValue(String key) {
                    if (key.startsWith("zk:")) {
                        try {
                            return new String(ZkPath.loadURL(ZooKeeperConfigAdminBridge.this.zooKeeper, key), "UTF-8");
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Could not load zk value: " + key, e);
                        }
                    }
                    return null;
                }
            });
            return props;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException("Error loading pid " + pid).initCause(e);
        }
        catch (KeeperException e) {
            throw (IOException)new IOException("Error loading pid " + pid).initCause(e);
        }
    }

    private void load(String pid, String node, Dictionary dict) throws KeeperException, InterruptedException, IOException {
        TrackedNode cfg;
        String[] parents;
        ZooKeeperTreeTracker<String> tree = this.track(node);
        TrackedNode root = tree != null ? (TrackedNode)tree.getTree().get(node) : null;
        for (String parent : parents = root != null && root.getData() != null ? ((String)root.getData()).split(" ") : new String[]{}) {
            this.load(pid, ZkPath.CONFIG_VERSIONS_PROFILE.getPath(this.version, parent), dict);
        }
        TrackedNode trackedNode = cfg = tree != null ? (TrackedNode)tree.getTree().get(node + "/" + pid + ".properties") : null;
        if (cfg != null) {
            Properties properties = ZooKeeperConfigAdminBridge.toProperties((String)cfg.getData());
            if (properties.remove(DELETED) != null) {
                Enumeration keys = dict.keys();
                while (keys.hasMoreElements()) {
                    dict.remove(keys.nextElement());
                }
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (DELETED.equals(entry.getValue())) {
                    dict.remove(entry.getKey());
                    continue;
                }
                dict.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private Set<String> getPids() throws KeeperException, InterruptedException {
        HashSet<String> pids = new HashSet<String>();
        this.getPids(this.node, pids);
        return pids;
    }

    private void getPids(String node, Set<String> pids) throws KeeperException, InterruptedException {
        String[] parents;
        ZooKeeperTreeTracker<String> tree = this.track(node);
        TrackedNode root = tree != null ? (TrackedNode)tree.getTree().get(node) : null;
        for (String parent : parents = root != null && root.getData() != null ? ((String)root.getData()).split(" ") : new String[]{}) {
            this.getPids(ZkPath.CONFIG_VERSIONS_PROFILE.getPath(this.version, parent), pids);
        }
        for (String pid : this.getChildren(tree, node)) {
            if (!pid.endsWith(".properties")) continue;
            pid = ZooKeeperConfigAdminBridge.stripSuffix(pid, ".properties");
            pids.add(pid);
        }
    }

    protected List<String> getChildren(ZooKeeperTreeTracker<String> tree, String node) {
        ArrayList<String> children = new ArrayList<String>();
        if (tree != null) {
            Pattern p = Pattern.compile(node + "/[^/]*");
            for (String c : tree.getTree().keySet()) {
                if (!p.matcher(c).matches()) continue;
                children.add(c.substring(c.lastIndexOf(47) + 1));
            }
        }
        return children;
    }

    public void onEvents(Collection<NodeEvent<String>> nodeEvents) {
        LOGGER.entering(this.getClass().getName(), "onEvents", nodeEvents);
        try {
            if (!this.tracking) {
                Set<String> pids = this.getPids();
                List<Configuration> configs = ZooKeeperConfigAdminBridge.asList(this.getConfigAdmin().listConfigurations("(fabric.zookeeper.pid=*)"));
                for (String pid : pids) {
                    Dictionary c = this.load(pid);
                    String[] p = this.parsePid(pid);
                    Configuration config = this.getConfiguration(pid, p[0], p[1]);
                    configs.remove(config);
                    Dictionary props = config.getProperties();
                    boolean changed = false;
                    if (props != null) {
                        Enumeration e = c.keys();
                        while (e.hasMoreElements()) {
                            Object key = e.nextElement();
                            Object val = c.get(key);
                            Object oldVal = props.get(key);
                            if (oldVal != null && oldVal.equals(val)) continue;
                            props.put(key, val);
                            LOGGER.info(config.getPid() + " - property '" + key + "' changed: " + oldVal + " -> " + val);
                            changed = true;
                        }
                        props.remove(FABRIC_ZOOKEEPER_PID);
                        props.remove("service.pid");
                        props.remove("service.factoryPid");
                        if (changed) {
                            LOGGER.info(config.getPid() + " - updating configuration");
                            config.update(props);
                            this.saveProperties(props);
                            continue;
                        }
                        LOGGER.fine(config.getPid() + " - ignoring configuration (no changes)");
                        continue;
                    }
                    LOGGER.info(config.getPid() + " - initializing configuration");
                    config.update(c);
                }
                for (Configuration config : configs) {
                    LOGGER.info(config.getPid() + " - deleting configuration");
                    config.delete();
                }
            }
            LOGGER.exiting(this.getClass().getName(), "onEvents");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception when tracking configurations", e);
        }
    }

    private void saveProperties(Dictionary props) throws IOException {
        String fileInstall = (String)props.get(FILEINSTALL);
        if (fileInstall != null) {
            URL configUrl = new URL(fileInstall);
            props.remove(FILEINSTALL);
            Properties fileProperties = this.createProperties(props);
            fileProperties.store(new FileOutputStream(configUrl.getFile()), "Saved by " + this.name + " at  " + new Date());
        }
    }

    private Properties createProperties(Dictionary dict) {
        Properties p = new Properties();
        Enumeration keys = dict.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            p.setProperty(key, (String)dict.get(key));
        }
        return p;
    }

    public static <T> List<T> asList(T ... a) {
        ArrayList l = new ArrayList();
        if (a != null) {
            Collections.addAll(l, a);
        }
        return l;
    }

    String[] parsePid(String pid) {
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    Configuration getConfiguration(String zooKeeperPid, String pid, String factoryPid) throws Exception {
        Configuration oldConfiguration = this.findExistingConfiguration(zooKeeperPid);
        if (oldConfiguration != null) {
            return oldConfiguration;
        }
        Configuration newConfiguration = factoryPid != null ? this.getConfigAdmin().createFactoryConfiguration(pid, null) : this.getConfigAdmin().getConfiguration(pid, null);
        return newConfiguration;
    }

    Configuration findExistingConfiguration(String zooKeeperPid) throws Exception {
        String filter = "(fabric.zookeeper.pid=" + zooKeeperPid + ")";
        Configuration[] configurations = this.getConfigAdmin().listConfigurations(filter);
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

