/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.net.URI;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.CreateAgentArguments;
import org.fusesource.fabric.api.CreateJCloudsAgentArguments;
import org.fusesource.fabric.api.JCloudsInstanceType;
import org.fusesource.fabric.commands.support.AgentCreateSupport;

@Command(name="agent-create-cloud", scope="fabric", description="Creates one or more new agents on the cloud")
public class AgentCreateCloud
extends AgentCreateSupport {
    @Option(name="--provider", required=true, description="JClouds provider name")
    private String providerName;
    @Option(name="--identity", required=true, description="The cloud identity to use")
    private String identity;
    @Option(name="--credential", required=true, description="Credential to login to the cloud")
    private String credential;
    @Option(name="--hardware", required=true, description="Which hardware kind to use")
    private String hardwareId;
    @Option(name="--instanceType", required=true, description="Which kind of instance is required")
    private JCloudsInstanceType instanceType;
    @Option(name="--image", required=true, description="The image ID to use for the new node(s)")
    private String imageId;
    @Option(name="--location", required=true, description="The location to use to create the new node(s)")
    private String locationId;
    @Option(name="--user", required=true, description="User account to run on the new node(s)")
    private String user;
    @Option(name="--owner", description="Optional owner of images; only really used for EC2 and deprecated going forward")
    private String owner;
    @Option(name="--group", description="Group tag to use on the new node(s)")
    private String group;
    @Option(name="--proxy-uri", description="Maven proxy URL to use")
    private URI proxyUri;
    @Argument(index=0, required=true, description="The name of the agent to be created. When creating multiple agents it serves as a prefix")
    protected String name;
    @Argument(index=1, required=false, description="The number of agents that should be created")
    protected int number = 1;

    protected Object doExecute() throws Exception {
        CreateJCloudsAgentArguments args = new CreateJCloudsAgentArguments();
        args.setClusterServer(this.isClusterServer.booleanValue());
        args.setCredential(this.credential);
        args.setDebugAgent(this.debugAgent.booleanValue());
        args.setGroup(this.group);
        args.setHardwareId(this.hardwareId);
        args.setIdentity(this.identity);
        args.setImageId(this.imageId);
        args.setInstanceType(this.instanceType);
        args.setLocationId(this.locationId);
        args.setNumber(this.number);
        args.setOwner(this.owner);
        args.setProviderName(this.providerName);
        args.setUser(this.user);
        this.fabricService.createAgents((CreateAgentArguments)args, this.name, this.number);
        return null;
    }
}

