/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.commands.support.EnsembleCommandSupport;
import org.fusesource.fabric.zookeeper.commands.Import;

@Command(name="create", scope="fabric", description="Create a new ZooKeeper ensemble and imports Fabric profiles")
public class Create
extends EnsembleCommandSupport {
    @Option(name="--clean", description="Clean local zookeeper cluster and configurations")
    private boolean clean;
    @Option(name="--no-import", description="Disable the import of the sample registry data from ")
    private boolean noImport;
    @Option(name="--import-dir", description="Directory of files to import into the newly created ensemble")
    private String importDir = Create.getDefaultImportDir();
    @Option(name="-v", aliases={"--verbose"}, description="Verbose output of files being imported")
    boolean verbose = false;
    @Option(name="-t", aliases={"--time"}, description="The amount of time to wait for the ensemble to startup before trying to import the default data")
    long ensembleStartupTime = 2000L;
    @Argument(required=false, multiValued=true, description="List of agents")
    private List<String> agents;

    protected Object doExecute() throws Exception {
        if (this.agents == null || this.agents.isEmpty()) {
            this.agents = Arrays.asList(System.getProperty("karaf.name"));
        }
        if (this.clean) {
            this.service.clean();
        }
        if (this.agents != null && !this.agents.isEmpty()) {
            this.service.createCluster(this.agents);
            if (!this.noImport) {
                if (this.ensembleStartupTime > 0L) {
                    try {
                        Thread.sleep(this.ensembleStartupTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                Import tool = new Import();
                tool.setSource(this.importDir);
                tool.setBundleContext(this.getBundleContext());
                tool.setZooKeeper(this.service.getZooKeeper());
                if (this.verbose) {
                    tool.setVerbose(this.verbose);
                }
                return tool.execute(this.session);
            }
        }
        return null;
    }

    private static String getDefaultImportDir() {
        return System.getProperty("karaf.home", ".") + File.separatorChar + "fabric" + File.separatorChar + "import";
    }
}

