/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Agent;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.commands.support.FabricCommand;

@Command(name="profile-display", scope="fabric", description="Displays profile information")
public class ProfileDisplay
extends FabricCommand {
    @Option(name="--version")
    private String version = "base";
    @Option(name="--overlay", aliases={"-o"})
    private Boolean overlay = false;
    @Argument(index=0, required=true, name="profile")
    @CompleterValues(index=0)
    private String name;

    protected Object doExecute() throws Exception {
        Version version = this.fabricService.getVersion(this.version);
        for (Profile profile : version.getProfiles()) {
            if (!this.name.equals(profile.getId())) continue;
            this.displayProfile(profile);
        }
        return null;
    }

    private String toString(Agent[] agents) {
        StringBuffer rc = new StringBuffer();
        for (Agent agent : agents) {
            rc.append(agent.getId());
            rc.append(" ");
        }
        return rc.toString().trim();
    }

    private static void printConfigList(String header, PrintStream out, List<String> list) {
        out.println(header);
        for (String str : list) {
            out.printf("\t%s\n", str);
        }
        out.println();
    }

    private void displayProfile(Profile profile) {
        Map configuration;
        PrintStream output = this.session.getConsole();
        output.println("Profile id: " + profile.getId());
        output.println("Version   : " + profile.getVersion());
        output.println("Parents   : " + this.toString(profile.getParents()));
        output.printf("Associated Agents : %s\n", this.toString(profile.getAssociatedAgents()));
        Map map = configuration = this.overlay != false ? profile.getOverlay().getConfigurations() : profile.getConfigurations();
        if (configuration.containsKey(AGENT_PID)) {
            output.println("\nAgent settings");
            output.println("----------------------------");
            if (profile.getRepositories().size() > 0) {
                ProfileDisplay.printConfigList("Repositories : ", output, profile.getRepositories());
            }
            if (profile.getFeatures().size() > 0) {
                ProfileDisplay.printConfigList("Features : ", output, profile.getFeatures());
            }
            if (profile.getBundles().size() > 0) {
                ProfileDisplay.printConfigList("Bundles : ", output, profile.getBundles());
            }
            configuration.remove(AGENT_PID);
        }
        output.println("\nConfiguration details");
        output.println("----------------------------");
        for (Map.Entry cfg : configuration.entrySet()) {
            output.println("PID: " + (String)cfg.getKey());
            for (Map.Entry values : ((Map)cfg.getValue()).entrySet()) {
                output.println("  " + (String)values.getKey() + " " + (String)values.getValue());
            }
            output.println("\n");
        }
    }
}

