/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.commands.support.FabricCommand;

@Command(name="profile-edit", scope="fabric", description="Edit a profile")
public class ProfileEdit
extends FabricCommand {
    @Option(name="-v", aliases={"--version"}, description="The version of the profile to edit")
    private String version = "base";
    @Option(name="-p", aliases={"--profile"}, description="The target profile to edit")
    private String target = "default";
    @Argument(index=0, multiValued=true)
    private String[] arguments;
    @Option(name="--pid", description="Target PID to edit")
    private String pid = null;
    @Option(name="--repositories", description="Edit repositories")
    private boolean repositories = false;
    @Option(name="--features", description="Edit features")
    private boolean features = false;
    @Option(name="--bundles", description="Edit bundles")
    private boolean bundles = false;
    @Option(name="--set", description="Set or create value(s)")
    private boolean set = true;
    @Option(name="--delete", description="Delete value(s)")
    private boolean delete = false;

    protected Object doExecute() throws Exception {
        if (this.delete) {
            this.set = false;
        }
        Version version = this.fabricService.getVersion(this.version);
        for (Profile profile : version.getProfiles()) {
            if (!this.target.equals(profile.getId())) continue;
            this.editProfile(profile);
        }
        return null;
    }

    private void editProfile(Profile profile) throws Exception {
        String pid = this.getPid();
        Map config = profile.getConfigurations();
        HashMap<String, String> pidConfig = (HashMap<String, String>)config.get(pid);
        if (pidConfig == null) {
            pidConfig = new HashMap<String, String>();
        }
        String prefix = "";
        if (this.repositories) {
            prefix = "repository.";
        } else if (this.features) {
            prefix = "feature.";
        } else if (this.bundles) {
            prefix = "bundle.";
        }
        if (this.arguments != null) {
            for (String arg : this.arguments) {
                if (this.set) {
                    String[] nameValue = arg.split("=", 2);
                    if (nameValue.length != 2) {
                        if (this.repositories || this.features || this.bundles) {
                            nameValue = new String[]{nameValue[0].replace('/', '_'), nameValue[0]};
                        } else {
                            throw new IllegalArgumentException(String.format("Argument \"%s\" is invalid, arguments need to be in the form of \"name=value\"", new Object[0]));
                        }
                    }
                    pidConfig.put(prefix + nameValue[0], nameValue[1]);
                    continue;
                }
                if (!this.delete) continue;
                if (this.repositories || this.features || this.bundles) {
                    for (Map.Entry entry : new HashMap(pidConfig).entrySet()) {
                        if (!arg.equals(entry.getValue())) continue;
                        pidConfig.remove(entry.getKey());
                    }
                    continue;
                }
                pidConfig.remove(prefix + arg);
            }
        }
        config.put(pid, pidConfig);
        profile.setConfigurations(config);
    }

    private String getPid() {
        if (this.pid != null) {
            return this.pid;
        }
        return AGENT_PID;
    }
}

