/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.service.FabricServiceImpl;
import org.linkedin.zookeeper.client.IZKClient;

public abstract class FabricCommand
extends OsgiCommandSupport {
    private IZKClient zooKeeper;
    protected FabricService fabricService;
    protected static String AGENT_PID = "org.fusesource.fabric.agent";

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public IZKClient getZooKeeper() {
        if (this.zooKeeper == null && this.fabricService instanceof FabricServiceImpl) {
            FabricServiceImpl impl = (FabricServiceImpl)this.fabricService;
            this.zooKeeper = impl.getZooKeeper();
        }
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    protected String toString(Profile[] profiles) {
        if (profiles == null) {
            return "";
        }
        int iMax = profiles.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append(profiles[i].getId());
            if (i == iMax) {
                return b.toString();
            }
            b.append(", ");
            ++i;
        }
    }

    protected Profile[] getProfiles(String version, List<String> names) {
        Profile[] allProfiles = this.fabricService.getVersion(version).getProfiles();
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        if (names == null) {
            return new Profile[0];
        }
        for (String name : names) {
            Profile profile = null;
            for (Profile p : allProfiles) {
                if (!name.equals(p.getId())) continue;
                profile = p;
                break;
            }
            if (profile == null) {
                throw new IllegalArgumentException("Profile not found: " + name);
            }
            profiles.add(profile);
        }
        return profiles.toArray(new Profile[profiles.size()]);
    }
}

