/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq.fabric;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.codehaus.jackson.annotate.JsonProperty;
import org.fusesource.fabric.groups.ChangeListener;
import org.fusesource.fabric.groups.ClusteredSingleton;
import org.fusesource.fabric.groups.Group;
import org.fusesource.fabric.groups.NodeState;
import org.fusesource.fabric.groups.ZooKeeperGroupFactory;
import org.linkedin.util.clock.Timespan;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.ZKClient;

public class FabricDiscoveryAgent
implements DiscoveryAgent {
    private static final Log LOG = LogFactory.getLog(FabricDiscoveryAgent.class);
    private IZKClient zkClient;
    private boolean managedZkClient;
    private List<ACL> acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private Group group;
    private String groupName = "default";
    private AtomicBoolean running = new AtomicBoolean();
    private final AtomicReference<DiscoveryListener> discoveryListener = new AtomicReference();
    private final HashMap<String, SimpleDiscoveryEvent> discoveredServices = new HashMap();
    private final AtomicInteger startCounter = new AtomicInteger(0);
    private long initialReconnectDelay = 1000L;
    private long maxReconnectDelay = 30000L;
    private long backOffMultiplier = 2L;
    private boolean useExponentialBackOff = true;
    private int maxReconnectAttempts = 0;
    private final Object sleepMutex = new Object();
    private long minConnectTime = 5000L;
    private String id;
    private String agent;
    List<String> services = new ArrayList<String>();
    ClusteredSingleton<ActiveMQNode> singleton = new ClusteredSingleton(ActiveMQNode.class);

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    ActiveMQNode createState() {
        ActiveMQNode state = new ActiveMQNode();
        state.id = this.id;
        state.agent = this.agent;
        state.services = this.services.toArray(new String[this.services.size()]);
        return state;
    }

    public FabricDiscoveryAgent() {
        this.singleton.add(new ChangeListener(){

            public void changed() {
                FabricDiscoveryAgent.this.update((ActiveMQNode[])FabricDiscoveryAgent.this.singleton.masters());
            }

            public void connected() {
                this.changed();
            }

            public void disconnected() {
                this.changed();
            }
        });
    }

    public synchronized void registerService(String service) throws IOException {
        this.services.add(service);
        this.updateClusterState();
    }

    public void updateClusterState() {
        if (this.startCounter.get() > 0) {
            if (this.id == null) {
                throw new IllegalStateException("You must configure the id of the fabric discovery if you want to register services");
            }
            this.singleton.update((NodeState)this.createState());
        }
    }

    public void serviceFailed(DiscoveryEvent devent) throws IOException {
        final SimpleDiscoveryEvent event = (SimpleDiscoveryEvent)devent;
        if (event.failed.compareAndSet(false, true)) {
            this.discoveryListener.get().onServiceRemove((DiscoveryEvent)event);
            if (!event.removed.get()) {
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (event.connectTime + FabricDiscoveryAgent.this.minConnectTime > System.currentTimeMillis()) {
                            LOG.debug((Object)("Failure occurred soon after the discovery event was generated.  It will be classified as a connection failure: " + (Object)((Object)event)));
                            event.connectFailures++;
                            if (FabricDiscoveryAgent.this.maxReconnectAttempts > 0 && event.connectFailures >= FabricDiscoveryAgent.this.maxReconnectAttempts) {
                                LOG.debug((Object)("Reconnect attempts exceeded " + FabricDiscoveryAgent.this.maxReconnectAttempts + " tries.  Reconnecting has been disabled."));
                                return;
                            }
                            Object object = FabricDiscoveryAgent.this.sleepMutex;
                            synchronized (object) {
                                try {
                                    if (!FabricDiscoveryAgent.this.running.get() || event.removed.get()) {
                                        return;
                                    }
                                    LOG.debug((Object)("Waiting " + event.reconnectDelay + " ms before attempting to reconnect."));
                                    FabricDiscoveryAgent.this.sleepMutex.wait(event.reconnectDelay);
                                }
                                catch (InterruptedException ie) {
                                    Thread.currentThread().interrupt();
                                    return;
                                }
                            }
                            if (!FabricDiscoveryAgent.this.useExponentialBackOff) {
                                event.reconnectDelay = FabricDiscoveryAgent.this.initialReconnectDelay;
                            } else {
                                event.reconnectDelay *= FabricDiscoveryAgent.this.backOffMultiplier;
                                if (event.reconnectDelay > FabricDiscoveryAgent.this.maxReconnectDelay) {
                                    event.reconnectDelay = FabricDiscoveryAgent.this.maxReconnectDelay;
                                }
                            }
                        } else {
                            event.connectFailures = 0;
                            event.reconnectDelay = FabricDiscoveryAgent.this.initialReconnectDelay;
                        }
                        if (!FabricDiscoveryAgent.this.running.get() || event.removed.get()) {
                            return;
                        }
                        event.connectTime = System.currentTimeMillis();
                        event.failed.set(false);
                        ((DiscoveryListener)FabricDiscoveryAgent.this.discoveryListener.get()).onServiceAdd((DiscoveryEvent)event);
                    }
                };
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    public void setDiscoveryListener(DiscoveryListener discoveryListener) {
        this.discoveryListener.set(discoveryListener);
    }

    public synchronized void start() throws Exception {
        if (this.startCounter.addAndGet(1) == 1) {
            this.running.set(true);
            if (this.zkClient == null) {
                this.managedZkClient = true;
                ZKClient client = new ZKClient(System.getProperty("zookeeper.url", "localhost:2181"), Timespan.parse((String)"10s"), null);
                client.start();
                client.waitForStart();
                this.zkClient = client;
            } else {
                this.managedZkClient = false;
            }
            this.group = ZooKeeperGroupFactory.create((IZKClient)this.zkClient, (String)("/fabric/registry/clusters/activemq/" + this.groupName), this.acl);
            this.singleton.start(this.group);
            if (this.id != null) {
                this.singleton.join((NodeState)this.createState());
            }
        }
    }

    public synchronized void stop() throws Exception {
        if (this.startCounter.decrementAndGet() == 0) {
            this.running.set(false);
            try {
                this.group.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (this.managedZkClient) {
                try {
                    this.zkClient.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.zkClient = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(ActiveMQNode[] members) {
        DiscoveryListener discoveryListener = this.discoveryListener.get();
        if (discoveryListener != null) {
            HashSet<String> activeServices = new HashSet<String>();
            for (ActiveMQNode m : members) {
                for (String service : m.services) {
                    activeServices.add(service);
                }
            }
            if (members != null) {
                HashMap<String, SimpleDiscoveryEvent> hashMap = this.discoveredServices;
                synchronized (hashMap) {
                    HashSet<String> removedServices = new HashSet<String>(this.discoveredServices.keySet());
                    removedServices.removeAll(activeServices);
                    HashSet addedServices = new HashSet(activeServices);
                    addedServices.removeAll(this.discoveredServices.keySet());
                    addedServices.removeAll(removedServices);
                    for (String service : addedServices) {
                        SimpleDiscoveryEvent e = new SimpleDiscoveryEvent(service);
                        this.discoveredServices.put(service, e);
                        discoveryListener.onServiceAdd((DiscoveryEvent)e);
                    }
                    for (String service : removedServices) {
                        SimpleDiscoveryEvent e = this.discoveredServices.remove(service);
                        if (e != null) {
                            e.removed.set(true);
                        }
                        discoveryListener.onServiceRemove((DiscoveryEvent)e);
                    }
                }
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getServices() {
        return this.services;
    }

    public void setServices(String[] services) {
        this.services.clear();
        for (String s : services) {
            this.services.add(s);
        }
        this.updateClusterState();
    }

    public IZKClient getZkClient() {
        return this.zkClient;
    }

    public void setZkClient(IZKClient zkClient) {
        this.zkClient = zkClient;
    }

    public ClusteredSingleton<ActiveMQNode> getSingleton() {
        return this.singleton;
    }

    public String getAgent() {
        return this.agent;
    }

    public void setAgent(String agent) {
        this.agent = agent;
    }

    class SimpleDiscoveryEvent
    extends DiscoveryEvent {
        private int connectFailures;
        private long reconnectDelay;
        private long connectTime;
        private AtomicBoolean failed;
        private AtomicBoolean removed;

        public SimpleDiscoveryEvent(String service) {
            super(service);
            this.reconnectDelay = FabricDiscoveryAgent.this.initialReconnectDelay;
            this.connectTime = System.currentTimeMillis();
            this.failed = new AtomicBoolean(false);
            this.removed = new AtomicBoolean(false);
        }
    }

    static class ActiveMQNode
    implements NodeState {
        @JsonProperty
        String id;
        @JsonProperty
        String[] services;
        @JsonProperty
        String agent;

        ActiveMQNode() {
        }

        public String id() {
            return this.id;
        }
    }
}

