/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Properties;
import org.fusesource.fabric.api.AgentProvider;
import org.fusesource.fabric.api.CreateAgentArguments;
import org.fusesource.fabric.api.CreateSshAgentArguments;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.internal.AgentProviderUtils;

public class SshAgentProvider
implements AgentProvider {
    private boolean debug = false;

    public void create(URI proxyUri, URI agentUri, String name, String zooKeeperUrl, boolean isClusterServer, boolean debugAgent) {
        this.create(proxyUri, agentUri, name, zooKeeperUrl, isClusterServer, debugAgent, 1);
    }

    public void create(URI proxyUri, URI agentUri, String name, String zooKeeperUrl, boolean isClusterServer, boolean debugAgent, int number) {
        try {
            String ui;
            String[] uip;
            String path = agentUri.getPath();
            String host = agentUri.getHost();
            if (agentUri.getQuery() != null) {
                this.debug = agentUri.getQuery().contains("debug");
            }
            if (host == null) {
                throw new IllegalArgumentException("host name must be specified in uri '" + agentUri + "'");
            }
            int port = agentUri.getPort();
            if (port == -1) {
                port = 22;
            }
            String[] stringArray = uip = (ui = agentUri.getUserInfo()) != null ? ui.split(":") : null;
            if (uip == null || uip.length != 2) {
                throw new IllegalArgumentException("user and password must be supplied in the uri '" + agentUri + "'");
            }
            String username = uip[0];
            String password = uip[1];
            int sshRetries = 6;
            int retryDelay = 1;
            this.doCreateAgent(proxyUri, name, number, zooKeeperUrl, isClusterServer, debugAgent, path, host, port, username, password, sshRetries, retryDelay);
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException((Throwable)e);
        }
    }

    public boolean create(CreateAgentArguments createArgs, String name, String zooKeeperUrl) throws Exception {
        if (createArgs instanceof CreateSshAgentArguments) {
            CreateSshAgentArguments args = (CreateSshAgentArguments)createArgs;
            boolean isClusterServer = args.isClusterServer();
            boolean debugAgent = args.isDebugAgent();
            int number = args.getNumber();
            String path = args.getPath();
            String host = args.getHost();
            int port = args.getPort();
            String username = args.getUsername();
            String password = args.getPassword();
            int sshRetries = args.getSshRetries();
            int retryDelay = args.getRetryDelay();
            URI proxyUri = args.getProxyUri();
            this.doCreateAgent(proxyUri, name, number, zooKeeperUrl, isClusterServer, debugAgent, path, host, port, username, password, sshRetries, retryDelay);
            return true;
        }
        return false;
    }

    protected void doCreateAgent(URI proxyUri, String name, int number, String zooKeeperUrl, boolean isClusterServer, boolean debugAgent, String path, String host, int port, String username, String password, int sshRetries, int retryDelay) throws Exception {
        for (int i = 0; i < number; ++i) {
            String agentName = name;
            if (number != 1) {
                agentName = agentName + (i + 1);
            }
            String script = AgentProviderUtils.buildStartupScript((URI)proxyUri, (String)agentName, (String)path, (String)zooKeeperUrl, (int)(8081 + i), (boolean)isClusterServer, (boolean)debugAgent);
            this.createAgent(host, port, username, password, script, sshRetries, retryDelay);
        }
    }

    public void create(URI proxyUri, URI agentUri, String name, String zooKeeperUrl) {
        this.create(proxyUri, agentUri, name, zooKeeperUrl, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAgent(String host, int port, String username, String password, String script, int sshRetries, long retryDelay) throws Exception {
        Session session = null;
        Exception connectException = null;
        for (int i = 0; i < sshRetries; ++i) {
            if (i > 0) {
                long delayMs = (long)(200.0 * Math.pow(i, 2.0));
                Thread.sleep(delayMs);
            }
            try {
                session = new JSch().getSession(username, host, port);
                session.setTimeout(60000);
                session.setPassword(password);
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", "no");
                session.setConfig(config);
                session.connect();
                connectException = null;
                break;
            }
            catch (Exception from) {
                connectException = from;
                if (session != null && session.isConnected()) {
                    session.disconnect();
                }
                session = null;
                continue;
            }
        }
        if (connectException != null) {
            throw connectException;
        }
        ChannelExec executor = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayOutputStream error = new ByteArrayOutputStream();
        try {
            executor = (ChannelExec)session.openChannel("exec");
            executor.setPty(true);
            executor.setCommand(script);
            executor.setOutputStream((OutputStream)output);
            executor.setErrStream((OutputStream)error);
            executor.connect();
            int errorStatus = -1;
            int i = 0;
            while (!executor.isClosed()) {
                if (i > 0) {
                    long delayMs = (long)(200.0 * Math.pow(i, 2.0));
                    Thread.sleep(delayMs);
                }
                if ((errorStatus = executor.getExitStatus()) != -1) break;
                ++i;
            }
            if (this.debug) {
                System.out.println("Output : " + output.toString());
                System.out.println("Error : " + error.toString());
            }
            if (errorStatus != 0) {
                throw new Exception(String.format("%s@%s:%d: received exit status %d executing \n--- command ---\n%s\n--- output ---\n%s\n--- error ---\n%s\n------\n", username, host, port, executor.getExitStatus(), script, output.toString(), error.toString()));
            }
        }
        finally {
            if (executor != null) {
                executor.disconnect();
            }
            session.disconnect();
        }
    }
}

