/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.namespace.QName;
import org.apache.camel.Channel;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.DataFormatClause;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.ProcessorBuilder;
import org.apache.camel.model.AOPDefinition;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.Block;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ConvertBodyDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.DelayDefinition;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.FinallyDefinition;
import org.apache.camel.model.IdempotentConsumerDefinition;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.NodeFactory;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.PipelineDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.model.ProcessDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.RemoveHeaderDefinition;
import org.apache.camel.model.RemoveHeadersDefinition;
import org.apache.camel.model.RemovePropertyDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.RollbackDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.model.SamplingDefinition;
import org.apache.camel.model.SetBodyDefinition;
import org.apache.camel.model.SetExchangePatternDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.SetOutHeaderDefinition;
import org.apache.camel.model.SetPropertyDefinition;
import org.apache.camel.model.SortDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.StopDefinition;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.camel.model.ThrottleDefinition;
import org.apache.camel.model.ThrowExceptionDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.TransformDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.ValidateDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.LanguageExpression;
import org.apache.camel.processor.DefaultChannel;
import org.apache.camel.processor.InterceptEndpointProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.interceptor.Delayer;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.processor.interceptor.StreamCaching;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
public abstract class ProcessorDefinition<Type extends ProcessorDefinition<Type>>
extends OptionalIdentifiedDefinition
implements Block {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected ErrorHandlerBuilder errorHandlerBuilder;
    protected String errorHandlerRef;
    protected Boolean inheritErrorHandler;
    private NodeFactory nodeFactory;
    private final LinkedList<Block> blocks = new LinkedList();
    private ProcessorDefinition<?> parent;
    private final List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private Map<QName, Object> otherAttributes;

    public abstract List<ProcessorDefinition> getOutputs();

    public abstract boolean isOutputSupported();

    public boolean isAbstract() {
        return false;
    }

    public Processor createProcessor(RouteContext routeContext) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet for class: " + this.getClass().getName());
    }

    public Processor createOutputsProcessor(RouteContext routeContext) throws Exception {
        List<ProcessorDefinition> outputs = this.getOutputs();
        return this.createOutputsProcessor(routeContext, outputs);
    }

    public Processor createChildProcessor(RouteContext routeContext, boolean mandatory) throws Exception {
        Processor children = null;
        if (routeContext.getCamelContext().getProcessorFactory() != null) {
            children = routeContext.getCamelContext().getProcessorFactory().createChildProcessor(routeContext, this, mandatory);
        }
        if (children == null) {
            children = routeContext.createProcessor(this);
        }
        if (children == null && mandatory) {
            throw new IllegalArgumentException("Definition has no children on " + this);
        }
        return children;
    }

    @Override
    public void addOutput(ProcessorDefinition output) {
        if (!this.blocks.isEmpty()) {
            Block block = this.blocks.getLast();
            block.addOutput(output);
            return;
        }
        output.setParent(this);
        output.setNodeFactory(this.getNodeFactory());
        output.setErrorHandlerBuilder(this.getErrorHandlerBuilder());
        this.configureChild(output);
        this.getOutputs().add(output);
    }

    public void clearOutput() {
        this.getOutputs().clear();
        this.blocks.clear();
    }

    public void addRoutes(RouteContext routeContext, Collection<Route> routes) throws Exception {
        Processor processor = this.makeProcessor(routeContext);
        if (processor == null) {
            return;
        }
        if (!routeContext.isRouteAdded()) {
            Channel channel;
            Processor next;
            boolean endpointInterceptor = false;
            if (processor instanceof Channel && (next = (channel = (Channel)processor).getNextProcessor()) instanceof InterceptEndpointProcessor) {
                endpointInterceptor = true;
            }
            if (endpointInterceptor) {
                this.log.debug("Endpoint interceptor should not be added as an event driven consumer route: {}", (Object)processor);
            } else {
                this.log.trace("Adding event driven processor: {}", (Object)processor);
                routeContext.addEventDrivenProcessor(processor);
            }
        }
    }

    public Processor wrapProcessor(RouteContext routeContext, Processor processor) throws Exception {
        if (processor instanceof Channel) {
            return processor;
        }
        return this.wrapChannel(routeContext, processor, null);
    }

    protected Processor wrapChannel(RouteContext routeContext, Processor processor, ProcessorDefinition child) throws Exception {
        Channel channel = this.createChannel(routeContext);
        channel.setNextProcessor(processor);
        this.addInterceptStrategies(routeContext, channel, routeContext.getCamelContext().getInterceptStrategies());
        this.addInterceptStrategies(routeContext, channel, routeContext.getInterceptStrategies());
        this.addInterceptStrategies(routeContext, channel, this.getInterceptStrategies());
        ProcessorDefinition defn = this;
        channel.setChildDefinition(child);
        channel.initChannel(defn, routeContext);
        if (defn instanceof TryDefinition || defn instanceof CatchDefinition || defn instanceof FinallyDefinition) {
            this.log.trace("{} is part of doTry .. doCatch .. doFinally so no error handler is applied", (Object)defn);
        } else if (ProcessorDefinitionHelper.isParentOfType(TryDefinition.class, defn, true) || ProcessorDefinitionHelper.isParentOfType(CatchDefinition.class, defn, true) || ProcessorDefinitionHelper.isParentOfType(FinallyDefinition.class, defn, true)) {
            this.log.trace("{} is part of doTry .. doCatch .. doFinally so no error handler is applied", (Object)defn);
        } else if (defn instanceof OnExceptionDefinition || ProcessorDefinitionHelper.isParentOfType(OnExceptionDefinition.class, defn, true)) {
            this.log.trace("{} is part of OnException so no error handler is applied", (Object)defn);
        } else if (defn instanceof MulticastDefinition) {
            MulticastDefinition def = (MulticastDefinition)defn;
            if (def.isShareUnitOfWork() && child == null) {
                this.wrapChannelInErrorHandler(channel, routeContext);
            } else {
                this.log.trace("{} is part of multicast/recipientList which have special error handling so no error handler is applied", (Object)defn);
            }
        } else if (defn instanceof RecipientListDefinition) {
            RecipientListDefinition def = (RecipientListDefinition)defn;
            if (def.isShareUnitOfWork()) {
                this.wrapChannelInErrorHandler(channel, routeContext);
            } else {
                this.log.trace("{} is part of multicast/recipientList which have special error handling so no error handler is applied", (Object)defn);
            }
        } else {
            this.wrapChannelInErrorHandler(channel, routeContext);
        }
        channel.postInitChannel(defn, routeContext);
        this.log.trace("{} wrapped in Channel: {}", (Object)defn, (Object)channel);
        return channel;
    }

    private void wrapChannelInErrorHandler(Channel channel, RouteContext routeContext) throws Exception {
        if (this.isInheritErrorHandler() == null || this.isInheritErrorHandler().booleanValue()) {
            this.log.trace("{} is configured to inheritErrorHandler", (Object)this);
            Processor output = channel.getOutput();
            Processor errorHandler = this.wrapInErrorHandler(routeContext, this.getErrorHandlerBuilder(), output);
            channel.setErrorHandler(errorHandler);
        } else {
            this.log.debug("{} is configured to not inheritErrorHandler.", (Object)this);
        }
    }

    protected Processor wrapInErrorHandler(RouteContext routeContext, ErrorHandlerBuilder builder, Processor output) throws Exception {
        Processor errorHandler = builder.createErrorHandler(routeContext, output);
        for (LifecycleStrategy strategy : routeContext.getCamelContext().getLifecycleStrategies()) {
            strategy.onErrorHandlerAdd(routeContext, errorHandler, builder);
        }
        return errorHandler;
    }

    protected void addInterceptStrategies(RouteContext routeContext, Channel channel, List<InterceptStrategy> strategies) {
        for (InterceptStrategy strategy : strategies) {
            if (!routeContext.isStreamCaching().booleanValue() && strategy instanceof StreamCaching || !routeContext.isHandleFault().booleanValue() && strategy instanceof HandleFault) continue;
            if (strategy instanceof Delayer) {
                if (routeContext.getDelayer() == null || routeContext.getDelayer() <= 0L) continue;
                Iterator<InterceptStrategy> it = channel.getInterceptStrategies().iterator();
                while (it.hasNext()) {
                    InterceptStrategy existing = it.next();
                    if (!(existing instanceof Delayer)) continue;
                    it.remove();
                }
                channel.addInterceptStrategy(strategy);
                continue;
            }
            channel.addInterceptStrategy(strategy);
        }
    }

    protected Processor createCompositeProcessor(RouteContext routeContext, List<Processor> list) throws Exception {
        return new Pipeline(routeContext.getCamelContext(), list);
    }

    protected Channel createChannel(RouteContext routeContext) throws Exception {
        return new DefaultChannel();
    }

    protected Processor createOutputsProcessor(RouteContext routeContext, Collection<ProcessorDefinition> outputs) throws Exception {
        ArrayList<Processor> list = new ArrayList<Processor>();
        for (ProcessorDefinition output : outputs) {
            this.resolvePropertyPlaceholders(routeContext, output);
            Processor processor = null;
            if (routeContext.getCamelContext().getProcessorFactory() != null) {
                processor = routeContext.getCamelContext().getProcessorFactory().createProcessor(routeContext, output);
            }
            if (processor == null) {
                processor = output.createProcessor(routeContext);
            }
            if (output instanceof Channel && processor == null) continue;
            Processor channel = this.wrapChannel(routeContext, processor, output);
            list.add(channel);
        }
        Processor processor = null;
        if (!list.isEmpty()) {
            processor = list.size() == 1 ? (Processor)list.get(0) : this.createCompositeProcessor(routeContext, list);
        }
        return processor;
    }

    protected Processor makeProcessor(RouteContext routeContext) throws Exception {
        Processor processor = null;
        this.resolvePropertyPlaceholders(routeContext, this);
        this.resolveKnownConstantFields(this);
        this.preCreateProcessor();
        if (routeContext.getCamelContext().getProcessorFactory() != null) {
            processor = routeContext.getCamelContext().getProcessorFactory().createProcessor(routeContext, this);
        }
        if (processor == null) {
            processor = this.createProcessor(routeContext);
        }
        if (processor == null) {
            return null;
        }
        return this.wrapProcessor(routeContext, processor);
    }

    protected void resolvePropertyPlaceholders(RouteContext routeContext, ProcessorDefinition definition) throws Exception {
        this.log.trace("Resolving property placeholders for: {}", (Object)definition);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(definition, properties, null);
        if (definition.getOtherAttributes() != null) {
            for (QName qName : definition.getOtherAttributes().keySet()) {
                QName qname = qName;
                if (!"http://camel.apache.org/schema/placeholder".equals(qname.getNamespaceURI())) continue;
                String local = qname.getLocalPart();
                Object value = definition.getOtherAttributes().get(qName);
                if (value != null && value instanceof String) {
                    String s = (String)value;
                    if (!s.startsWith("{{")) {
                        s = "{{" + s;
                    }
                    if (!s.endsWith("}}")) {
                        s = s + "}}";
                    }
                    value = s;
                }
                properties.put(local, value);
            }
        }
        if (!properties.isEmpty()) {
            this.log.trace("There are {} properties on: {}", (Object)properties.size(), (Object)definition);
            for (Map.Entry entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof String)) continue;
                String text = (String)value;
                text = routeContext.getCamelContext().resolvePropertyPlaceholders(text);
                if (text == value) continue;
                boolean changed = IntrospectionSupport.setProperty(routeContext.getCamelContext().getTypeConverter(), definition, name, text);
                if (!changed) {
                    throw new IllegalArgumentException("No setter to set property: " + name + " to: " + text + " on: " + definition);
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Changed property [{}] from: {} to: {}", new Object[]{name, value, text});
            }
        }
    }

    protected void resolveKnownConstantFields(ProcessorDefinition definition) throws Exception {
        this.log.trace("Resolving known fields for: {}", (Object)definition);
        HashMap properties = new HashMap();
        IntrospectionSupport.getProperties(definition, properties, null);
        if (!properties.isEmpty()) {
            this.log.trace("There are {} properties on: {}", (Object)properties.size(), (Object)definition);
            for (Map.Entry entry : properties.entrySet()) {
                String text;
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof String) || !(text = (String)value).startsWith("Exchange.")) continue;
                String field = ObjectHelper.after(text, "Exchange.");
                String constant = ObjectHelper.lookupConstantFieldValue(Exchange.class, field);
                if (constant != null) {
                    IntrospectionSupport.setProperty(definition, name, constant);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Changed property [{}] from: {} to: {}", new Object[]{name, value, constant});
                    continue;
                }
                throw new IllegalArgumentException("Constant field with name: " + field + " not found on Exchange.class");
            }
        }
    }

    protected ErrorHandlerBuilder createErrorHandlerBuilder() {
        if (this.errorHandlerRef != null) {
            return new ErrorHandlerBuilderRef(this.errorHandlerRef);
        }
        return new ErrorHandlerBuilderRef("CamelDefaultErrorHandlerBuilder");
    }

    protected void preCreateProcessor() {
    }

    protected void configureChild(ProcessorDefinition output) {
    }

    public Type placeholder(String option, String key) {
        QName name = new QName("http://camel.apache.org/schema/placeholder", option);
        return this.attribute(name, key);
    }

    public Type attribute(QName name, Object value) {
        if (this.otherAttributes == null) {
            this.otherAttributes = new HashMap<QName, Object>();
        }
        this.otherAttributes.put(name, value);
        return (Type)this;
    }

    public Type to(String uri) {
        this.addOutput(new ToDefinition(uri));
        return (Type)this;
    }

    public Type toF(String uri, Object ... args) {
        this.addOutput(new ToDefinition(String.format(uri, args)));
        return (Type)this;
    }

    public Type to(Endpoint endpoint) {
        this.addOutput(new ToDefinition(endpoint));
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, String uri) {
        this.addOutput(new ToDefinition(uri, pattern));
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, Endpoint endpoint) {
        this.addOutput(new ToDefinition(endpoint, pattern));
        return (Type)this;
    }

    public Type to(String ... uris) {
        for (String uri : uris) {
            this.addOutput(new ToDefinition(uri));
        }
        return (Type)this;
    }

    public Type to(Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint));
        }
        return (Type)this;
    }

    public Type to(Iterable<Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint));
        }
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, String ... uris) {
        for (String uri : uris) {
            this.addOutput(new ToDefinition(uri, pattern));
        }
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint, pattern));
        }
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, Iterable<Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint, pattern));
        }
        return (Type)this;
    }

    public Type setExchangePattern(ExchangePattern exchangePattern) {
        this.addOutput(new SetExchangePatternDefinition(exchangePattern));
        return (Type)this;
    }

    @Deprecated
    public Type inOnly() {
        return this.setExchangePattern(ExchangePattern.InOnly);
    }

    public Type inOnly(String uri) {
        return this.to(ExchangePattern.InOnly, uri);
    }

    public Type inOnly(Endpoint endpoint) {
        return this.to(ExchangePattern.InOnly, endpoint);
    }

    public Type inOnly(String ... uris) {
        return this.to(ExchangePattern.InOnly, uris);
    }

    public Type inOnly(Endpoint ... endpoints) {
        return this.to(ExchangePattern.InOnly, endpoints);
    }

    public Type inOnly(Iterable<Endpoint> endpoints) {
        return this.to(ExchangePattern.InOnly, endpoints);
    }

    @Deprecated
    public Type inOut() {
        return this.setExchangePattern(ExchangePattern.InOut);
    }

    public Type inOut(String uri) {
        return this.to(ExchangePattern.InOut, uri);
    }

    public Type inOut(Endpoint endpoint) {
        return this.to(ExchangePattern.InOut, endpoint);
    }

    public Type inOut(String ... uris) {
        return this.to(ExchangePattern.InOut, uris);
    }

    public Type inOut(Endpoint ... endpoints) {
        return this.to(ExchangePattern.InOut, endpoints);
    }

    public Type inOut(Iterable<Endpoint> endpoints) {
        return this.to(ExchangePattern.InOut, endpoints);
    }

    public Type id(String id) {
        if (this.getOutputs().isEmpty()) {
            this.setId(id);
        } else {
            ProcessorDefinition block;
            List<ProcessorDefinition> outputs = this.getOutputs();
            if (!this.blocks.isEmpty() && this.blocks.getLast() instanceof ProcessorDefinition && !(block = (ProcessorDefinition)this.blocks.getLast()).getOutputs().isEmpty()) {
                outputs = block.getOutputs();
            }
            outputs.get(outputs.size() - 1).setId(id);
        }
        return (Type)this;
    }

    public Type routeId(String id) {
        ProcessorDefinition def = this;
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(def);
        if (route != null) {
            route.setId(id);
        }
        return (Type)this;
    }

    public MulticastDefinition multicast() {
        MulticastDefinition answer = new MulticastDefinition();
        this.addOutput(answer);
        return answer;
    }

    public MulticastDefinition multicast(AggregationStrategy aggregationStrategy, boolean parallelProcessing) {
        MulticastDefinition answer = new MulticastDefinition();
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        answer.setParallelProcessing(parallelProcessing);
        return answer;
    }

    public MulticastDefinition multicast(AggregationStrategy aggregationStrategy) {
        MulticastDefinition answer = new MulticastDefinition();
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        return answer;
    }

    public PipelineDefinition pipeline() {
        PipelineDefinition answer = new PipelineDefinition();
        this.addOutput(answer);
        return answer;
    }

    public Type pipeline(String ... uris) {
        return this.to(uris);
    }

    public Type pipeline(Endpoint ... endpoints) {
        return this.to(endpoints);
    }

    public Type pipeline(Collection<Endpoint> endpoints) {
        return this.to(endpoints);
    }

    public ThreadsDefinition threads() {
        ThreadsDefinition answer = new ThreadsDefinition();
        this.addOutput(answer);
        return answer;
    }

    public ThreadsDefinition threads(int poolSize) {
        ThreadsDefinition answer = this.threads();
        answer.setPoolSize(poolSize);
        return answer;
    }

    public ThreadsDefinition threads(int poolSize, int maxPoolSize) {
        ThreadsDefinition answer = this.threads();
        answer.setPoolSize(poolSize);
        answer.setMaxPoolSize(maxPoolSize);
        return answer;
    }

    @Deprecated
    public AOPDefinition aop() {
        AOPDefinition answer = new AOPDefinition();
        this.addOutput(answer);
        return answer;
    }

    public ProcessorDefinition end() {
        ProcessorDefinition defn = this;
        if (defn instanceof TryDefinition || defn instanceof ChoiceDefinition) {
            this.popBlock();
        }
        if (this.blocks.isEmpty()) {
            if (this.parent == null) {
                return this.endParent();
            }
            return this.parent.endParent();
        }
        this.popBlock();
        return this.endParent();
    }

    public ProcessorDefinition endParent() {
        return this;
    }

    public ChoiceDefinition endChoice() {
        ProcessorDefinition def = this.end();
        if (def instanceof WhenDefinition) {
            return (ChoiceDefinition)def.getParent();
        }
        if (def instanceof OtherwiseDefinition) {
            return (ChoiceDefinition)def.getParent();
        }
        return (ChoiceDefinition)def;
    }

    public TryDefinition endDoTry() {
        return (TryDefinition)this.end();
    }

    public IdempotentConsumerDefinition idempotentConsumer(Expression messageIdExpression) {
        IdempotentConsumerDefinition answer = new IdempotentConsumerDefinition();
        answer.setExpression(new ExpressionDefinition(messageIdExpression));
        this.addOutput(answer);
        return answer;
    }

    public IdempotentConsumerDefinition idempotentConsumer(Expression messageIdExpression, IdempotentRepository<?> idempotentRepository) {
        IdempotentConsumerDefinition answer = new IdempotentConsumerDefinition(messageIdExpression, idempotentRepository);
        this.addOutput(answer);
        return answer;
    }

    @Deprecated
    public ExpressionClause<IdempotentConsumerDefinition> idempotentConsumer(IdempotentRepository<?> idempotentRepository) {
        IdempotentConsumerDefinition answer = new IdempotentConsumerDefinition();
        answer.setMessageIdRepository(idempotentRepository);
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public ExpressionClause<? extends FilterDefinition> filter() {
        FilterDefinition filter = new FilterDefinition();
        this.addOutput(filter);
        return ExpressionClause.createAndSetExpression(filter);
    }

    public FilterDefinition filter(Predicate predicate) {
        FilterDefinition filter = new FilterDefinition(predicate);
        this.addOutput(filter);
        return filter;
    }

    public FilterDefinition filter(ExpressionDefinition expression) {
        FilterDefinition filter = this.getNodeFactory().createFilter();
        filter.setExpression(expression);
        this.addOutput(filter);
        return filter;
    }

    public FilterDefinition filter(String language, String expression) {
        return this.filter(new LanguageExpression(language, expression));
    }

    public ValidateDefinition validate(Expression expression) {
        ValidateDefinition answer = new ValidateDefinition();
        answer.setExpression(new ExpressionDefinition(expression));
        this.addOutput(answer);
        return answer;
    }

    public ValidateDefinition validate(Predicate predicate) {
        ValidateDefinition answer = new ValidateDefinition();
        answer.setExpression(new ExpressionDefinition(predicate));
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<ValidateDefinition> validate() {
        ValidateDefinition answer = new ValidateDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public LoadBalanceDefinition loadBalance() {
        LoadBalanceDefinition answer = new LoadBalanceDefinition();
        this.addOutput(answer);
        return answer;
    }

    public LoadBalanceDefinition loadBalance(LoadBalancer loadBalancer) {
        LoadBalanceDefinition answer = new LoadBalanceDefinition();
        this.addOutput(answer);
        return answer.loadBalance(loadBalancer);
    }

    public Type log(String message) {
        LogDefinition answer = new LogDefinition(message);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type log(LoggingLevel loggingLevel, String message) {
        LogDefinition answer = new LogDefinition(message);
        answer.setLoggingLevel(loggingLevel);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type log(LoggingLevel loggingLevel, String logName, String message) {
        LogDefinition answer = new LogDefinition(message);
        answer.setLoggingLevel(loggingLevel);
        answer.setLogName(logName);
        this.addOutput(answer);
        return (Type)this;
    }

    public ChoiceDefinition choice() {
        ChoiceDefinition answer = new ChoiceDefinition();
        this.addOutput(answer);
        return answer;
    }

    public TryDefinition doTry() {
        TryDefinition answer = new TryDefinition();
        this.addOutput(answer);
        return answer;
    }

    public RecipientListDefinition<Type> recipientList(Expression recipients) {
        RecipientListDefinition answer = new RecipientListDefinition(recipients);
        this.addOutput(answer);
        return answer;
    }

    public RecipientListDefinition<Type> recipientList(Expression recipients, String delimiter) {
        RecipientListDefinition answer = new RecipientListDefinition(recipients);
        answer.setDelimiter(delimiter);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<RecipientListDefinition<Type>> recipientList() {
        RecipientListDefinition answer = new RecipientListDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    @Deprecated
    public Type routingSlip(String header, String uriDelimiter) {
        RoutingSlipDefinition answer = new RoutingSlipDefinition(header, uriDelimiter);
        this.addOutput(answer);
        return (Type)this;
    }

    @Deprecated
    public Type routingSlip(String header) {
        RoutingSlipDefinition answer = new RoutingSlipDefinition(header);
        this.addOutput(answer);
        return (Type)this;
    }

    @Deprecated
    public Type routingSlip(String header, String uriDelimiter, boolean ignoreInvalidEndpoints) {
        RoutingSlipDefinition answer = new RoutingSlipDefinition(header, uriDelimiter);
        answer.setIgnoreInvalidEndpoints(ignoreInvalidEndpoints);
        this.addOutput(answer);
        return (Type)this;
    }

    @Deprecated
    public Type routingSlip(String header, boolean ignoreInvalidEndpoints) {
        RoutingSlipDefinition answer = new RoutingSlipDefinition(header);
        answer.setIgnoreInvalidEndpoints(ignoreInvalidEndpoints);
        this.addOutput(answer);
        return (Type)this;
    }

    public RoutingSlipDefinition<Type> routingSlip(Expression expression, String uriDelimiter) {
        RoutingSlipDefinition answer = new RoutingSlipDefinition(expression, uriDelimiter);
        this.addOutput(answer);
        return answer;
    }

    public RoutingSlipDefinition<Type> routingSlip(Expression expression) {
        RoutingSlipDefinition answer = new RoutingSlipDefinition(expression);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<RoutingSlipDefinition<Type>> routingSlip() {
        RoutingSlipDefinition answer = new RoutingSlipDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public DynamicRouterDefinition<Type> dynamicRouter(Expression expression) {
        DynamicRouterDefinition answer = new DynamicRouterDefinition(expression);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<DynamicRouterDefinition<Type>> dynamicRouter() {
        DynamicRouterDefinition answer = new DynamicRouterDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public SamplingDefinition sample() {
        return this.sample(1L, TimeUnit.SECONDS);
    }

    public SamplingDefinition sample(long samplePeriod, TimeUnit unit) {
        SamplingDefinition answer = new SamplingDefinition(samplePeriod, unit);
        this.addOutput(answer);
        return answer;
    }

    public SamplingDefinition sample(long messageFrequency) {
        SamplingDefinition answer = new SamplingDefinition(messageFrequency);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<SplitDefinition> split() {
        SplitDefinition answer = new SplitDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public SplitDefinition split(Expression expression) {
        SplitDefinition answer = new SplitDefinition(expression);
        this.addOutput(answer);
        return answer;
    }

    public SplitDefinition split(Expression expression, AggregationStrategy aggregationStrategy) {
        SplitDefinition answer = new SplitDefinition(expression);
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        return answer;
    }

    public ExpressionClause<ResequenceDefinition> resequence() {
        ResequenceDefinition answer = new ResequenceDefinition();
        ExpressionClause<ResequenceDefinition> clause = new ExpressionClause<ResequenceDefinition>(answer);
        answer.setExpression(clause);
        this.addOutput(answer);
        return clause;
    }

    public ResequenceDefinition resequence(Expression expression) {
        ResequenceDefinition answer = new ResequenceDefinition();
        answer.setExpression(new ExpressionDefinition(expression));
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<AggregateDefinition> aggregate() {
        AggregateDefinition answer = new AggregateDefinition();
        ExpressionClause<AggregateDefinition> clause = new ExpressionClause<AggregateDefinition>(answer);
        answer.setExpression(clause);
        this.addOutput(answer);
        return clause;
    }

    public ExpressionClause<AggregateDefinition> aggregate(AggregationStrategy aggregationStrategy) {
        AggregateDefinition answer = new AggregateDefinition();
        ExpressionClause<AggregateDefinition> clause = new ExpressionClause<AggregateDefinition>(answer);
        answer.setExpression(clause);
        answer.setAggregationStrategy(aggregationStrategy);
        this.addOutput(answer);
        return clause;
    }

    public AggregateDefinition aggregate(Expression correlationExpression) {
        AggregateDefinition answer = new AggregateDefinition(correlationExpression);
        this.addOutput(answer);
        return answer;
    }

    public AggregateDefinition aggregate(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        AggregateDefinition answer = new AggregateDefinition(correlationExpression, aggregationStrategy);
        this.addOutput(answer);
        return answer;
    }

    public DelayDefinition delay(Expression delay) {
        DelayDefinition answer = new DelayDefinition(delay);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<DelayDefinition> delay() {
        DelayDefinition answer = new DelayDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public DelayDefinition delay(long delay) {
        return this.delay(ExpressionBuilder.constantExpression(delay));
    }

    public ThrottleDefinition throttle(long maximumRequestCount) {
        return this.throttle(ExpressionBuilder.constantExpression(maximumRequestCount));
    }

    public ThrottleDefinition throttle(Expression maximumRequestCount) {
        ThrottleDefinition answer = new ThrottleDefinition(maximumRequestCount);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<LoopDefinition> loop() {
        LoopDefinition loop = new LoopDefinition();
        this.addOutput(loop);
        return ExpressionClause.createAndSetExpression(loop);
    }

    public LoopDefinition loop(Expression expression) {
        LoopDefinition loop = this.getNodeFactory().createLoop();
        loop.setExpression(expression);
        this.addOutput(loop);
        return loop;
    }

    public LoopDefinition loop(int count) {
        LoopDefinition loop = this.getNodeFactory().createLoop();
        loop.setExpression(new ConstantExpression(Integer.toString(count)));
        this.addOutput(loop);
        return loop;
    }

    public Type throwException(Exception exception) {
        ThrowExceptionDefinition answer = new ThrowExceptionDefinition();
        answer.setException(exception);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type markRollbackOnly() {
        RollbackDefinition answer = new RollbackDefinition();
        answer.setMarkRollbackOnly(true);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type markRollbackOnlyLast() {
        RollbackDefinition answer = new RollbackDefinition();
        answer.setMarkRollbackOnlyLast(true);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type rollback() {
        return this.rollback(null);
    }

    public Type rollback(String message) {
        RollbackDefinition answer = new RollbackDefinition(message);
        this.addOutput(answer);
        return (Type)this;
    }

    public WireTapDefinition<Type> wireTap(String uri) {
        WireTapDefinition answer = new WireTapDefinition();
        answer.setUri(uri);
        this.addOutput(answer);
        return answer;
    }

    @Deprecated
    public WireTapDefinition<Type> wireTap(String uri, ExecutorService executorService) {
        WireTapDefinition answer = new WireTapDefinition();
        answer.setUri(uri);
        answer.setExecutorService(executorService);
        this.addOutput(answer);
        return answer;
    }

    @Deprecated
    public WireTapDefinition<Type> wireTap(String uri, String executorServiceRef) {
        WireTapDefinition answer = new WireTapDefinition();
        answer.setUri(uri);
        answer.setExecutorServiceRef(executorServiceRef);
        this.addOutput(answer);
        return answer;
    }

    @Deprecated
    public WireTapDefinition<Type> wireTap(String uri, Expression body) {
        return this.wireTap(uri, true, body);
    }

    @Deprecated
    public WireTapDefinition<Type> wireTap(String uri, boolean copy, Expression body) {
        WireTapDefinition answer = new WireTapDefinition();
        answer.setUri(uri);
        answer.setCopy(copy);
        answer.setNewExchangeExpression(body);
        this.addOutput(answer);
        return answer;
    }

    @Deprecated
    public WireTapDefinition<Type> wireTap(String uri, Processor processor) {
        return this.wireTap(uri, true, processor);
    }

    @Deprecated
    public WireTapDefinition<Type> wireTap(String uri, boolean copy, Processor processor) {
        WireTapDefinition answer = new WireTapDefinition();
        answer.setUri(uri);
        answer.setCopy(copy);
        answer.setNewExchangeProcessor(processor);
        this.addOutput(answer);
        return answer;
    }

    void pushBlock(Block block) {
        this.blocks.add(block);
    }

    Block popBlock() {
        return this.blocks.isEmpty() ? null : this.blocks.removeLast();
    }

    public Type stop() {
        StopDefinition stop = new StopDefinition();
        this.addOutput(stop);
        return (Type)this;
    }

    public OnExceptionDefinition onException(Class exceptionType) {
        OnExceptionDefinition answer = new OnExceptionDefinition(exceptionType);
        this.addOutput(answer);
        return answer;
    }

    public OnExceptionDefinition onException(Class ... exceptions) {
        OnExceptionDefinition answer = new OnExceptionDefinition(Arrays.asList(exceptions));
        this.addOutput(answer);
        return answer;
    }

    public PolicyDefinition policy(Policy policy) {
        PolicyDefinition answer = new PolicyDefinition(policy);
        this.addOutput(answer);
        return answer;
    }

    public PolicyDefinition policy(String ref) {
        PolicyDefinition answer = new PolicyDefinition();
        answer.setRef(ref);
        this.addOutput(answer);
        return answer;
    }

    public PolicyDefinition transacted() {
        PolicyDefinition answer = new PolicyDefinition();
        answer.setType(TransactedPolicy.class);
        this.addOutput(answer);
        return answer;
    }

    public PolicyDefinition transacted(String ref) {
        PolicyDefinition answer = new PolicyDefinition();
        answer.setType(TransactedPolicy.class);
        answer.setRef(ref);
        this.addOutput(answer);
        return answer;
    }

    public Type process(Processor processor) {
        ProcessDefinition answer = new ProcessDefinition(processor);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type processRef(String ref) {
        ProcessDefinition answer = new ProcessDefinition();
        answer.setRef(ref);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Object bean) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBean(bean);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Object bean, String method) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBean(bean);
        answer.setMethod(method);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Class beanType) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBeanType(beanType.getName());
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Class beanType, String method) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBeanType(beanType.getName());
        answer.setMethod(method);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type beanRef(String ref) {
        BeanDefinition answer = new BeanDefinition(ref);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type beanRef(String ref, String method) {
        BeanDefinition answer = new BeanDefinition(ref, method);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorDefinition<Type>> setBody() {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        SetBodyDefinition answer = new SetBodyDefinition((Expression)clause);
        this.addOutput(answer);
        return clause;
    }

    public Type setBody(Expression expression) {
        SetBodyDefinition answer = new SetBodyDefinition(expression);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type transform(Expression expression) {
        TransformDefinition answer = new TransformDefinition(expression);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorDefinition<Type>> transform() {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        TransformDefinition answer = new TransformDefinition((Expression)clause);
        this.addOutput(answer);
        return clause;
    }

    public Type setFaultBody(Expression expression) {
        return this.process(ProcessorBuilder.setFaultBody(expression));
    }

    public ExpressionClause<ProcessorDefinition<Type>> setHeader(String name) {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        SetHeaderDefinition answer = new SetHeaderDefinition(name, clause);
        this.addOutput(answer);
        return clause;
    }

    public Type setHeader(String name, Expression expression) {
        SetHeaderDefinition answer = new SetHeaderDefinition(name, expression);
        this.addOutput(answer);
        return (Type)this;
    }

    @Deprecated
    public ExpressionClause<ProcessorDefinition<Type>> setOutHeader(String name) {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        SetOutHeaderDefinition answer = new SetOutHeaderDefinition(name, clause);
        this.addOutput(answer);
        return clause;
    }

    @Deprecated
    public Type setOutHeader(String name, Expression expression) {
        SetOutHeaderDefinition answer = new SetOutHeaderDefinition(name, expression);
        this.addOutput(answer);
        return (Type)this;
    }

    @Deprecated
    public Type setFaultHeader(String name, Expression expression) {
        return this.process(ProcessorBuilder.setFaultHeader(name, expression));
    }

    public Type setProperty(String name, Expression expression) {
        SetPropertyDefinition answer = new SetPropertyDefinition(name, expression);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorDefinition<Type>> setProperty(String name) {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        SetPropertyDefinition answer = new SetPropertyDefinition(name, clause);
        this.addOutput(answer);
        return clause;
    }

    public Type removeHeader(String name) {
        RemoveHeaderDefinition answer = new RemoveHeaderDefinition(name);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type removeHeaders(String pattern) {
        RemoveHeadersDefinition answer = new RemoveHeadersDefinition(pattern);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type removeHeaders(String pattern, String ... excludePatterns) {
        RemoveHeadersDefinition answer = new RemoveHeadersDefinition(pattern, excludePatterns);
        this.addOutput(answer);
        return (Type)this;
    }

    @Deprecated
    public Type removeFaultHeader(String name) {
        return this.process(ProcessorBuilder.removeFaultHeader(name));
    }

    public Type removeProperty(String name) {
        RemovePropertyDefinition answer = new RemovePropertyDefinition(name);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type convertBodyTo(Class type) {
        this.addOutput(new ConvertBodyDefinition(type));
        return (Type)this;
    }

    public Type convertBodyTo(Class type, String charset) {
        this.addOutput(new ConvertBodyDefinition(type, charset));
        return (Type)this;
    }

    public Type sort(Expression expression) {
        return this.sort(expression, null);
    }

    public Type sort(Expression expression, Comparator comparator) {
        this.addOutput(new SortDefinition(expression, comparator));
        return (Type)this;
    }

    public ExpressionClause<SortDefinition> sort() {
        SortDefinition answer = new SortDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public Type enrich(String resourceUri, AggregationStrategy aggregationStrategy) {
        this.addOutput(new EnrichDefinition(aggregationStrategy, resourceUri));
        return (Type)this;
    }

    public Type enrich(String resourceUri) {
        this.addOutput(new EnrichDefinition(resourceUri));
        return (Type)this;
    }

    public Type enrichRef(String resourceRef, String aggregationStrategyRef) {
        EnrichDefinition enrich = new EnrichDefinition();
        enrich.setResourceRef(resourceRef);
        enrich.setAggregationStrategyRef(aggregationStrategyRef);
        this.addOutput(enrich);
        return (Type)this;
    }

    public Type pollEnrich(String resourceUri) {
        this.addOutput(new PollEnrichDefinition(null, resourceUri, 0L));
        return (Type)this;
    }

    public Type pollEnrich(String resourceUri, AggregationStrategy aggregationStrategy) {
        this.addOutput(new PollEnrichDefinition(aggregationStrategy, resourceUri, 0L));
        return (Type)this;
    }

    public Type pollEnrich(String resourceUri, long timeout, AggregationStrategy aggregationStrategy) {
        this.addOutput(new PollEnrichDefinition(aggregationStrategy, resourceUri, timeout));
        return (Type)this;
    }

    public Type pollEnrich(String resourceUri, long timeout) {
        this.addOutput(new PollEnrichDefinition(null, resourceUri, timeout));
        return (Type)this;
    }

    public Type pollEnrichRef(String resourceRef, long timeout, String aggregationStrategyRef) {
        PollEnrichDefinition pollEnrich = new PollEnrichDefinition();
        pollEnrich.setResourceRef(resourceRef);
        pollEnrich.setTimeout(timeout);
        pollEnrich.setAggregationStrategyRef(aggregationStrategyRef);
        this.addOutput(pollEnrich);
        return (Type)this;
    }

    public OnCompletionDefinition onCompletion() {
        OnCompletionDefinition answer = new OnCompletionDefinition();
        answer.removeAllOnCompletionDefinition(this);
        this.popBlock();
        this.addOutput(answer);
        this.pushBlock(answer);
        return answer;
    }

    public DataFormatClause<ProcessorDefinition<Type>> unmarshal() {
        return new DataFormatClause<ProcessorDefinition<Type>>(this, DataFormatClause.Operation.Unmarshal);
    }

    public Type unmarshal(DataFormatDefinition dataFormatType) {
        this.addOutput(new UnmarshalDefinition(dataFormatType));
        return (Type)this;
    }

    public Type unmarshal(DataFormat dataFormat) {
        return this.unmarshal(new DataFormatDefinition(dataFormat));
    }

    public Type unmarshal(String dataTypeRef) {
        this.addOutput(new UnmarshalDefinition(dataTypeRef));
        return (Type)this;
    }

    public DataFormatClause<ProcessorDefinition<Type>> marshal() {
        return new DataFormatClause<ProcessorDefinition<Type>>(this, DataFormatClause.Operation.Marshal);
    }

    public Type marshal(DataFormatDefinition dataFormatType) {
        this.addOutput(new MarshalDefinition(dataFormatType));
        return (Type)this;
    }

    public Type marshal(DataFormat dataFormat) {
        return this.marshal(new DataFormatDefinition(dataFormat));
    }

    public Type marshal(String dataTypeRef) {
        this.addOutput(new MarshalDefinition(dataTypeRef));
        return (Type)this;
    }

    public Type inheritErrorHandler(boolean inheritErrorHandler) {
        int size = this.getOutputs().size();
        if (size == 0) {
            this.setInheritErrorHandler(inheritErrorHandler);
        } else {
            ProcessorDefinition output = this.getOutputs().get(size - 1);
            if (output != null) {
                output.setInheritErrorHandler(inheritErrorHandler);
            }
        }
        return (Type)this;
    }

    @XmlTransient
    public ProcessorDefinition getParent() {
        return this.parent;
    }

    public void setParent(ProcessorDefinition parent) {
        this.parent = parent;
    }

    @XmlTransient
    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        if (this.errorHandlerBuilder == null) {
            this.errorHandlerBuilder = this.createErrorHandlerBuilder();
        }
        return this.errorHandlerBuilder;
    }

    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }

    @XmlTransient
    public NodeFactory getNodeFactory() {
        if (this.nodeFactory == null) {
            this.nodeFactory = new NodeFactory();
        }
        return this.nodeFactory;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    @XmlTransient
    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void addInterceptStrategy(InterceptStrategy strategy) {
        this.interceptStrategies.add(strategy);
    }

    public Boolean isInheritErrorHandler() {
        return this.inheritErrorHandler;
    }

    @XmlAttribute
    public void setInheritErrorHandler(Boolean inheritErrorHandler) {
        this.inheritErrorHandler = inheritErrorHandler;
    }

    public Map<QName, Object> getOtherAttributes() {
        return this.otherAttributes;
    }

    @XmlAnyAttribute
    public void setOtherAttributes(Map<QName, Object> otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public String getLabel() {
        return "";
    }
}

