/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.builder.ProcessorBuilder;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="removeHeaders")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RemoveHeadersDefinition
extends NoOutputDefinition<RemoveHeadersDefinition> {
    @XmlAttribute(required=true)
    private String pattern;
    @XmlAttribute
    private String excludePattern;
    @XmlTransient
    private String[] excludePatterns;

    public RemoveHeadersDefinition() {
    }

    public RemoveHeadersDefinition(String pattern) {
        this.setPattern(pattern);
    }

    public RemoveHeadersDefinition(String pattern, String ... excludePatterns) {
        this.setPattern(pattern);
        this.setExcludePatterns(excludePatterns);
    }

    public String toString() {
        return "RemoveHeaders[" + this.getPattern() + "]";
    }

    @Override
    public String getShortName() {
        return "removeHeaders";
    }

    @Override
    public String getLabel() {
        return "removeHeaders[" + this.getPattern() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ObjectHelper.notNull(this.getPattern(), "patterns", this);
        if (this.getExcludePatterns() != null) {
            return ProcessorBuilder.removeHeaders(this.getPattern(), this.getExcludePatterns());
        }
        if (this.getExcludePattern() != null) {
            return ProcessorBuilder.removeHeaders(this.getPattern(), this.getExcludePattern());
        }
        return ProcessorBuilder.removeHeaders(this.getPattern());
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String[] getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(String[] excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
    }
}

