/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.zookeeper.KeeperException;
import org.codehaus.jackson.map.ObjectMapper;
import org.fusesource.fabric.commands.support.FabricCommand;

@Command(name="cluster-list", scope="fabric", description="List the contents of a cluster")
public class ClusterList
extends FabricCommand {
    protected static String CLUSTER_PREFIX = "/fabric/registry/clusters";
    @Argument(description="Path of the node to list")
    String path = "";

    protected Object doExecute() throws Exception {
        String realPath = this.path;
        if (!realPath.startsWith("/")) {
            realPath = CLUSTER_PREFIX;
            if (this.path.length() > 0) {
                realPath = realPath + "/" + this.path;
            }
        }
        this.printCluster(realPath, System.out);
        return null;
    }

    protected void printCluster(String dir, PrintStream out) throws InterruptedException, KeeperException, IOException {
        out.println(String.format("%-30s %-30s %-10s %s", "[cluster]", "[id]", "[master]", "[services]"));
        this.printChildren(dir, dir, out);
    }

    private void printChildren(String rootDir, String dir, PrintStream out) throws KeeperException, InterruptedException, IOException {
        List children = this.getZooKeeper().getChildren(dir, false);
        boolean master = true;
        for (String child : children) {
            String text;
            String childDir = dir + "/" + child;
            byte[] data = this.getZooKeeper().getData(childDir);
            if (data != null && data.length > 0 && !(text = new String(data).trim()).isEmpty()) {
                String clusterName = dir;
                if (clusterName.startsWith(rootDir)) {
                    clusterName = clusterName.substring(rootDir.length());
                }
                if (clusterName.startsWith("/")) {
                    clusterName = clusterName.substring(1);
                }
                ObjectMapper mapper = new ObjectMapper();
                Map map = (Map)mapper.readValue(data, HashMap.class);
                Object id = this.value(map, "id", "agent");
                Object services = this.value(map, "services");
                if (services != null) {
                    String serviceText = services.toString();
                    if (serviceText.startsWith("[") && serviceText.endsWith("]")) {
                        serviceText = serviceText.substring(1, serviceText.length() - 1);
                    }
                    services = serviceText;
                }
                out.println(String.format("%-30s %-30s %-10s %s", clusterName, id, master, services));
                master = false;
            }
            this.printChildren(rootDir, childDir, out);
        }
    }

    protected Object value(Map<String, Object> map, String ... keys) {
        for (String key : keys) {
            Object value = map.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

