/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.PrintStream;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.commands.support.FabricCommand;

@Command(name="profile-list", scope="fabric", description="List existing profiles")
public class ProfileList
extends FabricCommand {
    @Option(name="--version")
    private String version;

    protected Object doExecute() throws Exception {
        Version ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        Profile[] profiles = ver.getProfiles();
        this.printProfiles(profiles, System.out);
        return null;
    }

    protected void printProfiles(Profile[] profiles, PrintStream out) {
        out.println(String.format("%-30s %s", "[id]", "[parents]"));
        for (Profile profile : profiles) {
            out.println(String.format("%-30s %s", profile.getId(), this.toString(profile.getParents())));
        }
    }
}

