/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.zookeeper.commands.ZooKeeperCommandSupport;

@Command(name="list", scope="zk", description="List a node's children")
public class List
extends ZooKeeperCommandSupport {
    @Argument(description="Path of the node to list")
    String path = "/";
    @Option(name="-r", aliases={"--recursive"}, description="Display children recursively")
    boolean recursive = false;
    @Option(name="-d", aliases={"--display"}, description="Display a node's value if set")
    boolean display = false;

    protected Object doExecute() throws Exception {
        this.display(this.path);
        return null;
    }

    private java.util.List<String> getPaths() throws Exception {
        if (this.recursive) {
            return this.getZooKeeper().getAllChildren(this.path);
        }
        return this.getZooKeeper().getChildren(this.path);
    }

    protected void display(String path) throws Exception {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        java.util.List<String> paths = this.getPaths();
        for (String p : paths) {
            if (this.display) {
                byte[] data = this.getZooKeeper().getData(path + p);
                if (data != null) {
                    System.out.printf("%s = %s\n", p, new String(data));
                    continue;
                }
                System.out.println(p);
                continue;
            }
            System.out.println(p);
        }
    }
}

