/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jute.BinaryOutputArchive;
import org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.quorum.LeaderBean;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.server.quorum.LearnerSyncRequest;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.StateSummary;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.server.util.ZxidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Leader {
    private static final Logger LOG = LoggerFactory.getLogger(Leader.class);
    private static final boolean nodelay = System.getProperty("leader.nodelay", "true").equals("true");
    final LeaderZooKeeperServer zk;
    final QuorumPeer self;
    LearnerCnxAcceptor cnxAcceptor;
    public final HashSet<LearnerHandler> learners = new HashSet();
    public final HashSet<LearnerHandler> forwardingFollowers = new HashSet();
    protected final HashSet<LearnerHandler> observingLearners = new HashSet();
    public final HashMap<Long, List<LearnerSyncRequest>> pendingSyncs = new HashMap();
    final AtomicLong followerCounter = new AtomicLong(-1L);
    ServerSocket ss;
    static final int DIFF = 13;
    static final int TRUNC = 14;
    static final int SNAP = 15;
    static final int OBSERVERINFO = 16;
    static final int NEWLEADER = 10;
    static final int FOLLOWERINFO = 11;
    static final int UPTODATE = 12;
    public static final int LEADERINFO = 17;
    public static final int ACKEPOCH = 18;
    static final int REQUEST = 1;
    public static final int PROPOSAL = 2;
    static final int ACK = 3;
    static final int COMMIT = 4;
    static final int PING = 5;
    static final int REVALIDATE = 6;
    static final int SYNC = 7;
    static final int INFORM = 8;
    ConcurrentMap<Long, Proposal> outstandingProposals = new ConcurrentHashMap<Long, Proposal>();
    ConcurrentLinkedQueue<Proposal> toBeApplied = new ConcurrentLinkedQueue();
    Proposal newLeaderProposal = new Proposal();
    StateSummary leaderStateSummary;
    long epoch = -1L;
    boolean waitingForNewEpoch = true;
    volatile boolean readyToStart = false;
    boolean isShutdown;
    long lastCommitted = -1L;
    long lastProposed;
    private HashSet<Long> connectingFollowers = new HashSet();
    private HashSet<Long> electingFollowers = new HashSet();
    private boolean electionFinished = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLearnerHandler(LearnerHandler learner) {
        HashSet<LearnerHandler> hashSet = this.learners;
        synchronized (hashSet) {
            this.learners.add(learner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLearnerHandler(LearnerHandler peer) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            this.forwardingFollowers.remove(peer);
        }
        hashSet = this.learners;
        synchronized (hashSet) {
            this.learners.remove(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLearnerSynced(LearnerHandler peer) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            return this.forwardingFollowers.contains(peer);
        }
    }

    Leader(QuorumPeer self, LeaderZooKeeperServer zk) throws IOException {
        this.self = self;
        try {
            this.ss = new ServerSocket(self.getQuorumAddress().getPort());
        }
        catch (BindException e) {
            LOG.error("Couldn't bind to port " + self.getQuorumAddress().getPort(), (Throwable)e);
            throw e;
        }
        this.zk = zk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void lead() throws IOException, InterruptedException {
        this.self.end_fle = System.currentTimeMillis();
        LOG.info("LEADING - LEADER ELECTION TOOK - " + (this.self.end_fle - this.self.start_fle));
        this.self.start_fle = 0L;
        this.self.end_fle = 0L;
        this.zk.registerJMX(new LeaderBean(this, this.zk), this.self.jmxLocalPeerBean);
        try {
            this.self.tick = 0;
            this.zk.loadData();
            this.leaderStateSummary = new StateSummary(this.self.getCurrentEpoch(), this.zk.getLastProcessedZxid());
            this.cnxAcceptor = new LearnerCnxAcceptor();
            this.cnxAcceptor.start();
            this.readyToStart = true;
            long epoch = this.getEpochToPropose(this.self.getId(), this.self.getAcceptedEpoch());
            this.zk.setZxid(ZxidUtils.makeZxid(epoch, 0L));
            Leader leader = this;
            // MONITORENTER : leader
            this.lastProposed = this.zk.getZxid();
            // MONITOREXIT : leader
            this.newLeaderProposal.packet = new QuorumPacket(10, this.zk.getZxid(), null, null);
            if ((this.newLeaderProposal.packet.getZxid() & 0xFFFFFFFFL) != 0L) {
                LOG.info("NEWLEADER proposal has Zxid of " + Long.toHexString(this.newLeaderProposal.packet.getZxid()));
            }
            this.outstandingProposals.put(this.newLeaderProposal.packet.getZxid(), this.newLeaderProposal);
            this.newLeaderProposal.ackSet.add(this.self.getId());
            this.waitForEpochAck(this.self.getId(), this.leaderStateSummary);
            this.self.setCurrentEpoch(epoch);
            while (!this.self.getQuorumVerifier().containsQuorum(this.newLeaderProposal.ackSet)) {
                if (this.self.tick > this.self.initLimit) {
                    StringBuilder ackToString = new StringBuilder();
                    for (Long id : this.newLeaderProposal.ackSet) {
                        ackToString.append(id + ": ");
                    }
                    this.shutdown("Waiting for a quorum of followers, only synced with: " + ackToString);
                    HashSet<Long> followerSet = new HashSet<Long>();
                    for (LearnerHandler f : this.learners) {
                        followerSet.add(f.getSid());
                    }
                    if (this.self.getQuorumVerifier().containsQuorum(followerSet)) {
                        LOG.warn("Enough followers present. Perhaps the initTicks need to be increased.");
                    }
                    Object var11_10 = null;
                    this.zk.unregisterJMX(this);
                    return;
                }
                Thread.sleep(this.self.tickTime);
                ++this.self.tick;
            }
            if (!System.getProperty("zookeeper.leaderServes", "yes").equals("no")) {
                this.self.cnxnFactory.setZooKeeperServer(this.zk);
            }
            boolean tickSkip = true;
            while (true) {
                Thread.sleep(this.self.tickTime / 2);
                if (!tickSkip) {
                    ++this.self.tick;
                }
                int syncedCount = 0;
                HashSet<Long> syncedSet = new HashSet<Long>();
                syncedSet.add(this.self.getId());
                HashSet<LearnerHandler> hashSet = this.learners;
                // MONITORENTER : hashSet
                for (LearnerHandler f : this.learners) {
                    if (f.synced()) {
                        ++syncedCount;
                        syncedSet.add(f.getSid());
                    }
                    f.ping();
                }
                // MONITOREXIT : hashSet
                if (!tickSkip && !this.self.getQuorumVerifier().containsQuorum(syncedSet)) {
                    this.shutdown("Only " + syncedCount + " followers, need " + this.self.getVotingView().size() / 2);
                    Object var11_11 = null;
                    this.zk.unregisterJMX(this);
                    return;
                }
                tickSkip = !tickSkip;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.zk.unregisterJMX(this);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown(String reason) {
        LOG.info("Shutting down");
        if (this.isShutdown) {
            return;
        }
        LOG.info("Shutdown called", (Throwable)new Exception("shutdown Leader! reason: " + reason));
        if (this.cnxAcceptor != null) {
            this.cnxAcceptor.halt();
        }
        this.self.cnxnFactory.setZooKeeperServer(null);
        try {
            this.ss.close();
        }
        catch (IOException e) {
            LOG.warn("Ignoring unexpected exception during close", (Throwable)e);
        }
        this.self.cnxnFactory.closeAll();
        if (this.zk != null) {
            this.zk.shutdown();
        }
        HashSet<LearnerHandler> hashSet = this.learners;
        synchronized (hashSet) {
            Iterator<LearnerHandler> it = this.learners.iterator();
            while (it.hasNext()) {
                LearnerHandler f = it.next();
                it.remove();
                f.shutdown();
            }
        }
        this.isShutdown = true;
    }

    public synchronized void processAck(long sid, long zxid, SocketAddress followerAddr) {
        boolean first = true;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Ack zxid: 0x" + Long.toHexString(zxid));
            for (Proposal p : this.outstandingProposals.values()) {
                long packetZxid = p.packet.getZxid();
                LOG.trace("outstanding proposal: 0x" + Long.toHexString(packetZxid));
            }
            LOG.trace("outstanding proposals all");
        }
        if (this.outstandingProposals.size() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("outstanding is 0");
            }
            return;
        }
        if (this.lastCommitted >= zxid) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("proposal has already been committed, pzxid:" + this.lastCommitted + " zxid: 0x" + Long.toHexString(zxid));
            }
            return;
        }
        Proposal p = (Proposal)this.outstandingProposals.get(zxid);
        if (p == null) {
            LOG.warn("Trying to commit future proposal: zxid 0x" + Long.toHexString(zxid) + " from " + followerAddr);
            return;
        }
        p.ackSet.add(sid);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Count for zxid: 0x" + Long.toHexString(zxid) + " is " + p.ackSet.size());
        }
        if (this.self.getQuorumVerifier().containsQuorum(p.ackSet)) {
            if (zxid != this.lastCommitted + 1L) {
                LOG.warn("Commiting zxid 0x" + Long.toHexString(zxid) + " from " + followerAddr + " not first!");
                LOG.warn("First is " + (this.lastCommitted + 1L));
            }
            this.outstandingProposals.remove(zxid);
            if (p.request != null) {
                this.toBeApplied.add(p);
            }
            if ((zxid & 0xFFFFFFFFL) != 0L) {
                if (p.request == null) {
                    LOG.warn("Going to commmit null: " + p);
                }
                this.commit(zxid);
                this.inform(p);
                this.zk.commitProcessor.commit(p.request);
                if (this.pendingSyncs.containsKey(zxid)) {
                    for (LearnerSyncRequest r : this.pendingSyncs.remove(zxid)) {
                        this.sendSync(r);
                    }
                }
                return;
            }
            this.lastCommitted = zxid;
            if (LOG.isInfoEnabled()) {
                LOG.info("Have quorum of supporters; starting up and setting last processed zxid: " + this.zk.getZxid());
            }
            this.zk.startup();
            this.zk.getZKDatabase().setlastProcessedZxid(this.zk.getZxid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPacket(QuorumPacket qp) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            for (LearnerHandler f : this.forwardingFollowers) {
                f.queuePacket(qp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendObserverPacket(QuorumPacket qp) {
        HashSet<LearnerHandler> hashSet = this.observingLearners;
        synchronized (hashSet) {
            for (LearnerHandler f : this.observingLearners) {
                f.queuePacket(qp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(long zxid) {
        Leader leader = this;
        synchronized (leader) {
            this.lastCommitted = zxid;
        }
        QuorumPacket qp = new QuorumPacket(4, zxid, null, null);
        this.sendPacket(qp);
    }

    public void inform(Proposal proposal) {
        QuorumPacket qp = new QuorumPacket(8, proposal.request.zxid, proposal.packet.getData(), null);
        this.sendObserverPacket(qp);
    }

    public long getEpoch() {
        return ZxidUtils.getEpochFromZxid(this.lastProposed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Proposal propose(Request request) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
        try {
            request.hdr.serialize(boa, "hdr");
            if (request.txn != null) {
                request.txn.serialize(boa, "txn");
            }
            baos.close();
        }
        catch (IOException e) {
            LOG.warn("This really should be impossible", (Throwable)e);
        }
        QuorumPacket pp = new QuorumPacket(2, request.zxid, baos.toByteArray(), null);
        Proposal p = new Proposal();
        p.packet = pp;
        p.request = request;
        Leader leader = this;
        synchronized (leader) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Proposing:: " + request);
            }
            this.lastProposed = p.packet.getZxid();
            this.outstandingProposals.put(this.lastProposed, p);
            this.sendPacket(pp);
        }
        return p;
    }

    public synchronized void processSync(LearnerSyncRequest r) {
        if (this.outstandingProposals.isEmpty()) {
            this.sendSync(r);
        } else {
            List<LearnerSyncRequest> l = this.pendingSyncs.get(this.lastProposed);
            if (l == null) {
                l = new ArrayList<LearnerSyncRequest>();
            }
            l.add(r);
            this.pendingSyncs.put(this.lastProposed, l);
        }
    }

    public void sendSync(LearnerSyncRequest r) {
        QuorumPacket qp = new QuorumPacket(7, 0L, null, null);
        r.fh.queuePacket(qp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long startForwarding(LearnerHandler handler, long lastSeenZxid) {
        HashSet<LearnerHandler> hashSet;
        if (this.lastProposed > lastSeenZxid) {
            for (Proposal p : this.toBeApplied) {
                if (p.packet.getZxid() <= lastSeenZxid) continue;
                handler.queuePacket(p.packet);
                QuorumPacket qp = new QuorumPacket(4, p.packet.getZxid(), null, null);
                handler.queuePacket(qp);
            }
            ArrayList zxids = new ArrayList(this.outstandingProposals.keySet());
            Collections.sort(zxids);
            for (Long zxid : zxids) {
                if (zxid <= lastSeenZxid) continue;
                handler.queuePacket(((Proposal)this.outstandingProposals.get((Object)zxid)).packet);
            }
        }
        if (handler.getLearnerType() == QuorumPeer.LearnerType.PARTICIPANT) {
            hashSet = this.forwardingFollowers;
            synchronized (hashSet) {
                this.forwardingFollowers.add(handler);
            }
        }
        hashSet = this.observingLearners;
        synchronized (hashSet) {
            this.observingLearners.add(handler);
        }
        return this.lastProposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEpochToPropose(long sid, long lastAcceptedEpoch) throws InterruptedException, IOException {
        HashSet<Long> hashSet = this.connectingFollowers;
        synchronized (hashSet) {
            if (!this.waitingForNewEpoch) {
                return this.epoch;
            }
            if (lastAcceptedEpoch > this.epoch) {
                this.epoch = lastAcceptedEpoch + 1L;
            }
            this.connectingFollowers.add(sid);
            QuorumVerifier verifier = this.self.getQuorumVerifier();
            if (this.connectingFollowers.contains(this.self.getId()) && verifier.containsQuorum(this.connectingFollowers)) {
                this.waitingForNewEpoch = false;
                this.self.setAcceptedEpoch(this.epoch);
                this.connectingFollowers.notifyAll();
            } else {
                long start;
                long cur = start = System.currentTimeMillis();
                long end = start + (long)(this.self.getInitLimit() * this.self.getTickTime());
                while (this.waitingForNewEpoch && cur < end) {
                    this.connectingFollowers.wait(end - cur);
                    cur = System.currentTimeMillis();
                }
                if (this.waitingForNewEpoch) {
                    throw new InterruptedException("Timeout while waiting for epoch from quorum");
                }
            }
            return this.epoch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEpochAck(long id, StateSummary ss) throws IOException, InterruptedException {
        HashSet<Long> hashSet = this.electingFollowers;
        synchronized (hashSet) {
            if (this.electionFinished) {
                return;
            }
            if (ss.getCurrentEpoch() != -1L) {
                if (ss.isMoreRecentThan(this.leaderStateSummary)) {
                    throw new IOException("Follower is ahead of the leader");
                }
                this.electingFollowers.add(id);
            }
            QuorumVerifier verifier = this.self.getQuorumVerifier();
            if (this.electingFollowers.contains(this.self.getId()) && verifier.containsQuorum(this.electingFollowers)) {
                this.electionFinished = true;
                this.electingFollowers.notifyAll();
            } else {
                long start;
                long cur = start = System.currentTimeMillis();
                long end = start + (long)(this.self.getInitLimit() * this.self.getTickTime());
                while (!this.electionFinished && cur < end) {
                    this.electingFollowers.wait(end - cur);
                    cur = System.currentTimeMillis();
                }
                if (!this.electionFinished) {
                    throw new InterruptedException("Timeout while waiting for epoch to be acked by quorum");
                }
            }
        }
    }

    static {
        LOG.info("TCP NoDelay set to: " + nodelay);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ToBeAppliedRequestProcessor
    implements RequestProcessor {
        private RequestProcessor next;
        private ConcurrentLinkedQueue<Proposal> toBeApplied;

        ToBeAppliedRequestProcessor(RequestProcessor next, ConcurrentLinkedQueue<Proposal> toBeApplied) {
            if (!(next instanceof FinalRequestProcessor)) {
                throw new RuntimeException(ToBeAppliedRequestProcessor.class.getName() + " must be connected to " + FinalRequestProcessor.class.getName() + " not " + next.getClass().getName());
            }
            this.toBeApplied = toBeApplied;
            this.next = next;
        }

        @Override
        public void processRequest(Request request) {
            this.next.processRequest(request);
            Proposal p = this.toBeApplied.peek();
            if (p != null && p.request != null && p.request.zxid == request.zxid) {
                this.toBeApplied.remove();
            }
        }

        @Override
        public void shutdown() {
            LOG.info("Shutting down");
            this.next.shutdown();
        }
    }

    class LearnerCnxAcceptor
    extends Thread {
        private volatile boolean stop = false;

        LearnerCnxAcceptor() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                while (!this.stop) {
                    try {
                        Socket s = Leader.this.ss.accept();
                        s.setSoTimeout(Leader.this.self.tickTime * Leader.this.self.syncLimit);
                        s.setTcpNoDelay(nodelay);
                        LearnerHandler fh = new LearnerHandler(s, Leader.this);
                        fh.start();
                    }
                    catch (SocketException e) {
                        if (!this.stop) throw e;
                        LOG.info("exception while shutting down acceptor: " + e);
                        this.stop = true;
                        continue;
                        return;
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Exception while accepting follower", (Throwable)e);
            }
        }

        public void halt() {
            this.stop = true;
        }
    }

    public static class Proposal {
        public QuorumPacket packet;
        public HashSet<Long> ackSet = new HashSet();
        public Request request;

        public String toString() {
            return this.packet.getType() + ", " + this.packet.getZxid() + ", " + this.request;
        }
    }
}

