/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.bytebuffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.bytebuffer.ByteBufferFile;

public class ByteBufferIndexInput
extends IndexInput {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0).asReadOnlyBuffer();
    private final ByteBufferFile file;
    private final long length;
    private ByteBuffer currentBuffer;
    private int currentBufferIndex;
    private long bufferStart;
    private final int BUFFER_SIZE;

    public ByteBufferIndexInput(ByteBufferFile file) throws IOException {
        this.file = file;
        this.length = file.getLength();
        this.BUFFER_SIZE = file.bufferSize;
        this.currentBufferIndex = -1;
        this.currentBuffer = EMPTY_BUFFER;
    }

    @Override
    public void close() {
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte readByte() throws IOException {
        if (!this.currentBuffer.hasRemaining()) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer(true);
        }
        return this.currentBuffer.get();
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            int remainInBuffer;
            if (!this.currentBuffer.hasRemaining()) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer(true);
            }
            int bytesToCopy = len < (remainInBuffer = this.currentBuffer.remaining()) ? len : remainInBuffer;
            this.currentBuffer.get(b, offset, bytesToCopy);
            offset += bytesToCopy;
            len -= bytesToCopy;
        }
    }

    @Override
    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.currentBuffer.position();
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.currentBuffer == EMPTY_BUFFER || pos < this.bufferStart || pos >= this.bufferStart + (long)this.BUFFER_SIZE) {
            this.currentBufferIndex = (int)(pos / (long)this.BUFFER_SIZE);
            if (this.currentBufferIndex >= this.file.numBuffers()) {
                this.currentBufferIndex = this.file.numBuffers() - 1;
                this.currentBuffer = this.currentBufferIndex == -1 ? EMPTY_BUFFER : this.file.getBuffer(this.currentBufferIndex);
                this.currentBuffer.position(this.currentBuffer.limit());
                return;
            }
            this.switchCurrentBuffer(false);
        }
        try {
            this.currentBuffer.position((int)(pos % (long)this.BUFFER_SIZE));
        }
        catch (IllegalArgumentException e) {
            this.currentBuffer.position(this.currentBuffer.limit());
        }
    }

    private void switchCurrentBuffer(boolean enforceEOF) throws IOException {
        if (this.currentBufferIndex >= this.file.numBuffers()) {
            if (enforceEOF) {
                throw new IOException("Read past EOF");
            }
        } else {
            ByteBuffer buffer = this.file.getBuffer(this.currentBufferIndex);
            this.currentBuffer = buffer.asReadOnlyBuffer();
            this.currentBuffer.position(0);
            this.bufferStart = (long)this.BUFFER_SIZE * (long)this.currentBufferIndex;
            long buflen = this.length - this.bufferStart;
            if (buflen < (long)this.BUFFER_SIZE) {
                this.currentBuffer.limit((int)buflen);
                if (enforceEOF && buflen == 0L) {
                    throw new IOException("Read past EOF");
                }
            }
        }
    }

    @Override
    public Object clone() {
        ByteBufferIndexInput cloned = (ByteBufferIndexInput)super.clone();
        if (this.currentBuffer != EMPTY_BUFFER) {
            cloned.currentBuffer = this.currentBuffer.asReadOnlyBuffer();
            cloned.currentBuffer.position(this.currentBuffer.position());
        }
        return cloned;
    }
}

