/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationExplanation;
import org.elasticsearch.index.shard.ShardId;

public class RoutingAllocation {
    private final RoutingNodes routingNodes;
    private final DiscoveryNodes nodes;
    private final AllocationExplanation explanation = new AllocationExplanation();
    private Map<ShardId, String> ignoredShardToNodes = null;

    public RoutingAllocation(RoutingNodes routingNodes, DiscoveryNodes nodes) {
        this.routingNodes = routingNodes;
        this.nodes = nodes;
    }

    public RoutingTable routingTable() {
        return this.routingNodes.routingTable();
    }

    public RoutingNodes routingNodes() {
        return this.routingNodes;
    }

    public DiscoveryNodes nodes() {
        return this.nodes;
    }

    public AllocationExplanation explanation() {
        return this.explanation;
    }

    public void addIgnoreShardForNode(ShardId shardId, String nodeId) {
        if (this.ignoredShardToNodes == null) {
            this.ignoredShardToNodes = new HashMap<ShardId, String>();
        }
        this.ignoredShardToNodes.put(shardId, nodeId);
    }

    public boolean shouldIgnoreShardForNode(ShardId shardId, String nodeId) {
        return this.ignoredShardToNodes != null && nodeId.equals(this.ignoredShardToNodes.get(shardId));
    }

    public static class Result {
        private final boolean changed;
        private final RoutingTable routingTable;
        private final AllocationExplanation explanation;

        public Result(boolean changed, RoutingTable routingTable, AllocationExplanation explanation) {
            this.changed = changed;
            this.routingTable = routingTable;
            this.explanation = explanation;
        }

        public boolean changed() {
            return this.changed;
        }

        public RoutingTable routingTable() {
            return this.routingTable;
        }

        public AllocationExplanation explanation() {
            return this.explanation;
        }
    }
}

