/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.operation.plain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.operation.OperationRouting;
import org.elasticsearch.cluster.routing.operation.hash.HashFunction;
import org.elasticsearch.cluster.routing.operation.hash.djb.DjbHashFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexShardMissingException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexMissingException;

public class PlainOperationRouting
extends AbstractComponent
implements OperationRouting {
    public static final Pattern routingPattern = Pattern.compile(",");
    private final HashFunction hashFunction;
    private final boolean useType;

    @Inject
    public PlainOperationRouting(Settings indexSettings, HashFunction hashFunction) {
        super(indexSettings);
        this.hashFunction = hashFunction;
        this.useType = indexSettings.getAsBoolean("cluster.routing.operation.use_type", false);
    }

    @Override
    public ShardIterator indexShards(ClusterState clusterState, String index, String type, String id, @Nullable String routing) throws IndexMissingException, IndexShardMissingException {
        return this.shards(clusterState, index, type, id, routing).shardsIt();
    }

    @Override
    public ShardIterator deleteShards(ClusterState clusterState, String index, String type, String id, @Nullable String routing) throws IndexMissingException, IndexShardMissingException {
        return this.shards(clusterState, index, type, id, routing).shardsIt();
    }

    @Override
    public ShardIterator getShards(ClusterState clusterState, String index, String type, String id, @Nullable String routing, @Nullable String preference) throws IndexMissingException, IndexShardMissingException {
        return this.preferenceShardIterator(this.shards(clusterState, index, type, id, routing), clusterState.nodes().localNodeId(), preference);
    }

    @Override
    public GroupShardsIterator broadcastDeleteShards(ClusterState clusterState, String index) throws IndexMissingException {
        return this.indexRoutingTable(clusterState, index).groupByShardsIt();
    }

    @Override
    public GroupShardsIterator deleteByQueryShards(ClusterState clusterState, String index, @Nullable String routing) throws IndexMissingException {
        if (routing == null) {
            return this.indexRoutingTable(clusterState, index).groupByShardsIt();
        }
        String[] routings = routingPattern.split(routing);
        if (routing.length() == 0) {
            return this.indexRoutingTable(clusterState, index).groupByShardsIt();
        }
        HashSet<ShardIterator> set = new HashSet<ShardIterator>();
        IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index);
        for (String r : routings) {
            int shardId = this.shardId(clusterState, index, null, null, r);
            IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
            if (indexShard == null) {
                throw new IndexShardMissingException(new ShardId(index, shardId));
            }
            set.add(indexShard.shardsRandomIt());
        }
        return new GroupShardsIterator(set);
    }

    @Override
    public GroupShardsIterator searchShards(ClusterState clusterState, String[] indices, @Nullable String queryHint, @Nullable String routing, @Nullable String preference) throws IndexMissingException {
        if (indices == null || indices.length == 0) {
            indices = clusterState.metaData().concreteAllIndices();
        }
        String[] routings = null;
        if (routing != null) {
            routings = routingPattern.split(routing);
        }
        if (routings != null && routings.length > 0) {
            HashSet<ShardIterator> set = new HashSet<ShardIterator>();
            for (String index : indices) {
                IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index);
                for (String r : routings) {
                    int shardId = this.shardId(clusterState, index, null, null, r);
                    IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
                    if (indexShard == null) {
                        throw new IndexShardMissingException(new ShardId(index, shardId));
                    }
                    set.add(this.preferenceShardIterator(indexShard, clusterState.nodes().localNodeId(), preference));
                }
            }
            return new GroupShardsIterator(set);
        }
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        for (String index : indices) {
            IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index);
            for (IndexShardRoutingTable indexShard : indexRouting) {
                set.add(this.preferenceShardIterator(indexShard, clusterState.nodes().localNodeId(), preference));
            }
        }
        return new GroupShardsIterator(set);
    }

    private ShardIterator preferenceShardIterator(IndexShardRoutingTable indexShard, String nodeId, @Nullable String preference) {
        if (preference == null) {
            return indexShard.shardsRandomIt();
        }
        if ("_local".equals(preference)) {
            return indexShard.preferLocalShardsIt(nodeId);
        }
        if ("_primary".equals(preference)) {
            return indexShard.primaryShardIt();
        }
        return indexShard.shardsIt(DjbHashFunction.DJB_HASH(preference));
    }

    public IndexMetaData indexMetaData(ClusterState clusterState, String index) {
        IndexMetaData indexMetaData = clusterState.metaData().index(index);
        if (indexMetaData == null) {
            throw new IndexMissingException(new Index(index));
        }
        return indexMetaData;
    }

    protected IndexRoutingTable indexRoutingTable(ClusterState clusterState, String index) {
        IndexRoutingTable indexRouting = clusterState.routingTable().index(index);
        if (indexRouting == null) {
            throw new IndexMissingException(new Index(index));
        }
        return indexRouting;
    }

    protected IndexShardRoutingTable shards(ClusterState clusterState, String index, String type, String id, String routing) {
        int shardId = this.shardId(clusterState, index, type, id, routing);
        IndexShardRoutingTable indexShard = this.indexRoutingTable(clusterState, index).shard(shardId);
        if (indexShard == null) {
            throw new IndexShardMissingException(new ShardId(index, shardId));
        }
        return indexShard;
    }

    private int shardId(ClusterState clusterState, String index, String type, @Nullable String id, @Nullable String routing) {
        if (routing == null) {
            if (!this.useType) {
                return Math.abs(this.hash(id)) % this.indexMetaData(clusterState, index).numberOfShards();
            }
            return Math.abs(this.hash(type, id)) % this.indexMetaData(clusterState, index).numberOfShards();
        }
        return Math.abs(this.hash(routing)) % this.indexMetaData(clusterState, index).numberOfShards();
    }

    protected int hash(String routing) {
        return this.hashFunction.hash(routing);
    }

    protected int hash(String type, String id) {
        return this.hashFunction.hash(type, id);
    }
}

