/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.lang.ref.SoftReference;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.elasticsearch.common.trove.ExtTDoubleObjectHashMap;
import org.elasticsearch.common.trove.ExtTHashMap;
import org.elasticsearch.common.trove.ExtTLongObjectHashMap;
import org.elasticsearch.common.trove.map.hash.TByteIntHashMap;
import org.elasticsearch.common.trove.map.hash.TDoubleIntHashMap;
import org.elasticsearch.common.trove.map.hash.TFloatIntHashMap;
import org.elasticsearch.common.trove.map.hash.TIntIntHashMap;
import org.elasticsearch.common.trove.map.hash.TLongIntHashMap;
import org.elasticsearch.common.trove.map.hash.TLongLongHashMap;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;
import org.elasticsearch.common.trove.map.hash.TShortIntHashMap;

public class CacheRecycler {
    private static ThreadLocal<SoftReference<Deque<ExtTHashMap>>> hashMap = new ThreadLocal();
    private static ThreadLocal<SoftReference<Deque<ExtTDoubleObjectHashMap>>> doubleObjectHashMap = new ThreadLocal();
    private static ThreadLocal<SoftReference<Deque<ExtTLongObjectHashMap>>> longObjectHashMap = new ThreadLocal();
    private static ThreadLocal<SoftReference<Deque<TLongLongHashMap>>> longLongHashMap = new ThreadLocal();
    private static ThreadLocal<SoftReference<Deque<TIntIntHashMap>>> intIntHashMap = new ThreadLocal();
    private static ThreadLocal<SoftReference<Deque<TFloatIntHashMap>>> floatIntHashMap = new ThreadLocal();
    private static ThreadLocal<SoftReference<Deque<TDoubleIntHashMap>>> doubleIntHashMap = new ThreadLocal();
    private static ThreadLocal<SoftReference<Deque<TByteIntHashMap>>> byteIntHashMap = new ThreadLocal();
    private static ThreadLocal<SoftReference<Deque<TShortIntHashMap>>> shortIntHashMap = new ThreadLocal();
    private static ThreadLocal<SoftReference<Deque<TLongIntHashMap>>> longIntHashMap = new ThreadLocal();
    private static ThreadLocal<SoftReference<Deque<TObjectIntHashMap>>> objectIntHashMap = new ThreadLocal();
    private static ThreadLocal<SoftReference<Deque<Object[]>>> objectArray = new ThreadLocal();
    private static ThreadLocal<SoftReference<Deque<int[]>>> intArray = new ThreadLocal();

    public static void clear() {
        doubleObjectHashMap.remove();
        longObjectHashMap.remove();
        longLongHashMap.remove();
        intIntHashMap.remove();
        floatIntHashMap.remove();
        doubleIntHashMap.remove();
        shortIntHashMap.remove();
        longIntHashMap.remove();
        objectIntHashMap.remove();
        intArray.remove();
    }

    public static <K, V> ExtTHashMap<K, V> popHashMap() {
        Deque<ExtTHashMap> deque;
        SoftReference<Deque<ExtTHashMap>> ref = hashMap.get();
        Deque<ExtTHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<ExtTHashMap>();
            hashMap.set(new SoftReference<Deque<ExtTHashMap>>(deque));
        }
        if (deque.isEmpty()) {
            return new ExtTHashMap();
        }
        ExtTHashMap map = deque.pollFirst();
        map.clear();
        return map;
    }

    public static void pushHashMap(ExtTHashMap map) {
        Deque<ExtTHashMap> deque;
        SoftReference<Deque<ExtTHashMap>> ref = hashMap.get();
        Deque<ExtTHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<ExtTHashMap>();
            hashMap.set(new SoftReference<Deque<ExtTHashMap>>(deque));
        }
        deque.add(map);
    }

    public static <T> ExtTDoubleObjectHashMap<T> popDoubleObjectMap() {
        Deque<ExtTDoubleObjectHashMap> deque;
        SoftReference<Deque<ExtTDoubleObjectHashMap>> ref = doubleObjectHashMap.get();
        Deque<ExtTDoubleObjectHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<ExtTDoubleObjectHashMap>();
            doubleObjectHashMap.set(new SoftReference<Deque<ExtTDoubleObjectHashMap>>(deque));
        }
        if (deque.isEmpty()) {
            return new ExtTDoubleObjectHashMap();
        }
        ExtTDoubleObjectHashMap map = deque.pollFirst();
        map.clear();
        return map;
    }

    public static void pushDoubleObjectMap(ExtTDoubleObjectHashMap map) {
        Deque<ExtTDoubleObjectHashMap> deque;
        SoftReference<Deque<ExtTDoubleObjectHashMap>> ref = doubleObjectHashMap.get();
        Deque<ExtTDoubleObjectHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<ExtTDoubleObjectHashMap>();
            doubleObjectHashMap.set(new SoftReference<Deque<ExtTDoubleObjectHashMap>>(deque));
        }
        deque.add(map);
    }

    public static <T> ExtTLongObjectHashMap<T> popLongObjectMap() {
        Deque<ExtTLongObjectHashMap> deque;
        SoftReference<Deque<ExtTLongObjectHashMap>> ref = longObjectHashMap.get();
        Deque<ExtTLongObjectHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<ExtTLongObjectHashMap>();
            longObjectHashMap.set(new SoftReference<Deque<ExtTLongObjectHashMap>>(deque));
        }
        if (deque.isEmpty()) {
            return new ExtTLongObjectHashMap();
        }
        ExtTLongObjectHashMap map = deque.pollFirst();
        map.clear();
        return map;
    }

    public static void pushLongObjectMap(ExtTLongObjectHashMap map) {
        Deque<ExtTLongObjectHashMap> deque;
        SoftReference<Deque<ExtTLongObjectHashMap>> ref = longObjectHashMap.get();
        Deque<ExtTLongObjectHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<ExtTLongObjectHashMap>();
            longObjectHashMap.set(new SoftReference<Deque<ExtTLongObjectHashMap>>(deque));
        }
        deque.add(map);
    }

    public static TLongLongHashMap popLongLongMap() {
        Deque<TLongLongHashMap> deque;
        SoftReference<Deque<TLongLongHashMap>> ref = longLongHashMap.get();
        Deque<TLongLongHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TLongLongHashMap>();
            longLongHashMap.set(new SoftReference<Deque<TLongLongHashMap>>(deque));
        }
        if (deque.isEmpty()) {
            return new TLongLongHashMap();
        }
        TLongLongHashMap map = deque.pollFirst();
        map.clear();
        return map;
    }

    public static void pushLongLongMap(TLongLongHashMap map) {
        Deque<TLongLongHashMap> deque;
        SoftReference<Deque<TLongLongHashMap>> ref = longLongHashMap.get();
        Deque<TLongLongHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TLongLongHashMap>();
            longLongHashMap.set(new SoftReference<Deque<TLongLongHashMap>>(deque));
        }
        deque.add(map);
    }

    public static TIntIntHashMap popIntIntMap() {
        Deque<TIntIntHashMap> deque;
        SoftReference<Deque<TIntIntHashMap>> ref = intIntHashMap.get();
        Deque<TIntIntHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TIntIntHashMap>();
            intIntHashMap.set(new SoftReference<Deque<TIntIntHashMap>>(deque));
        }
        if (deque.isEmpty()) {
            return new TIntIntHashMap();
        }
        TIntIntHashMap map = deque.pollFirst();
        map.clear();
        return map;
    }

    public static void pushIntIntMap(TIntIntHashMap map) {
        Deque<TIntIntHashMap> deque;
        SoftReference<Deque<TIntIntHashMap>> ref = intIntHashMap.get();
        Deque<TIntIntHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TIntIntHashMap>();
            intIntHashMap.set(new SoftReference<Deque<TIntIntHashMap>>(deque));
        }
        deque.add(map);
    }

    public static TFloatIntHashMap popFloatIntMap() {
        Deque<TFloatIntHashMap> deque;
        SoftReference<Deque<TFloatIntHashMap>> ref = floatIntHashMap.get();
        Deque<TFloatIntHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TFloatIntHashMap>();
            floatIntHashMap.set(new SoftReference<Deque<TFloatIntHashMap>>(deque));
        }
        if (deque.isEmpty()) {
            return new TFloatIntHashMap();
        }
        TFloatIntHashMap map = deque.pollFirst();
        map.clear();
        return map;
    }

    public static void pushFloatIntMap(TFloatIntHashMap map) {
        Deque<TFloatIntHashMap> deque;
        SoftReference<Deque<TFloatIntHashMap>> ref = floatIntHashMap.get();
        Deque<TFloatIntHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TFloatIntHashMap>();
            floatIntHashMap.set(new SoftReference<Deque<TFloatIntHashMap>>(deque));
        }
        deque.add(map);
    }

    public static TDoubleIntHashMap popDoubleIntMap() {
        Deque<TDoubleIntHashMap> deque;
        SoftReference<Deque<TDoubleIntHashMap>> ref = doubleIntHashMap.get();
        Deque<TDoubleIntHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TDoubleIntHashMap>();
            doubleIntHashMap.set(new SoftReference<Deque<TDoubleIntHashMap>>(deque));
        }
        if (deque.isEmpty()) {
            return new TDoubleIntHashMap();
        }
        TDoubleIntHashMap map = deque.pollFirst();
        map.clear();
        return map;
    }

    public static void pushDoubleIntMap(TDoubleIntHashMap map) {
        Deque<TDoubleIntHashMap> deque;
        SoftReference<Deque<TDoubleIntHashMap>> ref = doubleIntHashMap.get();
        Deque<TDoubleIntHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TDoubleIntHashMap>();
            doubleIntHashMap.set(new SoftReference<Deque<TDoubleIntHashMap>>(deque));
        }
        deque.add(map);
    }

    public static TByteIntHashMap popByteIntMap() {
        Deque<TByteIntHashMap> deque;
        SoftReference<Deque<TByteIntHashMap>> ref = byteIntHashMap.get();
        Deque<TByteIntHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TByteIntHashMap>();
            byteIntHashMap.set(new SoftReference<Deque<TByteIntHashMap>>(deque));
        }
        if (deque.isEmpty()) {
            return new TByteIntHashMap();
        }
        TByteIntHashMap map = deque.pollFirst();
        map.clear();
        return map;
    }

    public static void pushByteIntMap(TByteIntHashMap map) {
        Deque<TByteIntHashMap> deque;
        SoftReference<Deque<TByteIntHashMap>> ref = byteIntHashMap.get();
        Deque<TByteIntHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TByteIntHashMap>();
            byteIntHashMap.set(new SoftReference<Deque<TByteIntHashMap>>(deque));
        }
        deque.add(map);
    }

    public static TShortIntHashMap popShortIntMap() {
        Deque<TShortIntHashMap> deque;
        SoftReference<Deque<TShortIntHashMap>> ref = shortIntHashMap.get();
        Deque<TShortIntHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TShortIntHashMap>();
            shortIntHashMap.set(new SoftReference<Deque<TShortIntHashMap>>(deque));
        }
        if (deque.isEmpty()) {
            return new TShortIntHashMap();
        }
        TShortIntHashMap map = deque.pollFirst();
        map.clear();
        return map;
    }

    public static void pushShortIntMap(TShortIntHashMap map) {
        Deque<TShortIntHashMap> deque;
        SoftReference<Deque<TShortIntHashMap>> ref = shortIntHashMap.get();
        Deque<TShortIntHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TShortIntHashMap>();
            shortIntHashMap.set(new SoftReference<Deque<TShortIntHashMap>>(deque));
        }
        deque.add(map);
    }

    public static TLongIntHashMap popLongIntMap() {
        Deque<TLongIntHashMap> deque;
        SoftReference<Deque<TLongIntHashMap>> ref = longIntHashMap.get();
        Deque<TLongIntHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TLongIntHashMap>();
            longIntHashMap.set(new SoftReference<Deque<TLongIntHashMap>>(deque));
        }
        if (deque.isEmpty()) {
            return new TLongIntHashMap();
        }
        TLongIntHashMap map = deque.pollFirst();
        map.clear();
        return map;
    }

    public static void pushLongIntMap(TLongIntHashMap map) {
        Deque<TLongIntHashMap> deque;
        SoftReference<Deque<TLongIntHashMap>> ref = longIntHashMap.get();
        Deque<TLongIntHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TLongIntHashMap>();
            longIntHashMap.set(new SoftReference<Deque<TLongIntHashMap>>(deque));
        }
        deque.add(map);
    }

    public static <T> TObjectIntHashMap<T> popObjectIntMap() {
        Deque<TObjectIntHashMap> deque;
        SoftReference<Deque<TObjectIntHashMap>> ref = objectIntHashMap.get();
        Deque<TObjectIntHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TObjectIntHashMap>();
            objectIntHashMap.set(new SoftReference<Deque<TObjectIntHashMap>>(deque));
        }
        if (deque.isEmpty()) {
            return new TObjectIntHashMap();
        }
        TObjectIntHashMap map = deque.pollFirst();
        map.clear();
        return map;
    }

    public static <T> void pushObjectIntMap(TObjectIntHashMap<T> map) {
        Deque<TObjectIntHashMap> deque;
        SoftReference<Deque<TObjectIntHashMap>> ref = objectIntHashMap.get();
        Deque<TObjectIntHashMap> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<TObjectIntHashMap>();
            objectIntHashMap.set(new SoftReference<Deque<TObjectIntHashMap>>(deque));
        }
        deque.add(map);
    }

    public static Object[] popObjectArray(int size) {
        Deque<Object[]> deque;
        size = size < 100 ? 100 : size;
        SoftReference<Deque<Object[]>> ref = objectArray.get();
        Deque<Object[]> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<Object[]>();
            objectArray.set(new SoftReference<Deque<Object[]>>(deque));
        }
        if (deque.isEmpty()) {
            return new Object[size];
        }
        Object[] objects = deque.pollFirst();
        if (objects.length < size) {
            return new Object[size];
        }
        Arrays.fill(objects, null);
        return objects;
    }

    public static void pushObjectArray(Object[] objects) {
        Deque<Object[]> deque;
        SoftReference<Deque<Object[]>> ref = objectArray.get();
        Deque<Object[]> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<Object[]>();
            objectArray.set(new SoftReference<Deque<Object[]>>(deque));
        }
        deque.add(objects);
    }

    public static int[] popIntArray(int size) {
        return CacheRecycler.popIntArray(size, 0);
    }

    public static int[] popIntArray(int size, int sentinal) {
        Deque<int[]> deque;
        size = size < 100 ? 100 : size;
        SoftReference<Deque<int[]>> ref = intArray.get();
        Deque<int[]> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<int[]>();
            intArray.set(new SoftReference<Deque<int[]>>(deque));
        }
        if (deque.isEmpty()) {
            int[] ints = new int[size];
            if (sentinal != 0) {
                Arrays.fill(ints, sentinal);
            }
            return ints;
        }
        int[] ints = deque.pollFirst();
        if (ints.length < size) {
            ints = new int[size];
            if (sentinal != 0) {
                Arrays.fill(ints, sentinal);
            }
            return ints;
        }
        Arrays.fill(ints, sentinal);
        return ints;
    }

    public static void pushIntArray(int[] ints) {
        Deque<int[]> deque;
        SoftReference<Deque<int[]>> ref = intArray.get();
        Deque<int[]> deque2 = deque = ref == null ? null : ref.get();
        if (deque == null) {
            deque = new ArrayDeque<int[]>();
            intArray.set(new SoftReference<Deque<int[]>>(deque));
        }
        deque.add(ints);
    }
}

