/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.trove.impl.unmodifiable;

import java.io.Serializable;
import java.util.Map;
import org.elasticsearch.common.trove.TCharCollection;
import org.elasticsearch.common.trove.TCollections;
import org.elasticsearch.common.trove.function.TCharFunction;
import org.elasticsearch.common.trove.iterator.TIntCharIterator;
import org.elasticsearch.common.trove.map.TIntCharMap;
import org.elasticsearch.common.trove.procedure.TCharProcedure;
import org.elasticsearch.common.trove.procedure.TIntCharProcedure;
import org.elasticsearch.common.trove.procedure.TIntProcedure;
import org.elasticsearch.common.trove.set.TIntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TUnmodifiableIntCharMap
implements TIntCharMap,
Serializable {
    private static final long serialVersionUID = -1034234728574286014L;
    private final TIntCharMap m;
    private transient TIntSet keySet = null;
    private transient TCharCollection values = null;

    public TUnmodifiableIntCharMap(TIntCharMap m) {
        if (m == null) {
            throw new NullPointerException();
        }
        this.m = m;
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean containsKey(int key) {
        return this.m.containsKey(key);
    }

    @Override
    public boolean containsValue(char val) {
        return this.m.containsValue(val);
    }

    @Override
    public char get(int key) {
        return this.m.get(key);
    }

    @Override
    public char put(int key, char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char remove(int key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(TIntCharMap m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Character> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TIntSet keySet() {
        if (this.keySet == null) {
            this.keySet = TCollections.unmodifiableSet(this.m.keySet());
        }
        return this.keySet;
    }

    @Override
    public int[] keys() {
        return this.m.keys();
    }

    @Override
    public int[] keys(int[] array) {
        return this.m.keys(array);
    }

    @Override
    public TCharCollection valueCollection() {
        if (this.values == null) {
            this.values = TCollections.unmodifiableCollection(this.m.valueCollection());
        }
        return this.values;
    }

    @Override
    public char[] values() {
        return this.m.values();
    }

    @Override
    public char[] values(char[] array) {
        return this.m.values(array);
    }

    public boolean equals(Object o) {
        return o == this || this.m.equals(o);
    }

    public int hashCode() {
        return this.m.hashCode();
    }

    public String toString() {
        return this.m.toString();
    }

    @Override
    public int getNoEntryKey() {
        return this.m.getNoEntryKey();
    }

    @Override
    public char getNoEntryValue() {
        return this.m.getNoEntryValue();
    }

    @Override
    public boolean forEachKey(TIntProcedure procedure) {
        return this.m.forEachKey(procedure);
    }

    @Override
    public boolean forEachValue(TCharProcedure procedure) {
        return this.m.forEachValue(procedure);
    }

    @Override
    public boolean forEachEntry(TIntCharProcedure procedure) {
        return this.m.forEachEntry(procedure);
    }

    @Override
    public TIntCharIterator iterator() {
        return new TIntCharIterator(){
            TIntCharIterator iter;
            {
                this.iter = TUnmodifiableIntCharMap.this.m.iterator();
            }

            public int key() {
                return this.iter.key();
            }

            public char value() {
                return this.iter.value();
            }

            public void advance() {
                this.iter.advance();
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public char setValue(char val) {
                throw new UnsupportedOperationException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public char putIfAbsent(int key, char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transformValues(TCharFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainEntries(TIntCharProcedure procedure) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean increment(int key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean adjustValue(int key, char amount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char adjustOrPutValue(int key, char adjust_amount, char put_amount) {
        throw new UnsupportedOperationException();
    }
}

