/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

public enum XContentType {
    JSON(0){

        @Override
        public String restContentType() {
            return "application/json; charset=UTF-8";
        }
    }
    ,
    SMILE(1){

        @Override
        public String restContentType() {
            return "application/smile";
        }
    };

    private int index;

    public static XContentType fromRestContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        if ("application/json".equals(contentType) || "json".equalsIgnoreCase(contentType)) {
            return JSON;
        }
        if ("application/smile".equals(contentType) || "smile".equalsIgnoreCase(contentType)) {
            return SMILE;
        }
        return null;
    }

    private XContentType(int index) {
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public abstract String restContentType();
}

