/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.yaml.snakeyaml.serializer;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.yaml.snakeyaml.DumperOptions;
import org.elasticsearch.common.yaml.snakeyaml.emitter.Emitter;
import org.elasticsearch.common.yaml.snakeyaml.events.AliasEvent;
import org.elasticsearch.common.yaml.snakeyaml.events.DocumentEndEvent;
import org.elasticsearch.common.yaml.snakeyaml.events.DocumentStartEvent;
import org.elasticsearch.common.yaml.snakeyaml.events.ImplicitTuple;
import org.elasticsearch.common.yaml.snakeyaml.events.MappingEndEvent;
import org.elasticsearch.common.yaml.snakeyaml.events.MappingStartEvent;
import org.elasticsearch.common.yaml.snakeyaml.events.ScalarEvent;
import org.elasticsearch.common.yaml.snakeyaml.events.SequenceEndEvent;
import org.elasticsearch.common.yaml.snakeyaml.events.SequenceStartEvent;
import org.elasticsearch.common.yaml.snakeyaml.events.StreamEndEvent;
import org.elasticsearch.common.yaml.snakeyaml.events.StreamStartEvent;
import org.elasticsearch.common.yaml.snakeyaml.nodes.CollectionNode;
import org.elasticsearch.common.yaml.snakeyaml.nodes.MappingNode;
import org.elasticsearch.common.yaml.snakeyaml.nodes.Node;
import org.elasticsearch.common.yaml.snakeyaml.nodes.NodeId;
import org.elasticsearch.common.yaml.snakeyaml.nodes.NodeTuple;
import org.elasticsearch.common.yaml.snakeyaml.nodes.ScalarNode;
import org.elasticsearch.common.yaml.snakeyaml.nodes.SequenceNode;
import org.elasticsearch.common.yaml.snakeyaml.nodes.Tag;
import org.elasticsearch.common.yaml.snakeyaml.resolver.Resolver;
import org.elasticsearch.common.yaml.snakeyaml.serializer.SerializerException;

public final class Serializer {
    private final Emitter emitter;
    private final Resolver resolver;
    private boolean explicitStart;
    private boolean explicitEnd;
    private Integer[] useVersion;
    private Map<String, String> useTags;
    private Set<Node> serializedNodes;
    private Map<Node, String> anchors;
    private int lastAnchorId;
    private Boolean closed;
    private Tag explicitRoot;

    public Serializer(Emitter emitter, Resolver resolver, DumperOptions opts) {
        this.emitter = emitter;
        this.resolver = resolver;
        this.explicitStart = opts.isExplicitStart();
        this.explicitEnd = opts.isExplicitEnd();
        if (opts.getVersion() != null) {
            this.useVersion = opts.getVersion().getArray();
        }
        this.useTags = opts.getTags();
        this.serializedNodes = new HashSet<Node>();
        this.anchors = new HashMap<Node, String>();
        this.lastAnchorId = 0;
        this.closed = null;
        this.explicitRoot = opts.getExplicitRoot();
    }

    public void open() throws IOException {
        if (this.closed != null) {
            if (Boolean.TRUE.equals(this.closed)) {
                throw new SerializerException("serializer is closed");
            }
            throw new SerializerException("serializer is already opened");
        }
        this.emitter.emit(new StreamStartEvent(null, null));
        this.closed = Boolean.FALSE;
    }

    public void close() throws IOException {
        if (this.closed == null) {
            throw new SerializerException("serializer is not opened");
        }
        if (!Boolean.TRUE.equals(this.closed)) {
            this.emitter.emit(new StreamEndEvent(null, null));
            this.closed = Boolean.TRUE;
        }
    }

    public void serialize(Node node) throws IOException {
        if (this.closed == null) {
            throw new SerializerException("serializer is not opened");
        }
        if (this.closed.booleanValue()) {
            throw new SerializerException("serializer is closed");
        }
        this.emitter.emit(new DocumentStartEvent(null, null, this.explicitStart, this.useVersion, this.useTags));
        this.anchorNode(node);
        if (this.explicitRoot != null) {
            node.setTag(this.explicitRoot);
        }
        this.serializeNode(node, null, null);
        this.emitter.emit(new DocumentEndEvent(null, null, this.explicitEnd));
        this.serializedNodes.clear();
        this.anchors.clear();
        this.lastAnchorId = 0;
    }

    private void anchorNode(Node node) {
        if (this.anchors.containsKey(node)) {
            String anchor = this.anchors.get(node);
            if (null == anchor) {
                anchor = this.generateAnchor();
                this.anchors.put(node, anchor);
            }
        } else {
            this.anchors.put(node, null);
            switch (node.getNodeId()) {
                case sequence: {
                    SequenceNode seqNode = (SequenceNode)node;
                    List<Node> list = seqNode.getValue();
                    for (Node item : list) {
                        this.anchorNode(item);
                    }
                    break;
                }
                case mapping: {
                    MappingNode mnode = (MappingNode)node;
                    List<NodeTuple> map = mnode.getValue();
                    for (NodeTuple object : map) {
                        Node key = object.getKeyNode();
                        Node value = object.getValueNode();
                        this.anchorNode(key);
                        this.anchorNode(value);
                    }
                    break;
                }
            }
        }
    }

    private String generateAnchor() {
        ++this.lastAnchorId;
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumIntegerDigits(3);
        format.setGroupingUsed(false);
        String anchorId = format.format(this.lastAnchorId);
        return "id" + anchorId;
    }

    private void serializeNode(Node node, Node parent, Object index) throws IOException {
        String tAlias = this.anchors.get(node);
        if (this.serializedNodes.contains(node)) {
            this.emitter.emit(new AliasEvent(tAlias, null, null));
        } else {
            this.serializedNodes.add(node);
            switch (node.getNodeId()) {
                case scalar: {
                    ScalarNode scalarNode = (ScalarNode)node;
                    Tag detectedTag = this.resolver.resolve(NodeId.scalar, scalarNode.getValue(), true);
                    Tag defaultTag = this.resolver.resolve(NodeId.scalar, scalarNode.getValue(), false);
                    ImplicitTuple tuple = new ImplicitTuple(node.getTag().equals(detectedTag), node.getTag().equals(defaultTag));
                    ScalarEvent event = new ScalarEvent(tAlias, node.getTag().getValue(), tuple, scalarNode.getValue(), null, null, scalarNode.getStyle());
                    this.emitter.emit(event);
                    break;
                }
                case sequence: {
                    SequenceNode seqNode = (SequenceNode)node;
                    boolean implicitS = node.getTag().equals(this.resolver.resolve(NodeId.sequence, null, true));
                    this.emitter.emit(new SequenceStartEvent(tAlias, node.getTag().getValue(), implicitS, null, null, seqNode.getFlowStyle()));
                    int indexCounter = 0;
                    List<Node> list = seqNode.getValue();
                    for (Node item : list) {
                        this.serializeNode(item, node, indexCounter);
                        ++indexCounter;
                    }
                    this.emitter.emit(new SequenceEndEvent(null, null));
                    break;
                }
                default: {
                    Tag implicitTag = this.resolver.resolve(NodeId.mapping, null, true);
                    boolean implicitM = node.getTag().equals(implicitTag);
                    this.emitter.emit(new MappingStartEvent(tAlias, node.getTag().getValue(), implicitM, null, null, ((CollectionNode)node).getFlowStyle()));
                    MappingNode mnode = (MappingNode)node;
                    List<NodeTuple> map = mnode.getValue();
                    for (NodeTuple row : map) {
                        Node key = row.getKeyNode();
                        Node value = row.getValueNode();
                        this.serializeNode(key, mnode, null);
                        this.serializeNode(value, mnode, key);
                    }
                    this.emitter.emit(new MappingEndEvent(null, null));
                }
            }
        }
    }
}

