/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter.soft;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.collect.MapEvictionListener;
import org.elasticsearch.common.collect.MapMaker;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.filter.support.AbstractConcurrentMapFilterCache;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;

public class SoftFilterCache
extends AbstractConcurrentMapFilterCache
implements MapEvictionListener<Filter, DocSet> {
    private final IndexSettingsService indexSettingsService;
    private volatile int maxSize;
    private volatile TimeValue expire;
    private final AtomicLong evictions = new AtomicLong();
    private AtomicLong memEvictions;
    private final ApplySettings applySettings = new ApplySettings();

    @Inject
    public SoftFilterCache(Index index, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService) {
        super(index, indexSettings);
        this.indexSettingsService = indexSettingsService;
        this.maxSize = indexSettings.getAsInt("index.cache.filter.max_size", this.componentSettings.getAsInt("max_size", -1));
        this.expire = indexSettings.getAsTime("index.cache.filter.expire", this.componentSettings.getAsTime("expire", null));
        this.logger.debug("using [soft] filter cache with max_size [{}], expire [{}]", this.maxSize, this.expire);
        indexSettingsService.addListener(this.applySettings);
    }

    @Override
    public void close() {
        this.indexSettingsService.removeListener(this.applySettings);
        super.close();
    }

    @Override
    protected ConcurrentMap<Object, AbstractConcurrentMapFilterCache.ReaderValue> buildCache() {
        this.memEvictions = new AtomicLong();
        MapMaker mapMaker = new MapMaker().weakKeys().softValues();
        mapMaker.evictionListener(new AbstractConcurrentMapFilterCache.CacheMapEvictionListener(this.memEvictions));
        return mapMaker.makeMap();
    }

    @Override
    protected ConcurrentMap<Filter, DocSet> buildFilterMap() {
        MapMaker mapMaker = new MapMaker();
        if (this.maxSize != -1) {
            mapMaker.maximumSize(this.maxSize);
        }
        if (this.expire != null && this.expire.nanos() > 0L) {
            mapMaker.expireAfterAccess(this.expire.nanos(), TimeUnit.NANOSECONDS);
        }
        mapMaker.evictionListener(this);
        return mapMaker.makeMap();
    }

    @Override
    public String type() {
        return "soft";
    }

    @Override
    public long evictions() {
        return this.evictions.get();
    }

    @Override
    public long memEvictions() {
        return this.memEvictions.get();
    }

    @Override
    public void onEviction(Filter filter, DocSet docSet) {
        this.evictions.incrementAndGet();
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            int maxSize = settings.getAsInt("index.cache.filter.max_size", SoftFilterCache.this.maxSize);
            TimeValue expire = settings.getAsTime("index.cache.filter.expire", SoftFilterCache.this.expire);
            boolean changed = false;
            if (maxSize != SoftFilterCache.this.maxSize) {
                SoftFilterCache.this.logger.info("updating index.cache.filter.max_size from [{}] to [{}]", SoftFilterCache.this.maxSize, maxSize);
                changed = true;
                SoftFilterCache.this.maxSize = maxSize;
            }
            if (!Objects.equal(expire, SoftFilterCache.this.expire)) {
                SoftFilterCache.this.logger.info("updating index.cache.filter.expire from [{}] to [{}]", SoftFilterCache.this.expire, expire);
                changed = true;
                SoftFilterCache.this.expire = expire;
            }
            if (changed) {
                SoftFilterCache.this.clear();
            }
        }
    }
}

