/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseQueryBuilder;
import org.elasticsearch.index.query.xcontent.XContentFilterBuilder;
import org.elasticsearch.index.query.xcontent.XContentQueryBuilder;

public class FilteredQueryBuilder
extends BaseQueryBuilder {
    private final XContentQueryBuilder queryBuilder;
    private final XContentFilterBuilder filterBuilder;
    private float boost = -1.0f;

    public FilteredQueryBuilder(XContentQueryBuilder queryBuilder, XContentFilterBuilder filterBuilder) {
        this.queryBuilder = queryBuilder;
        this.filterBuilder = filterBuilder;
    }

    public FilteredQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("filtered");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params);
        builder.field("filter");
        this.filterBuilder.toXContent(builder, params);
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

