/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.ping.broadcast;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.ping.broadcast.BroadcastPingRequest;
import org.elasticsearch.action.admin.cluster.ping.broadcast.BroadcastPingResponse;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestBroadcastPingAction
extends BaseRestHandler {
    @Inject
    public RestBroadcastPingAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_ping/broadcast", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/{index}/_ping/broadcast", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        BroadcastPingRequest broadcastPingRequest = new BroadcastPingRequest(RestActions.splitIndices(request.param("index")));
        broadcastPingRequest.queryHint(request.param("query_hint"));
        BroadcastOperationThreading operationThreading = BroadcastOperationThreading.fromString(request.param("operation_threading"), BroadcastOperationThreading.SINGLE_THREAD);
        if (operationThreading == BroadcastOperationThreading.NO_THREADS) {
            operationThreading = BroadcastOperationThreading.SINGLE_THREAD;
        }
        broadcastPingRequest.operationThreading(operationThreading);
        this.client.admin().cluster().ping(broadcastPingRequest, new ActionListener<BroadcastPingResponse>(){

            @Override
            public void onResponse(BroadcastPingResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field("ok", true);
                    RestActions.buildBroadcastShardsHeader(builder, response);
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestBroadcastPingAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

