/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.support;

import java.io.IOException;
import org.elasticsearch.common.compress.lzf.LZF;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.LZFStreamInput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestRequest;

public class RestXContentBuilder {
    public static XContentBuilder restContentBuilder(RestRequest request) throws IOException {
        String casing;
        XContentType contentType = XContentType.fromRestContentType(request.header("Content-Type"));
        if (contentType == null && request.hasContent()) {
            contentType = XContentFactory.xContentType(request.contentByteArray(), request.contentByteArrayOffset(), request.contentLength());
        }
        if (contentType == null) {
            contentType = XContentType.JSON;
        }
        XContentBuilder builder = XContentFactory.contentBuilder(contentType);
        if (request.paramAsBoolean("pretty", false)) {
            builder.prettyPrint();
        }
        if ((casing = request.param("case")) != null && "camelCase".equals(casing)) {
            builder.fieldCaseConversion(XContentBuilder.FieldCaseConversion.CAMELCASE);
        } else {
            builder.fieldCaseConversion(XContentBuilder.FieldCaseConversion.NONE);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restDocumentSource(byte[] source, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (LZF.isCompressed(source)) {
            BytesStreamInput siBytes = new BytesStreamInput(source);
            LZFStreamInput siLzf = CachedStreamInput.cachedLzf(siBytes);
            XContentType contentType = XContentFactory.xContentType(siLzf);
            siLzf.resetToBufferStart();
            if (contentType == builder.contentType()) {
                builder.rawField("_source", siLzf);
            } else {
                XContentParser parser = XContentFactory.xContent(contentType).createParser(siLzf);
                try {
                    parser.nextToken();
                    builder.field("_source");
                    builder.copyCurrentStructure(parser);
                }
                finally {
                    parser.close();
                }
            }
        } else {
            XContentType contentType = XContentFactory.xContentType(source);
            if (contentType == builder.contentType()) {
                builder.rawField("_source", source);
            } else {
                XContentParser parser = XContentFactory.xContent(contentType).createParser(source);
                try {
                    parser.nextToken();
                    builder.field("_source");
                    builder.copyCurrentStructure(parser);
                }
                finally {
                    parser.close();
                }
            }
        }
    }
}

