/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.dosgi.tcp;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.fusesource.fabric.dosgi.io.ProtocolCodec;
import org.fusesource.fabric.dosgi.io.Service;
import org.fusesource.fabric.dosgi.io.Transport;
import org.fusesource.fabric.dosgi.io.TransportListener;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransportPool
implements Service {
    protected static final Logger LOGGER = LoggerFactory.getLogger(TransportPool.class);
    public static final int DEFAULT_POOL_SIZE = 2;
    public static final long DEFAULT_EVICTION_DELAY = TimeUnit.MINUTES.toMillis(5L);
    protected final String uri;
    protected final DispatchQueue queue;
    protected final LinkedList<Object> pending = new LinkedList();
    protected final Map<Transport, Long> transports = new HashMap<Transport, Long>();
    protected AtomicBoolean running = new AtomicBoolean(false);
    protected int poolSize;
    protected long evictionDelay;

    public TransportPool(String uri, DispatchQueue queue) {
        this(uri, queue, 2, DEFAULT_EVICTION_DELAY);
    }

    public TransportPool(String uri, DispatchQueue queue, int poolSize, long evictionDelay) {
        this.uri = uri;
        this.queue = queue;
        this.poolSize = poolSize;
        this.evictionDelay = evictionDelay;
    }

    protected abstract Transport createTransport(String var1) throws Exception;

    protected abstract ProtocolCodec createCodec();

    protected abstract void onCommand(Object var1);

    public void offer(final Object data) {
        if (!this.running.get()) {
            throw new IllegalStateException("Transport pool stopped");
        }
        this.queue.execute(new Runnable(){

            @Override
            public void run() {
                Transport transport = TransportPool.this.getIdleTransport();
                if (transport != null) {
                    transport.offer(data);
                    if (transport.full()) {
                        TransportPool.this.transports.put(transport, 0L);
                    }
                } else {
                    TransportPool.this.pending.add(data);
                }
            }
        });
    }

    protected Transport getIdleTransport() {
        for (Map.Entry<Transport, Long> entry : this.transports.entrySet()) {
            if (entry.getValue() <= 0L) continue;
            return entry.getKey();
        }
        if (this.transports.size() < this.poolSize) {
            try {
                this.startNewTransport();
            }
            catch (Exception e) {
                LOGGER.info("Unable to start new transport", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void start() throws Exception {
        this.start(null);
    }

    @Override
    public void start(Runnable onComplete) throws Exception {
        this.running.set(true);
    }

    @Override
    public void stop() {
        this.stop(null);
    }

    @Override
    public void stop(final Runnable onComplete) {
        if (this.running.compareAndSet(true, false)) {
            this.queue.execute(new Runnable(){

                @Override
                public void run() {
                    final AtomicInteger latch = new AtomicInteger(TransportPool.this.transports.size());
                    Runnable coutDown = new Runnable(){

                        @Override
                        public void run() {
                            if (latch.decrementAndGet() == 0) {
                                TransportPool.this.pending.clear();
                                onComplete.run();
                            }
                        }
                    };
                    for (Transport transport : TransportPool.this.transports.keySet()) {
                        transport.stop(coutDown);
                    }
                }
            });
        } else {
            onComplete.run();
        }
    }

    protected void startNewTransport() throws Exception {
        System.err.println("Creating new transport for: " + this.uri);
        Transport transport = this.createTransport(this.uri);
        transport.setDispatchQueue(this.queue);
        transport.setProtocolCodec(this.createCodec());
        transport.setTransportListener(new Listener());
        this.transports.put(transport, 0L);
        transport.start();
    }

    protected class Listener
    implements TransportListener {
        protected Listener() {
        }

        @Override
        public void onTransportCommand(Transport transport, Object command) {
            TransportPool.this.onCommand(command);
        }

        @Override
        public void onRefill(final Transport transport) {
            while (TransportPool.this.pending.size() > 0 && !transport.full()) {
                boolean accepted = transport.offer(TransportPool.this.pending.removeFirst());
                assert (accepted) : "Should have been accepted since the transport was not full";
            }
            if (transport.full()) {
                TransportPool.this.transports.put(transport, 0L);
            } else {
                final long time = System.currentTimeMillis();
                TransportPool.this.transports.put(transport, time);
                if (TransportPool.this.evictionDelay > 0L) {
                    TransportPool.this.queue.executeAfter(TransportPool.this.evictionDelay, TimeUnit.MILLISECONDS, new Runnable(){

                        @Override
                        public void run() {
                            if (TransportPool.this.transports.get(transport) == time) {
                                TransportPool.this.transports.remove(transport);
                                transport.stop();
                            }
                        }
                    });
                }
            }
        }

        @Override
        public void onTransportFailure(Transport transport, IOException error) {
            if (!transport.isDisposed()) {
                LOGGER.info("Transport failure", (Throwable)error);
                TransportPool.this.transports.remove(transport);
                transport.stop();
            }
        }

        @Override
        public void onTransportConnected(Transport transport) {
            transport.resumeRead();
            this.onRefill(transport);
        }

        @Override
        public void onTransportDisconnected(Transport transport) {
            TransportPool.this.transports.remove(transport);
        }
    }
}

