/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.properties.Properties;
import org.apache.felix.utils.version.VersionCleaner;
import org.apache.felix.utils.version.VersionRange;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.internal.FeatureValidationUtil;
import org.apache.karaf.features.internal.RepositoryImpl;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.fusesource.fabric.agent.ObrResolver;
import org.fusesource.fabric.agent.download.DownloadFuture;
import org.fusesource.fabric.agent.download.DownloadManager;
import org.fusesource.fabric.agent.download.FutureListener;
import org.fusesource.fabric.agent.mvn.DictionaryPropertyResolver;
import org.fusesource.fabric.agent.mvn.MavenConfigurationImpl;
import org.fusesource.fabric.agent.mvn.MavenSettingsImpl;
import org.fusesource.fabric.agent.mvn.PropertiesPropertyResolver;
import org.fusesource.fabric.agent.utils.MultiException;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.linkedin.zookeeper.client.IZKClient;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentAgent
implements ManagedService,
FrameworkListener {
    private static final String DEFAULT_VERSION = "0.0.0";
    private static final String FABRIC_ZOOKEEPER_PID = "fabric.zookeeper.id";
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentAgent.class);
    private BundleContext bundleContext;
    private PackageAdmin packageAdmin;
    private StartLevel startLevel;
    private ObrResolver obrResolver;
    private Callable<IZKClient> zkClient;
    private final Object refreshLock = new Object();
    private long refreshTimeout = 5000L;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private DownloadManager manager;

    public DeploymentAgent() throws MalformedURLException {
        MavenConfigurationImpl config = new MavenConfigurationImpl(new PropertiesPropertyResolver(System.getProperties()), "org.ops4j.pax.url.mvn");
        config.setSettings(new MavenSettingsImpl(config.getSettingsFileUrl(), config.useFallbackRepositories()));
        this.manager = new DownloadManager(config);
    }

    public StartLevel getStartLevel() {
        return this.startLevel;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public PackageAdmin getPackageAdmin() {
        return this.packageAdmin;
    }

    public ObrResolver getObrResolver() {
        return this.obrResolver;
    }

    public Callable<IZKClient> getZkClient() {
        return this.zkClient;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    public void setStartLevel(StartLevel startLevel) {
        this.startLevel = startLevel;
    }

    public void setObrResolver(ObrResolver obrResolver) {
        this.obrResolver = obrResolver;
    }

    public void setZkClient(Callable<IZKClient> zkClient) {
        this.zkClient = zkClient;
    }

    public void start() {
        this.loadState();
        this.bundleContext.addFrameworkListener((FrameworkListener)this);
    }

    public void stop() {
        this.bundleContext.removeFrameworkListener((FrameworkListener)this);
        this.manager.shutdown();
        this.executor.shutdown();
    }

    public void loadState() {
    }

    public void saveState() {
    }

    public void updated(final Dictionary props) throws ConfigurationException {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                Exception result = null;
                try {
                    DeploymentAgent.this.doUpdate(props);
                }
                catch (Exception e) {
                    result = e;
                    LOGGER.error("Unable to update agent", (Throwable)e);
                }
                try {
                    IZKClient zk = (IZKClient)DeploymentAgent.this.zkClient.call();
                    if (zk != null) {
                        String e;
                        String r;
                        String name = System.getProperty("karaf.name");
                        if (result == null) {
                            r = "success";
                            e = null;
                        } else {
                            StringWriter sw = new StringWriter();
                            result.printStackTrace(new PrintWriter(sw));
                            r = "error";
                            e = sw.toString();
                        }
                        zk.createOrSetWithParents(ZkPath.AGENT_PROVISION_RESULT.getPath(new String[]{name}), r, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                        zk.createOrSetWithParents(ZkPath.AGENT_PROVISION_EXCEPTION.getPath(new String[]{name}), e, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    } else {
                        LOGGER.info("ZooKeeper not available");
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Unable to set provisioning result");
                }
            }
        });
    }

    public void doUpdate(Dictionary props) throws Exception {
        if (props == null) {
            return;
        }
        MavenConfigurationImpl config = new MavenConfigurationImpl(new DictionaryPropertyResolver(props, new PropertiesPropertyResolver(System.getProperties())), "org.ops4j.pax.url.mvn");
        config.setSettings(new MavenSettingsImpl(config.getSettingsFileUrl(), config.useFallbackRepositories()));
        this.manager = new DownloadManager(config);
        HashMap<String, String> properties = new HashMap<String, String>();
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = props.get(key);
            if ("service.pid".equals(key) || FABRIC_ZOOKEEPER_PID.equals(key)) continue;
            properties.put(key.toString(), val.toString());
        }
        boolean restart = false;
        Properties configProps = new Properties(new File(System.getProperty("karaf.base") + File.separator + "etc" + File.separator + "config.properties"));
        Properties systemProps = new Properties(new File(System.getProperty("karaf.base") + File.separator + "etc" + File.separator + "system.properties"));
        for (String key : properties.keySet()) {
            String v;
            String k;
            if (key.equals("framework")) {
                String url = (String)properties.get(key);
                restart |= this.updateFramework(configProps, url);
                continue;
            }
            if (key.startsWith("config.")) {
                k = key.substring("config.".length());
                v = (String)properties.get(key);
                if (v.equals(configProps.get(k))) continue;
                configProps.put(k, v);
                restart = true;
                continue;
            }
            if (!key.startsWith("system.")) continue;
            k = key.substring("system.".length());
            v = (String)properties.get(key);
            if (v.equals(systemProps.get(k))) continue;
            systemProps.put(k, v);
            restart = true;
        }
        if (restart) {
            configProps.save();
            systemProps.save();
            System.setProperty("karaf.restart", "true");
            this.bundleContext.getBundle(0L).stop();
            return;
        }
        HashMap<URI, Repository> repositories = new HashMap<URI, Repository>();
        for (String key : properties.keySet()) {
            if (!key.startsWith("repository.")) continue;
            String url = (String)properties.get(key);
            if (url == null || url.length() == 0) {
                url = key.substring("repository.".length());
            }
            if (url == null || url.length() <= 0) continue;
            URI uri = URI.create(url);
            this.addRepository(repositories, uri);
        }
        HashSet<Feature> features = new HashSet<Feature>();
        for (String key : properties.keySet()) {
            Feature feature;
            if (!key.startsWith("feature.")) continue;
            String name = (String)properties.get(key);
            if (name == null || name.length() == 0) {
                name = key.substring("feature.".length());
            }
            if ((feature = this.search(name, repositories.values())) == null) {
                throw new IllegalArgumentException("Unable to find feature " + name);
            }
            features.add(feature);
        }
        HashSet<String> bundles = new HashSet<String>();
        for (String key : properties.keySet()) {
            if (!key.startsWith("bundle.")) continue;
            String url = (String)properties.get(key);
            if (url == null || url.length() == 0) {
                url = key.substring("bundle.".length());
            }
            if (url == null || url.length() <= 0) continue;
            bundles.add(url);
        }
        this.updateDeployment(repositories, features, bundles);
    }

    private void addRepository(Map<URI, Repository> repositories, URI uri) throws Exception {
        if (!repositories.containsKey(uri)) {
            this.manager.download(uri.toString()).getFile();
            FeatureValidationUtil.validate(uri);
            RepositoryImpl repo = new RepositoryImpl(uri);
            repositories.put(uri, repo);
            repo.load();
            for (URI ref : repo.getRepositories()) {
                this.addRepository(repositories, ref);
            }
        }
    }

    private Feature search(String key, Collection<Repository> repositories) {
        String[] split = key.split("/");
        String name = split[0].trim();
        String version = null;
        if (split.length == 2) {
            version = split[1].trim();
        }
        if (version == null || version.length() == 0) {
            version = DEFAULT_VERSION;
        }
        return this.search(name, version, repositories);
    }

    private Feature search(String name, String version, Collection<Repository> repositories) {
        VersionRange range = new VersionRange(version, false, true);
        Feature bestFeature = null;
        Version bestVersion = null;
        for (Repository repo : repositories) {
            Feature[] features;
            try {
                features = repo.getFeatures();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            for (Feature feature : features) {
                Version v;
                if (!name.equals(feature.getName()) || !range.contains(v = new Version(VersionCleaner.clean(feature.getVersion()))) || bestVersion != null && bestVersion.compareTo((Object)v) >= 0) continue;
                bestFeature = feature;
                bestVersion = v;
            }
        }
        return bestFeature;
    }

    private Set<Feature> addFeatures(Collection<Feature> features, Collection<Repository> repositories) {
        HashSet<Feature> set = new HashSet<Feature>();
        for (Feature feature : features) {
            this.addFeatures(set, feature, repositories);
        }
        return set;
    }

    private Set<Feature> addFeatures(Set<Feature> set, Feature feature, Collection<Repository> repositories) {
        set.add(feature);
        for (Feature dep : feature.getDependencies()) {
            Feature f = this.search(dep.getName(), dep.getVersion(), repositories);
            if (f == null) {
                throw new IllegalArgumentException("Unable to find feature " + dep.getName() + "/" + dep.getVersion());
            }
            this.addFeatures(set, f, repositories);
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private void updateDeployment(Map<URI, Repository> repositories, Set<Feature> features, Set<String> bundles) throws Exception {
        Bundle bundle;
        Resource resource;
        void var15_25;
        Set<Feature> allFeatures = this.addFeatures(features, repositories.values());
        Map<String, File> downloads = this.downloadBundles(allFeatures, bundles);
        List<Resource> allResources = this.getObrResolver().resolve(allFeatures, bundles);
        HashMap<Resource, Bundle> resToBnd = new HashMap<Resource, Bundle>();
        StringBuilder sb = new StringBuilder();
        sb.append("Configuration changed.  New bundles list:\n");
        for (Resource bundle2 : allResources) {
            sb.append("  ").append(bundle2.getURI()).append("\n");
        }
        LOGGER.info(sb.toString());
        ArrayList<Resource> toDeploy = new ArrayList<Resource>(allResources);
        ArrayList<Resource> toInstall = new ArrayList<Resource>();
        ArrayList<Bundle> toDelete = new ArrayList<Bundle>();
        HashMap<Bundle, Resource> toUpdate = new HashMap<Bundle, Resource>();
        Bundle[] arr$ = this.bundleContext.getBundles();
        int n = arr$.length;
        boolean bl = false;
        while (var15_25 < n) {
            Bundle bundle3 = arr$[var15_25];
            if (bundle3.getBundleId() != 0L) {
                resource = null;
                for (Resource res : toDeploy) {
                    if (!res.getSymbolicName().equals(bundle3.getSymbolicName()) || !res.getVersion().equals((Object)bundle3.getVersion())) continue;
                    resource = res;
                    break;
                }
                if (resource != null) {
                    toDeploy.remove(resource);
                    resToBnd.put(resource, bundle3);
                } else {
                    toDelete.add(bundle3);
                }
            }
            ++var15_25;
        }
        for (Resource resource2 : toDeploy) {
            TreeMap<Version, Bundle> treeMap = new TreeMap<Version, Bundle>();
            VersionRange range = this.getMicroVersionRange(resource2.getVersion());
            for (Bundle bundle4 : toDelete) {
                if (!bundle4.getSymbolicName().equals(resource2.getSymbolicName()) || !range.contains(bundle4.getVersion())) continue;
                treeMap.put(bundle4.getVersion(), bundle4);
            }
            if (!treeMap.isEmpty()) {
                bundle = (Bundle)treeMap.lastEntry().getValue();
                toUpdate.put(bundle, resource2);
                toDelete.remove(bundle);
                resToBnd.put(resource2, bundle);
                continue;
            }
            toInstall.add(resource2);
        }
        LOGGER.info("Changes to perform:");
        LOGGER.info("  Bundles to uninstall:");
        for (Bundle bundle2 : toDelete) {
            LOGGER.info("    " + bundle2.getSymbolicName() + " / " + bundle2.getVersion());
        }
        LOGGER.info("  Bundles to update:");
        for (Map.Entry entry : toUpdate.entrySet()) {
            LOGGER.info("    " + ((Bundle)entry.getKey()).getSymbolicName() + " / " + ((Bundle)entry.getKey()).getVersion() + " with " + ((Resource)entry.getValue()).getURI());
        }
        LOGGER.info("  Bundles to install:");
        for (Resource resource3 : toInstall) {
            LOGGER.info("    " + resource3.getURI());
        }
        HashSet<Bundle> toRefresh = new HashSet<Bundle>();
        for (Bundle bundle3 : toDelete) {
            bundle3.uninstall();
            toRefresh.add(bundle3);
        }
        for (Map.Entry entry : toUpdate.entrySet()) {
            InputStream is;
            Bundle bundle4 = (Bundle)entry.getKey();
            resource = (Resource)entry.getValue();
            File file = downloads.get(resource.getURI());
            if (file != null) {
                is = new FileInputStream(file);
            } else {
                LOGGER.warn("Bundle " + resource.getURI() + " not found in the downloads, using direct input stream instead");
                is = new URL(resource.getURI()).openStream();
            }
            bundle4.stop(1);
            bundle4.update(is);
            toRefresh.add(bundle4);
        }
        for (Resource resource4 : toInstall) {
            InputStream is;
            File file = downloads.get(resource4.getURI());
            if (file != null) {
                is = new FileInputStream(file);
            } else {
                LOGGER.warn("Bundle " + resource4.getURI() + " not found in the downloads, using direct input stream instead");
                is = new URL(resource4.getURI()).openStream();
            }
            Bundle bundle5 = this.bundleContext.installBundle(resource4.getURI(), is);
            toRefresh.add(bundle5);
            resToBnd.put(resource4, bundle5);
        }
        this.findBundlesWithOptionalPackagesToRefresh(toRefresh);
        this.findBundlesWithFramentsToRefresh(toRefresh);
        LOGGER.info("Refreshing bundles:");
        for (Bundle bundle6 : toRefresh) {
            LOGGER.info("  " + bundle6.getSymbolicName() + " / " + bundle6.getVersion());
        }
        if (!toRefresh.isEmpty()) {
            this.refreshPackages(toRefresh.toArray(new Bundle[toRefresh.size()]));
        }
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        LOGGER.info("Starting bundles:");
        for (Resource resource5 : allResources) {
            bundle = (Bundle)resToBnd.get(resource5);
            String hostHeader = (String)bundle.getHeaders().get("Fragment-Host");
            if (hostHeader != null) continue;
            LOGGER.info("  " + bundle.getSymbolicName() + " / " + bundle.getVersion());
            try {
                bundle.start();
            }
            catch (BundleException e) {
                arrayList.add(e);
            }
        }
        if (!arrayList.isEmpty()) {
            throw new MultiException("Error updating agent", arrayList);
        }
        LOGGER.info("Done.");
    }

    private VersionRange getMicroVersionRange(Version version) {
        Version floor = new Version(version.getMajor(), version.getMinor(), 0);
        Version ceil = new Version(version.getMajor(), version.getMinor() + 1, 0);
        return new VersionRange(false, floor, ceil, true);
    }

    protected void findBundlesWithFramentsToRefresh(Set<Bundle> toRefresh) {
        for (Bundle b : toRefresh) {
            Clause[] clauses;
            String hostHeader;
            if (b.getState() == 1 || (hostHeader = (String)b.getHeaders().get("Fragment-Host")) == null || (clauses = Parser.parseHeader(hostHeader)) == null || clauses.length <= 0) continue;
            Clause path = clauses[0];
            for (Bundle hostBundle : this.bundleContext.getBundles()) {
                if (!hostBundle.getSymbolicName().equals(path.getName())) continue;
                String ver = path.getAttribute("bundle-version");
                if (ver != null) {
                    VersionRange v = VersionRange.parseVersionRange(ver);
                    if (!v.contains(hostBundle.getVersion())) continue;
                    toRefresh.add(hostBundle);
                    continue;
                }
                toRefresh.add(hostBundle);
            }
        }
    }

    protected void findBundlesWithOptionalPackagesToRefresh(Set<Bundle> toRefresh) {
        List importsList;
        HashSet<Bundle> bundles = new HashSet<Bundle>(Arrays.asList(this.bundleContext.getBundles()));
        bundles.removeAll(toRefresh);
        if (bundles.isEmpty()) {
            return;
        }
        HashMap<Bundle, List> imports = new HashMap<Bundle, List>();
        Iterator it = bundles.iterator();
        while (it.hasNext()) {
            Bundle b = (Bundle)it.next();
            String importsStr = (String)b.getHeaders().get("Import-Package");
            importsList = this.getOptionalImports(importsStr);
            if (importsList.isEmpty()) {
                it.remove();
                continue;
            }
            imports.put(b, importsList);
        }
        if (bundles.isEmpty()) {
            return;
        }
        ArrayList<Clause> exports = new ArrayList<Clause>();
        for (Bundle b : toRefresh) {
            String exportsStr;
            if (b.getState() == 1 || (exportsStr = (String)b.getHeaders().get("Export-Package")) == null) continue;
            Clause[] exportsList = Parser.parseHeader(exportsStr);
            exports.addAll(Arrays.asList(exportsList));
        }
        Iterator it2 = bundles.iterator();
        while (it2.hasNext()) {
            Bundle b;
            b = (Bundle)it2.next();
            importsList = (List)imports.get(b);
            Iterator itpi = importsList.iterator();
            while (itpi.hasNext()) {
                Clause pi = (Clause)itpi.next();
                boolean matching = false;
                for (Clause pe : exports) {
                    Version exported;
                    if (!pi.getName().equals(pe.getName())) continue;
                    String evStr = pe.getAttribute("version");
                    String ivStr = pi.getAttribute("version");
                    VersionRange imported = ivStr != null ? VersionRange.parseVersionRange(ivStr) : VersionRange.ANY_VERSION;
                    if (!imported.contains(exported = evStr != null ? Version.parseVersion((String)evStr) : Version.emptyVersion)) continue;
                    matching = true;
                    break;
                }
                if (matching) continue;
                itpi.remove();
            }
            if (!importsList.isEmpty()) continue;
            it2.remove();
        }
        toRefresh.addAll(bundles);
    }

    protected List<Clause> getOptionalImports(String importsStr) {
        Clause[] imports = Parser.parseHeader(importsStr);
        LinkedList<Clause> result = new LinkedList<Clause>();
        for (int i = 0; i < imports.length; ++i) {
            String resolution = imports[i].getDirective("resolution");
            if (!"optional".equals(resolution)) continue;
            result.add(imports[i]);
        }
        return result;
    }

    protected boolean updateFramework(Properties properties, String url) throws Exception {
        if (!url.startsWith("mvn:")) {
            throw new IllegalArgumentException("Framework url must use the mvn: protocol");
        }
        File file = ((DownloadFuture)this.manager.download(url).await()).getFile();
        String path = file.getPath();
        if (path.startsWith(System.getProperty("karaf.home"))) {
            path = path.substring(System.getProperty("karaf.home").length() + 1);
        }
        if (!path.equals(properties.get("karaf.framework.felix"))) {
            properties.put("karaf.framework", "felix");
            properties.put("karaf.framework.felix", path);
            return true;
        }
        return false;
    }

    protected Map<String, File> downloadBundles(Set<Feature> features, Set<String> bundles) throws Exception {
        HashSet<String> locations = new HashSet<String>();
        for (Feature feature : features) {
            for (BundleInfo bundle : feature.getBundles()) {
                locations.add(bundle.getLocation());
            }
        }
        for (String bundle : bundles) {
            locations.add(bundle);
        }
        final CountDownLatch latch = new CountDownLatch(locations.size());
        final ConcurrentHashMap<String, File> downloads = new ConcurrentHashMap<String, File>();
        final CopyOnWriteArrayList<Throwable> errors = new CopyOnWriteArrayList<Throwable>();
        for (final String location : locations) {
            this.manager.download(location).addListener(new FutureListener<DownloadFuture>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void operationComplete(DownloadFuture future) {
                    try {
                        downloads.put(location, future.getFile());
                    }
                    catch (IOException e) {
                        errors.add(e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        latch.await();
        if (!errors.isEmpty()) {
            throw new MultiException("Error while downloading bundles", errors);
        }
        return downloads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 4) {
            Object object = this.refreshLock;
            synchronized (object) {
                this.refreshLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshPackages(Bundle[] bundles) throws InterruptedException {
        if (this.getPackageAdmin() != null) {
            Object object = this.refreshLock;
            synchronized (object) {
                this.getPackageAdmin().refreshPackages(bundles);
                this.refreshLock.wait(this.refreshTimeout);
            }
        }
    }
}

