/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.fabric.camel.FabricComponent;
import org.fusesource.fabric.groups.Group;

public class FabricPublisherEndpoint
extends DefaultEndpoint {
    private static final transient Log LOG = LogFactory.getLog(FabricPublisherEndpoint.class);
    private final FabricComponent component;
    private final Group group;
    private final String child;

    public FabricPublisherEndpoint(String uri, FabricComponent component, Group group, String child) {
        super(uri, (Component)component);
        this.component = component;
        this.group = group;
        this.child = child;
    }

    public Producer createProducer() throws Exception {
        return this.getCamelContext().getEndpoint(this.child).createProducer();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return this.getCamelContext().getEndpoint(this.child).createConsumer(processor);
    }

    public boolean isSingleton() {
        return true;
    }

    public void start() throws Exception {
        super.start();
        this.group.join(this.child.getBytes("UTF-8"));
    }

    public void stop() throws Exception {
        this.group.close();
        super.stop();
    }

    public FabricComponent getComponent() {
        return this.component;
    }

    public String getChild() {
        return this.child;
    }
}

