/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel;

import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.SuspendableService;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ServiceHelper;
import org.fusesource.fabric.camel.MasterEndpoint;
import org.fusesource.fabric.groups.ChangeListener;
import org.fusesource.fabric.groups.ClusteredSingleton;
import org.fusesource.fabric.groups.NodeState;
import org.fusesource.fabric.groups.TextNodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterConsumer
extends DefaultConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(MasterConsumer.class);
    private final MasterEndpoint endpoint;
    private final Processor processor;
    private Consumer delegate;
    private SuspendableService delegateService;

    public MasterConsumer(MasterEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.processor = processor;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.tryAcquireLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        try {
            this.stopConsumer();
        }
        finally {
            this.releaseLock();
        }
    }

    protected void stopConsumer() throws Exception {
        ServiceHelper.stopService((Object)this.delegate);
        this.delegate = null;
        this.delegateService = null;
    }

    protected void doResume() throws Exception {
        if (this.delegateService != null) {
            this.delegateService.resume();
        }
        super.doResume();
    }

    protected void doSuspend() throws Exception {
        if (this.delegateService != null) {
            this.delegateService.suspend();
        }
        super.doSuspend();
    }

    protected void onLockOwned() {
        if (this.delegate == null) {
            try {
                this.delegate = this.endpoint.getChildEndpoint().createConsumer(this.processor);
                this.delegateService = null;
                if (this.delegate instanceof SuspendableService) {
                    this.delegateService = (SuspendableService)this.delegate;
                }
                ServiceHelper.startService((Object)this.delegate);
            }
            catch (Exception e) {
                LOG.error("Failed to start master consumer for: " + (Object)((Object)this.endpoint) + ". Reason: " + e, (Throwable)e);
            }
        }
    }

    protected void tryAcquireLock() {
        final ClusteredSingleton<TextNodeState> cluster = this.getCluster();
        TextNodeState state = new TextNodeState();
        String singletonId = this.endpoint.getSingletonId();
        LOG.debug("Attempting to become master for endpoint: " + (Object)((Object)this.endpoint) + " in " + this.endpoint.getCamelContext() + " with singletonID: " + singletonId);
        state.setId(singletonId);
        cluster.join((NodeState)state);
        cluster.add(new ChangeListener(){

            public void connected() {
            }

            public void changed() {
                if (cluster.connected()) {
                    if (cluster.isMaster()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Master/Standby endpoint is Master for:  " + (Object)((Object)MasterConsumer.this.endpoint) + " in " + MasterConsumer.this.endpoint.getCamelContext());
                        }
                        MasterConsumer.this.onLockOwned();
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Master/Standby endpoint is Standby for: " + (Object)((Object)MasterConsumer.this.endpoint) + " in " + MasterConsumer.this.endpoint.getCamelContext());
                    }
                }
            }

            public void disconnected() {
                try {
                    MasterConsumer.this.stopConsumer();
                }
                catch (Exception e) {
                    LOG.error("Failed to stop master consumer for: " + (Object)((Object)MasterConsumer.this.endpoint) + ". Reason: " + e, (Throwable)e);
                }
            }
        });
    }

    protected ClusteredSingleton<TextNodeState> getCluster() {
        return this.endpoint.getCluster();
    }

    protected void releaseLock() {
        this.getCluster().leave();
    }
}

