/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.fabric.camel.MasterComponent;
import org.fusesource.fabric.camel.MasterConsumer;
import org.fusesource.fabric.groups.ClusteredSingleton;
import org.fusesource.fabric.groups.Group;
import org.fusesource.fabric.groups.TextNodeState;

public class MasterEndpoint
extends DefaultEndpoint {
    private static final transient Log LOG = LogFactory.getLog(MasterEndpoint.class);
    private final MasterComponent component;
    private final String singletonId;
    private final Group group;
    private final String child;
    private ClusteredSingleton<TextNodeState> cluster;

    public MasterEndpoint(String uri, MasterComponent component, String singletonId, Group group, String child) {
        super(uri, (Component)component);
        this.component = component;
        this.singletonId = singletonId;
        this.group = group;
        this.child = child;
        this.cluster = new ClusteredSingleton(TextNodeState.class);
    }

    public Producer createProducer() throws Exception {
        return this.getChildEndpoint().createProducer();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new MasterConsumer(this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStop() throws Exception {
        this.getCluster().stop();
        super.doStop();
    }

    protected void doStart() throws Exception {
        this.getCluster().start(this.group);
        super.doStart();
    }

    public MasterComponent getComponent() {
        return this.component;
    }

    public Group getGroup() {
        return this.group;
    }

    public ClusteredSingleton<TextNodeState> getCluster() {
        return this.cluster;
    }

    public String getChild() {
        return this.child;
    }

    public String getSingletonId() {
        return this.singletonId;
    }

    Endpoint getChildEndpoint() {
        return this.getCamelContext().getEndpoint(this.child);
    }
}

