/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq.fabric;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQDestination;
import org.fusesource.mq.fabric.JMSService;

public class FabricActiveMQService
implements JMSService {
    ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("discovery:(fabric:default)");
    Connection defaultConnection;
    Session defaultSession;
    boolean transacted = false;
    int ackMode = 1;
    boolean started = false;

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public Connection getDefaultConnection() {
        return this.defaultConnection;
    }

    @Override
    public Session getDefaultSession() {
        return this.defaultSession;
    }

    @Override
    public MessageProducer createProducer(String destination) throws JMSException {
        return this.defaultSession.createProducer((Destination)ActiveMQDestination.createDestination((String)destination, (byte)1));
    }

    @Override
    public MessageConsumer createConsumer(String destination) throws JMSException {
        return this.defaultSession.createConsumer((Destination)ActiveMQDestination.createDestination((String)destination, (byte)1));
    }

    @Override
    public TextMessage createTextMessage(String text) throws JMSException {
        return this.defaultSession.createTextMessage(text);
    }

    @Override
    public void start() throws JMSException {
        if (!this.started) {
            this.defaultConnection = this.connectionFactory.createConnection();
            this.defaultConnection.start();
            this.defaultSession = this.defaultConnection.createSession(this.transacted, this.ackMode);
        }
        this.started = true;
    }

    @Override
    public void stop() throws JMSException {
        if (this.started && this.defaultConnection != null) {
            this.defaultConnection.stop();
        }
        this.started = false;
    }
}

