/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.jaas;

import java.util.Dictionary;
import org.linkedin.zookeeper.client.IZKClient;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasRealmManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaasRealmManager.class);
    private static final String KARAF_SHELL_PID = "org.apache.karaf.shell";
    private static final String KARAF_MANAGEMENT_PID = "org.apache.karaf.management";
    private static final String SSH_REALM = "sshRealm";
    private static final String JMX_REALM = "jmxRealm";
    private static final String ZOOKEEPER_REALM = "zookeeper";
    private static final String ZOOKEEPER_CLIENT = "org.linkedin.zookeeper.client.IZKClient";
    private BundleContext bundleContext;
    private ConfigurationAdmin configAdmin;
    private ServiceReference configAdminServiceReference;
    private String defaultSshRealm = "karaf";
    private String defaultJmxRealm = "karaf";
    private boolean realmsUpdated;

    public void init() {
        this.configAdminServiceReference = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        this.configAdmin = (ConfigurationAdmin)this.bundleContext.getService(this.configAdminServiceReference);
        this.defaultJmxRealm = this.getRealm(KARAF_MANAGEMENT_PID, JMX_REALM);
        this.defaultSshRealm = this.getRealm(KARAF_SHELL_PID, SSH_REALM);
        if (this.isZookeeperAvailable() && !this.realmsUpdated) {
            this.updateRealm(KARAF_SHELL_PID, SSH_REALM, ZOOKEEPER_REALM);
            this.updateRealm(KARAF_MANAGEMENT_PID, JMX_REALM, ZOOKEEPER_REALM);
            this.realmsUpdated = true;
        }
    }

    public void destroy() {
        this.updateRealm(KARAF_SHELL_PID, SSH_REALM, this.defaultSshRealm);
        this.updateRealm(KARAF_MANAGEMENT_PID, JMX_REALM, this.defaultJmxRealm);
        this.bundleContext.ungetService(this.configAdminServiceReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isZookeeperAvailable() {
        boolean available = false;
        ServiceReference serviceReference = null;
        try {
            IZKClient client;
            serviceReference = this.bundleContext.getServiceReference(ZOOKEEPER_CLIENT);
            if (serviceReference != null && (client = (IZKClient)this.bundleContext.getService(serviceReference)) != null && client.isConnected()) {
                available = true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (serviceReference != null) {
                this.bundleContext.ungetService(serviceReference);
            }
        }
        return available;
    }

    public void updateRealm(String pid, String realmProperty, String realm) {
        try {
            Configuration config = this.configAdmin.getConfiguration(pid);
            Dictionary props = config.getProperties();
            props.put(realmProperty, realm);
            config.setBundleLocation(null);
            config.update(props);
        }
        catch (Exception e) {
            LOGGER.error("Error enabling zookeeper realm for " + realmProperty, (Throwable)e);
        }
    }

    public String getRealm(String pid, String realmProperty) {
        String realm = "karaf";
        try {
            Configuration config = this.configAdmin.getConfiguration(pid);
            if (config != null) {
                Dictionary props = config.getProperties();
                realm = (String)props.get(realmProperty);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error reading the realm " + realmProperty, (Throwable)e);
        }
        return realm;
    }

    public void bind(IZKClient izkClient) {
        if (this.isZookeeperAvailable() && !this.realmsUpdated) {
            this.updateRealm(KARAF_SHELL_PID, SSH_REALM, ZOOKEEPER_REALM);
            this.updateRealm(KARAF_MANAGEMENT_PID, JMX_REALM, ZOOKEEPER_REALM);
            this.realmsUpdated = true;
        }
    }

    public void unbind(IZKClient izkClient) {
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

