/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.jaas;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.apache.karaf.jaas.modules.Encryption;
import org.apache.karaf.jaas.modules.RolePrincipal;
import org.apache.karaf.jaas.modules.UserPrincipal;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.fusesource.fabric.internal.ZooKeeperUtils;
import org.fusesource.fabric.jaas.BasicEncryptionSupport;
import org.linkedin.zookeeper.client.IZKClient;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperLoginModule
extends AbstractKarafLoginModule
implements LoginModule {
    public static final ThreadLocal<IZKClient> ZOOKEEPER_CONTEXT = new ThreadLocal();
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperLoginModule.class);
    private boolean debug = false;
    private static Properties users = new Properties();
    EncryptionSupport encryptionSupport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        IZKClient zookeeper = ZOOKEEPER_CONTEXT.get();
        if (zookeeper == null) {
            BundleContext bundleContext = ((BundleReference)this.getClass().getClassLoader()).getBundle().getBundleContext();
            this.encryptionSupport = new EncryptionSupport(options);
            ServiceReference serviceReference = bundleContext.getServiceReference(IZKClient.class.getName());
            if (serviceReference != null) {
                try {
                    zookeeper = (IZKClient)bundleContext.getService(serviceReference);
                    users = ZooKeeperUtils.getProperties((IZKClient)zookeeper, (String)"fabric/authentication/users");
                }
                catch (Exception e) {
                    LOG.warn("Failed fetching authentication data.", (Throwable)e);
                }
                finally {
                    if (serviceReference != null) {
                        bundleContext.ungetService(serviceReference);
                    }
                }
            }
        } else {
            try {
                users = ZooKeeperUtils.getProperties((IZKClient)zookeeper, (String)"fabric/authentication/users");
            }
            catch (Exception e) {
                LOG.warn("Failed fetching authentication data.", (Throwable)e);
            }
        }
        if (this.encryptionSupport == null) {
            this.encryptionSupport = new BasicEncryptionSupport(options);
        }
        super.initialize(subject, callbackHandler, options);
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        if (this.user == null) {
            throw new FailedLoginException("user name is null");
        }
        String userInfos = users.getProperty(this.user);
        if (userInfos == null) {
            throw new FailedLoginException("User doesn't exist");
        }
        String[] infos = userInfos.split(",");
        String password = infos[0];
        if (!this.checkPassword(new String(tmpPassword), password)) {
            throw new FailedLoginException("Password does not match");
        }
        this.principals = new HashSet();
        this.principals.add(new UserPrincipal(this.user));
        for (int i = 1; i < infos.length; ++i) {
            this.principals.add(new RolePrincipal(infos[i]));
        }
        if (this.debug) {
            LOG.debug("Successfully logged in {}", (Object)this.user);
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            LOG.debug("abort");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            LOG.debug("logout");
        }
        return true;
    }

    public String getEncryptedPassword(String password) {
        boolean suffix;
        Encryption encryption = this.encryptionSupport.getEncryption();
        String encryptionPrefix = this.encryptionSupport.getEncryptionPrefix();
        String encryptionSuffix = this.encryptionSupport.getEncryptionSuffix();
        if (encryption == null) {
            return password;
        }
        boolean prefix = encryptionPrefix == null || password.startsWith(encryptionPrefix);
        boolean bl = suffix = encryptionSuffix == null || password.endsWith(encryptionSuffix);
        if (prefix && suffix) {
            return password;
        }
        String p = encryption.encryptPassword(password);
        if (encryptionPrefix != null) {
            p = encryptionPrefix + p;
        }
        if (encryptionSuffix != null) {
            p = p + encryptionSuffix;
        }
        return p;
    }

    public boolean checkPassword(String plain, String encrypted) {
        boolean suffix;
        Encryption encryption = this.encryptionSupport.getEncryption();
        String encryptionPrefix = this.encryptionSupport.getEncryptionPrefix();
        String encryptionSuffix = this.encryptionSupport.getEncryptionSuffix();
        if (encryption == null) {
            return plain.equals(encrypted);
        }
        boolean prefix = encryptionPrefix == null || encrypted.startsWith(encryptionPrefix);
        boolean bl = suffix = encryptionSuffix == null || encrypted.endsWith(encryptionSuffix);
        if (prefix && suffix) {
            encrypted = encrypted.substring(encryptionPrefix != null ? encryptionPrefix.length() : 0, encrypted.length() - (encryptionSuffix != null ? encryptionSuffix.length() : 0));
            return encryption.checkPassword(plain, encrypted);
        }
        return plain.equals(encrypted);
    }
}

