/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.fusesource.fabric.fab.osgi.internal.Activator;
import org.fusesource.fabric.fab.osgi.internal.Configuration;
import org.fusesource.fabric.fab.osgi.internal.FabConnection;
import org.osgi.framework.BundleContext;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabURLHandler
extends AbstractURLStreamHandlerService {
    private static String SYNTAX = "fab: fab-jar-uri";
    private static final Logger logger = LoggerFactory.getLogger(FabURLHandler.class);
    private URL fabJarURL;
    private String mavenRepositories;
    private BundleContext bundleContext;

    public FabConnection openConnection(URL url) throws IOException {
        if (url.getPath() == null || url.getPath().trim().length() == 0) {
            throw new MalformedURLException("Path can not be null or empty. Syntax: " + SYNTAX);
        }
        this.fabJarURL = new URL(url.getPath());
        logger.debug("FAB jar URL is: [" + this.fabJarURL + "]");
        Configuration config = Configuration.newInstance();
        if (this.mavenRepositories != null) {
            String[] array = Configuration.toArray(this.mavenRepositories);
            logger.debug("Using maven repos: " + Arrays.asList(array));
            config.set("org.ops4j.pax.url.mvn.repositories", array);
        }
        return new FabConnection(this.fabJarURL, config, this.getBundleContext());
    }

    public URL getFabJarURL() {
        return this.fabJarURL;
    }

    public String getMavenRepositories() {
        return this.mavenRepositories;
    }

    public void setMavenRepositories(String mavenRepositories) {
        this.mavenRepositories = mavenRepositories;
    }

    public BundleContext getBundleContext() {
        if (this.bundleContext == null) {
            this.bundleContext = Activator.getInstanceBundleContext();
        }
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

