/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.api.Agent;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.api.data.BundleInfo;
import org.fusesource.fabric.api.data.ServiceInfo;
import org.fusesource.fabric.internal.BundleInfoComparator;
import org.fusesource.fabric.internal.JmxBundleInfo;
import org.fusesource.fabric.internal.JmxServiceInfo;
import org.fusesource.fabric.internal.ProfileImpl;
import org.fusesource.fabric.internal.ServiceInfoComparator;
import org.fusesource.fabric.internal.VersionImpl;
import org.fusesource.fabric.internal.ZooKeeperUtils;
import org.fusesource.fabric.service.AgentTemplate;
import org.fusesource.fabric.service.FabricServiceImpl;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.ServiceStateMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentImpl
implements Agent {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Agent parent;
    private final String id;
    private final FabricServiceImpl service;
    @Deprecated
    private AgentTemplate agentTemplate;

    public AgentImpl(Agent parent, String id, FabricServiceImpl service) {
        this.parent = parent;
        this.id = id;
        this.service = service;
    }

    @Override
    public Agent getParent() {
        return this.parent;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isAlive() {
        try {
            return this.service.getZooKeeper().exists(ZkPath.AGENT_ALIVE.getPath(new String[]{this.id})) != null;
        }
        catch (KeeperException.NoNodeException e) {
            return false;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean isProvisioningComplete() {
        return this.getProvisionResult() != null || this.getProvisionException() != null || this.isRoot();
    }

    @Override
    public String getProvisionStatus() {
        String provisioned = this.getProvisionResult();
        String provisionException = this.getProvisionException();
        String result = "not provisioned";
        if (provisioned != null && (result = provisioned).equals("error") && provisionException != null) {
            result = result + " - " + provisionException.split(System.getProperty("line.separator"))[0];
        }
        return result;
    }

    @Override
    public String getSshUrl() {
        return this.getZkData(ZkPath.AGENT_SSH);
    }

    @Override
    public String getJmxUrl() {
        return this.getZkData(ZkPath.AGENT_JMX);
    }

    private String getZkData(ZkPath path) {
        try {
            return this.service.getZooKeeper().getStringData(path.getPath(new String[]{this.id}));
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version getVersion() {
        try {
            String version = this.service.getZooKeeper().getStringData(ZkPath.CONFIG_AGENT.getPath(new String[]{this.id}));
            return new VersionImpl(version, this.service);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setVersion(Version version) {
        try {
            ZooKeeperUtils.set(this.service.getZooKeeper(), ZkPath.CONFIG_AGENT.getPath(new String[]{this.id}), version.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Profile[] getProfiles() {
        try {
            String version = this.service.getZooKeeper().getStringData(ZkPath.CONFIG_AGENT.getPath(new String[]{this.id}));
            String node = ZkPath.CONFIG_VERSIONS_AGENT.getPath(new String[]{version, this.id});
            String str = this.service.getZooKeeper().getStringData(node);
            if (str == null) {
                return new Profile[0];
            }
            ArrayList<ProfileImpl> profiles = new ArrayList<ProfileImpl>();
            for (String p : str.split(" ")) {
                profiles.add(new ProfileImpl(p, version, this.service));
            }
            return profiles.toArray(new Profile[profiles.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setProfiles(Profile[] profiles) {
        try {
            String version = this.service.getZooKeeper().getStringData(ZkPath.CONFIG_AGENT.getPath(new String[]{this.id}));
            String node = ZkPath.CONFIG_VERSIONS_AGENT.getPath(new String[]{version, this.id});
            String str = "";
            for (Profile parent : profiles) {
                if (!version.equals(parent.getVersion())) {
                    throw new IllegalArgumentException("Bad profile: " + parent);
                }
                if (!str.isEmpty()) {
                    str = str + " ";
                }
                str = str + parent.getId();
            }
            this.service.getZooKeeper().setData(node, str);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public String getLocation() {
        try {
            String path = ZkPath.AGENT_LOCATION.getPath(new String[]{this.id});
            if (this.service.getZooKeeper().exists(path) != null) {
                return this.service.getZooKeeper().getStringData(path);
            }
            return "";
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void setLocation(String location) {
        try {
            String path = ZkPath.AGENT_LOCATION.getPath(new String[]{this.id});
            ZooKeeperUtils.set(this.service.getZooKeeper(), path, location);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Deprecated
    public AgentTemplate getAgentTemplate() {
        if (this.agentTemplate == null) {
            this.agentTemplate = new AgentTemplate((Agent)this, false);
        }
        return this.agentTemplate;
    }

    @Override
    @Deprecated
    public ServiceInfo[] getServices() {
        return this.getServices(this.getAgentTemplate());
    }

    @Override
    @Deprecated
    public BundleInfo[] getBundles() {
        return this.getBundles(this.agentTemplate);
    }

    @Override
    public BundleInfo[] getBundles(AgentTemplate agentTemplate) {
        try {
            return agentTemplate.execute(new AgentTemplate.BundleStateCallback<BundleInfo[]>(){

                @Override
                public BundleInfo[] doWithBundleState(BundleStateMBean bundleState) throws Exception {
                    TabularData bundles = bundleState.listBundles();
                    BundleInfo[] info = new BundleInfo[bundles.size()];
                    int i = 0;
                    for (Object data : bundles.values().toArray()) {
                        info[i++] = new JmxBundleInfo((CompositeData)data);
                    }
                    Arrays.sort(info, new BundleInfoComparator());
                    return info;
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Error while retrieving bundles", (Throwable)e);
            return new BundleInfo[0];
        }
    }

    @Override
    public ServiceInfo[] getServices(AgentTemplate agentTemplate) {
        try {
            return agentTemplate.execute(new AgentTemplate.ServiceStateCallback<ServiceInfo[]>(){

                @Override
                public ServiceInfo[] doWithServiceState(ServiceStateMBean serviceState) throws Exception {
                    TabularData services = serviceState.listServices();
                    ServiceInfo[] info = new ServiceInfo[services.size()];
                    int i = 0;
                    for (Object data : services.values().toArray()) {
                        CompositeData svc = (CompositeData)data;
                        info[i++] = new JmxServiceInfo(svc, serviceState.getProperties(((Long)svc.get("Identifier")).longValue()));
                    }
                    Arrays.sort(info, new ServiceInfoComparator());
                    return info;
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Error while retrieving services", (Throwable)e);
            return new ServiceInfo[0];
        }
    }

    @Override
    public List<String> getJmxDomains() {
        try {
            List list2 = this.service.getZooKeeper().getChildren(ZkPath.AGENT_DOMAINS.getPath(new String[]{this.getId()}));
            Collections.sort(list2);
            return Collections.unmodifiableList(list2);
        }
        catch (Exception e) {
            this.logger.error("Error while retrieving jmx domains", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void start() {
        this.service.startAgent(this);
    }

    @Override
    public void stop() {
        this.service.stopAgent(this);
    }

    @Override
    public void destroy() {
        this.service.destroy(this);
    }

    @Override
    public Agent[] getChildren() {
        return new Agent[0];
    }

    @Override
    public String getType() {
        return "karaf";
    }

    @Override
    public String getProvisionResult() {
        return this.getZkData(ZkPath.AGENT_PROVISION_RESULT);
    }

    @Override
    public String getProvisionException() {
        return this.getZkData(ZkPath.AGENT_PROVISION_EXCEPTION);
    }
}

