/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.internal;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.api.ZooKeeperClusterService;
import org.fusesource.fabric.internal.InterpolationHelper;
import org.fusesource.fabric.internal.ZooKeeperUtils;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.linkedin.util.clock.Timespan;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.ZKClient;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ZooKeeperClusterServiceImpl
implements ZooKeeperClusterService {
    private BundleContext bundleContext;
    private ConfigurationAdmin configurationAdmin;
    private IZKClient zooKeeper;
    private String version = "base";

    public void init() {
        Boolean autoStart = Boolean.parseBoolean(System.getProperty("ensemble.auto.start"));
        if (autoStart.booleanValue()) {
            this.createLocalServer();
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    @Override
    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public void createLocalServer() {
        this.createLocalServer(2181);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createLocalServer(int port) {
        ZKClient client = null;
        String karafName = System.getProperty("karaf.name");
        String result = null;
        String exception = null;
        try {
            Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper");
            Properties properties = new Properties();
            String connectionUrl = ZooKeeperClusterServiceImpl.getLocalHostAddress() + ":" + Integer.toString(port);
            String mavenProxyUrl = "http://" + ZooKeeperClusterServiceImpl.getLocalHostAddress() + ":" + 8040;
            properties.put("zookeeper.url", connectionUrl);
            config.setBundleLocation(null);
            config.update((Dictionary)properties);
            config = this.configurationAdmin.createFactoryConfiguration("org.fusesource.fabric.zookeeper.server");
            properties = new Properties();
            properties.put("tickTime", "2000");
            properties.put("initLimit", "10");
            properties.put("syncLimit", "5");
            properties.put("dataDir", "data/zookeeper/0000");
            properties.put("clientPort", Integer.toString(port));
            properties.put("fabric.zookeeper.pid", "org.fusesource.fabric.zookeeper.server-0000");
            config.setBundleLocation(null);
            config.update((Dictionary)properties);
            client = new ZKClient(connectionUrl, Timespan.ONE_MINUTE, null);
            client.start();
            client.waitForStart(new Timespan(5L, Timespan.TimeUnit.SECOND));
            String defaultProfile = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, "default"});
            ZooKeeperClusterServiceImpl.setConfigProperty(client, defaultProfile + "/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", "${zk:" + karafName + "/ip}:" + Integer.toString(port));
            String profileNode = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, "zk-server-0000"}) + "/org.fusesource.fabric.zookeeper.server-0000.properties";
            Properties p = new Properties();
            p.put("tickTime", "2000");
            p.put("initLimit", "10");
            p.put("syncLimit", "5");
            p.put("dataDir", "data/zookeeper/0000");
            ZooKeeperUtils.set((IZKClient)client, profileNode, ZooKeeperClusterServiceImpl.toString(p));
            ZooKeeperUtils.set((IZKClient)client, ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, "zk-server-0000-1"}), "zk-server-0000");
            profileNode = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, "zk-server-0000-1"}) + "/org.fusesource.fabric.zookeeper.server-0000.properties";
            p = new Properties();
            p.put("clientPort", "2181");
            ZooKeeperUtils.set((IZKClient)client, profileNode, ZooKeeperClusterServiceImpl.toString(p));
            ZooKeeperUtils.set((IZKClient)client, "/fabric/configs/versions/" + this.version + "/general/zookeeper-cluster", "0000");
            ZooKeeperUtils.set((IZKClient)client, "/fabric/configs/versions/" + this.version + "/general/zookeeper-cluster/0000", karafName);
            p = ZooKeeperClusterServiceImpl.getProperties(client, defaultProfile + "/org.fusesource.fabric.agent.properties", new Properties());
            p.put("org.ops4j.pax.url.mvn.defaultRepositories", "file:${karaf.home}/${karaf.default.repository}@snapshots");
            p.put("org.ops4j.pax.url.mvn.repositories", "http://repo1.maven.org/maven2,http://repo.fusesource.com/nexus/content/repositories/releases,http://scala-tools.org/repo-releases");
            p.put("repository.fabric", "mvn:org.fusesource.fabric/fuse-fabric/1.1/xml/features");
            p.put("feature.karaf", "karaf");
            p.put("feature.fabric-agent", "fabric-agent");
            p.put("feature.fabric-core", "fabric-core");
            p.put("feature.fabric-jaas", "fabric-jaas");
            p.put("framework", "mvn:org.apache.felix/org.apache.felix.framework/3.0.9-fuse-00-10");
            ZooKeeperUtils.set((IZKClient)client, defaultProfile + "/org.fusesource.fabric.agent.properties", ZooKeeperClusterServiceImpl.toString(p));
            ZooKeeperUtils.createDefault((IZKClient)client, ZkPath.CONFIG_AGENT.getPath(new String[]{karafName}), this.version);
            ZooKeeperUtils.createDefault((IZKClient)client, ZkPath.CONFIG_VERSIONS_AGENT.getPath(new String[]{this.version, karafName}), "default zk-server-0000-1");
            ZooKeeperUtils.createDefault((IZKClient)client, defaultProfile + "/org.fusesource.fabric.jaas/encryption.enabled", "${zk:/fabric/authentication/encryption.enabled}");
            ZooKeeperUtils.createDefault((IZKClient)client, "fabric/authentication/encryption.enabled", "true");
            ZooKeeperUtils.createDefault((IZKClient)client, "fabric/authentication/domain", "zookeeper");
            ZooKeeperUtils.createDefault((IZKClient)client, "/fabric/authentication/users", "admin={CRYPT}21232f297a57a5a743894a0e4a801fc3{CRYPT},admin\nsystem={CRYPT}1d0258c2440a8d19e716292b231e3190{CRYPT},admin");
            ZooKeeperUtils.createDefault((IZKClient)client, ZkPath.CONFIGS_MAVEN_REPO.getPath(new String[0]), mavenProxyUrl);
            Bundle bundle = null;
            for (Bundle b : this.bundleContext.getBundles()) {
                if (b.getSymbolicName() == null || !b.getSymbolicName().equals("org.fusesource.fabric.fabric-configadmin") || b.getVersion().getMajor() != 1 || b.getVersion().getMinor() != 1 || b.getVersion().getMicro() != 0) continue;
                bundle = b;
                break;
            }
            if (bundle == null) {
                bundle = this.bundleContext.installBundle("mvn:org.fusesource.fabric/fabric-configadmin/1.1");
            }
            if (bundle.getState() == 32) {
                bundle.stop();
            }
            bundle.start();
            result = "success";
            exception = null;
        }
        catch (Exception e) {
            try {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                result = "error";
                exception = sw.toString();
                throw new FabricException("Unable to create zookeeper server configuration", e);
            }
            catch (Throwable throwable) {
                try {
                    ZooKeeperUtils.set(client, ZkPath.AGENT_PROVISION_RESULT.getPath(new String[]{karafName}), result);
                    ZooKeeperUtils.set(client, ZkPath.AGENT_PROVISION_EXCEPTION.getPath(new String[]{karafName}), exception);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (client == null) throw throwable;
                client.destroy();
                throw throwable;
            }
        }
        try {
            ZooKeeperUtils.set((IZKClient)client, ZkPath.AGENT_PROVISION_RESULT.getPath(new String[]{karafName}), result);
            ZooKeeperUtils.set((IZKClient)client, ZkPath.AGENT_PROVISION_EXCEPTION.getPath(new String[]{karafName}), exception);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (client == null) return;
        client.destroy();
    }

    @Override
    public void clean() {
        try {
            Configuration[] configs;
            while ((configs = this.configurationAdmin.listConfigurations("(|(service.factoryPid=org.fusesource.fabric.zookeeper.server)(service.pid=org.fusesource.fabric.zookeeper))")) != null && configs.length > 0) {
                for (Configuration config : configs) {
                    config.delete();
                }
                Thread.sleep(100L);
            }
            File zkDir = new File("data/zookeeper");
            if (zkDir.isDirectory()) {
                File newZkDir = new File("data/zookeeper." + System.currentTimeMillis());
                if (!zkDir.renameTo(newZkDir)) {
                    newZkDir = zkDir;
                }
                ZooKeeperClusterServiceImpl.delete(newZkDir);
            }
        }
        catch (Exception e) {
            throw new FabricException("Unable to delete zookeeper configuration", e);
        }
    }

    private static void delete(File dir) {
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                ZooKeeperClusterServiceImpl.delete(child);
            }
        }
        if (dir.exists()) {
            dir.delete();
        }
    }

    @Override
    public List<String> getClusterAgents() {
        try {
            Configuration[] configs = this.configurationAdmin.listConfigurations("(service.pid=org.fusesource.fabric.zookeeper)");
            if (configs == null || configs.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> list2 = new ArrayList<String>();
            if (this.zooKeeper.exists("/fabric/configs/versions/" + this.version + "/general/zookeeper-cluster") != null) {
                String clusterId = this.zooKeeper.getStringData("/fabric/configs/versions/" + this.version + "/general/zookeeper-cluster");
                String agents = this.zooKeeper.getStringData("/fabric/configs/versions/" + this.version + "/general/zookeeper-cluster/" + clusterId);
                Collections.addAll(list2, agents.split(","));
            }
            return list2;
        }
        catch (Exception e) {
            throw new FabricException("Unable to load zookeeper quorum agents", e);
        }
    }

    @Override
    public String getZooKeeperUrl() {
        try {
            Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper", null);
            String zooKeeperUrl = (String)config.getProperties().get("zookeeper.url");
            if (zooKeeperUrl == null) {
                throw new IllegalStateException("Unable to find the zookeeper url");
            }
            return zooKeeperUrl;
        }
        catch (Exception e) {
            throw new FabricException("Unable to load zookeeper current url", e);
        }
    }

    private String getSubstitutedData(String path) throws InterruptedException, KeeperException {
        String data = this.zooKeeper.getStringData(path);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("data", data);
        InterpolationHelper.performSubstitution(props, new InterpolationHelper.SubstitutionCallback(){

            @Override
            public String getValue(String key) {
                if (key.startsWith("zk:")) {
                    try {
                        new String(ZkPath.loadURL((IZKClient)ZooKeeperClusterServiceImpl.this.zooKeeper, (String)key), "UTF-8");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        });
        return (String)props.get("data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCluster(List<String> agents) {
        block18: {
            try {
                String zooKeeperUrl;
                if (agents == null || agents.size() == 2) {
                    throw new IllegalArgumentException("One or at least 3 agents must be used to create a zookeeper cluster");
                }
                Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper", null);
                String string = zooKeeperUrl = config != null && config.getProperties() != null ? (String)config.getProperties().get("zookeeper.url") : null;
                if (zooKeeperUrl == null) {
                    if (agents.size() != 1 || !agents.get(0).equals(System.getProperty("karaf.name"))) {
                        throw new FabricException("The first zookeeper cluster must be configured on this agent only.");
                    }
                    this.createLocalServer();
                    return;
                }
                String url = this.getSubstitutedData("/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties#zookeeper.url");
                if (!url.equals(zooKeeperUrl)) {
                    throw new IllegalStateException("The zookeeper configuration is not properly backed in the zookeeper tree.");
                }
                for (String agent : agents) {
                    if (this.zooKeeper.exists("/fabric/registry/agents/alive/" + agent) != null) continue;
                    throw new FabricException("The agent " + agent + " is not alive");
                }
                HashMap<String, List<Integer>> usedPorts = new HashMap<String, List<Integer>>();
                String oldClusterId = ZooKeeperUtils.get(this.zooKeeper, "/fabric/configs/versions/" + this.version + "/general/zookeeper-cluster");
                if (oldClusterId != null) {
                    Properties p = ZooKeeperClusterServiceImpl.toProperties(this.zooKeeper.getStringData("/fabric/configs/versions/" + this.version + "/profiles/zk-server-" + oldClusterId + "/org.fusesource.fabric.zookeeper.server-" + oldClusterId + ".properties"));
                    for (Object n : p.keySet()) {
                        String node = (String)n;
                        if (!node.startsWith("server.")) continue;
                        String data = this.getSubstitutedData("/fabric/configs/versions/" + this.version + "/profiles/zk-server-" + oldClusterId + "/org.fusesource.fabric.zookeeper.server-" + oldClusterId + ".properties#" + node);
                        this.addUsedPorts(usedPorts, data);
                    }
                    String datas = this.getSubstitutedData("/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties#zookeeper.url");
                    for (String data : datas.split(",")) {
                        this.addUsedPorts(usedPorts, data);
                    }
                }
                String newClusterId = oldClusterId == null ? "0000" : new DecimalFormat("0000").format(Integer.parseInt(oldClusterId) + 1);
                String profileNode = "/fabric/configs/versions/" + this.version + "/profiles/zk-server-" + newClusterId + "/org.fusesource.fabric.zookeeper.server-" + newClusterId + ".properties";
                Properties profileNodeProperties = new Properties();
                profileNodeProperties.put("tickTime", "2000");
                profileNodeProperties.put("initLimit", "10");
                profileNodeProperties.put("syncLimit", "5");
                profileNodeProperties.put("dataDir", "data/zookeeper/" + newClusterId);
                int index = 1;
                String connectionUrl = "";
                String realConnectionUrl = "";
                String agentList = "";
                for (String agent : agents) {
                    String ip = this.zooKeeper.getStringData("/fabric/registry/agents/config/" + agent + "/ip");
                    String profNode = "/fabric/configs/versions/" + this.version + "/profiles/zk-server-" + newClusterId + "-" + Integer.toString(index);
                    String pidNode = profNode + "/org.fusesource.fabric.zookeeper.server-" + newClusterId + ".profile";
                    Properties pidNodeProperties = new Properties();
                    ZooKeeperUtils.add(this.zooKeeper, profNode, "zk-server-" + newClusterId);
                    String port1 = Integer.toString(this.findPort(usedPorts, ip, 2181));
                    if (agents.size() > 1) {
                        String port2 = Integer.toString(this.findPort(usedPorts, ip, 2888));
                        String port3 = Integer.toString(this.findPort(usedPorts, ip, 3888));
                        profileNodeProperties.put("server." + Integer.toString(index), "${zk:" + agent + "/ip}:" + port2 + ":" + port3);
                        pidNodeProperties.put("server.id", Integer.toString(index));
                    }
                    pidNodeProperties.put("clientPort", port1);
                    ZooKeeperUtils.set(this.zooKeeper, pidNode, ZooKeeperClusterServiceImpl.toString(pidNodeProperties));
                    ZooKeeperUtils.add(this.zooKeeper, "/fabric/configs/versions/" + this.version + "/agents/" + agent, "zk-server-" + newClusterId + "-" + Integer.toString(index));
                    if (connectionUrl.length() > 0) {
                        connectionUrl = connectionUrl + ",";
                        realConnectionUrl = realConnectionUrl + ",";
                    }
                    connectionUrl = connectionUrl + "${zk:" + agent + "/ip}:" + port1;
                    realConnectionUrl = realConnectionUrl + ip + ":" + port1;
                    if (agentList.length() > 0) {
                        agentList = agentList + ",";
                    }
                    agentList = agentList + agent;
                    ++index;
                }
                ZooKeeperUtils.set(this.zooKeeper, profileNode, ZooKeeperClusterServiceImpl.toString(profileNodeProperties));
                if (oldClusterId == null) break block18;
                ZKClient src = new ZKClient(zooKeeperUrl, Timespan.ONE_MINUTE, null);
                ZKClient dst = new ZKClient(realConnectionUrl, Timespan.ONE_MINUTE, null);
                try {
                    src.start();
                    dst.start();
                    src.waitForStart(new Timespan(5L, Timespan.TimeUnit.SECOND));
                    dst.waitForStart(new Timespan(5L, Timespan.TimeUnit.SECOND));
                    ZooKeeperUtils.copy((IZKClient)src, (IZKClient)dst, "/fabric/configs");
                    ZooKeeperUtils.set((IZKClient)dst, "/fabric/configs/versions/" + this.version + "/general/zookeeper-cluster", newClusterId);
                    ZooKeeperUtils.set((IZKClient)dst, "/fabric/configs/versions/" + this.version + "/general/zookeeper-cluster/" + newClusterId, agentList);
                    for (String agent : dst.getChildren("/fabric/configs/versions/" + this.version + "/agents")) {
                        ZooKeeperUtils.remove((IZKClient)dst, "/fabric/configs/versions/" + this.version + "/agents/" + agent, "zk-server-" + oldClusterId + "-.*");
                    }
                    ZooKeeperClusterServiceImpl.setConfigProperty(dst, "/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", connectionUrl);
                    ZooKeeperClusterServiceImpl.setConfigProperty(src, "/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", connectionUrl);
                }
                finally {
                    src.destroy();
                    dst.destroy();
                }
            }
            catch (Exception e) {
                throw new FabricException("Unable to create zookeeper quorum: " + e.getMessage(), e);
            }
        }
    }

    public static String toString(Properties source) throws IOException {
        StringWriter writer = new StringWriter();
        source.store(writer, null);
        return writer.toString();
    }

    public static Properties toProperties(String source) throws IOException {
        Properties rc = new Properties();
        rc.load(new StringReader(source));
        return rc;
    }

    public static Properties getProperties(ZKClient client, String file, Properties defaultValue) throws InterruptedException, KeeperException, IOException {
        try {
            String v = ZooKeeperUtils.get((IZKClient)client, file);
            if (v != null) {
                return ZooKeeperClusterServiceImpl.toProperties(v);
            }
            return defaultValue;
        }
        catch (KeeperException.NoNodeException e) {
            return defaultValue;
        }
    }

    public static void setConfigProperty(ZKClient client, String file, String prop, String value) throws InterruptedException, KeeperException, IOException {
        Properties p = ZooKeeperClusterServiceImpl.getProperties(client, file, new Properties());
        p.setProperty(prop, value);
        ZooKeeperUtils.set((IZKClient)client, file, ZooKeeperClusterServiceImpl.toString(p));
    }

    private int findPort(Map<String, List<Integer>> usedPorts, String ip, int port) {
        List<Integer> ports = usedPorts.get(ip);
        if (ports == null) {
            ports = new ArrayList<Integer>();
            usedPorts.put(ip, ports);
        }
        while (true) {
            if (!ports.contains(port)) {
                ports.add(port);
                return port;
            }
            ++port;
        }
    }

    private void addUsedPorts(Map<String, List<Integer>> usedPorts, String data) {
        String[] parts = data.split(":");
        List<Integer> ports = usedPorts.get(parts[0]);
        if (ports == null) {
            ports = new ArrayList<Integer>();
            usedPorts.put(parts[0], ports);
        }
        for (int i = 1; i < parts.length; ++i) {
            ports.add(Integer.parseInt(parts[i]));
        }
    }

    @Override
    public void addToCluster(List<String> agents) {
        try {
            List<String> current = this.getClusterAgents();
            current.addAll(agents);
            this.createCluster(current);
        }
        catch (Exception e) {
            throw new FabricException("Unable to add agents to zookeeper quorum: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeFromCluster(List<String> agents) {
        try {
            List<String> current = this.getClusterAgents();
            current.removeAll(agents);
            this.createCluster(current);
        }
        catch (Exception e) {
            throw new FabricException("Unable to add agents to zookeeper quorum: " + e.getMessage(), e);
        }
    }

    private static String getLocalHostAddress() throws UnknownHostException {
        return InetAddress.getByName(InetAddress.getLocalHost().getCanonicalHostName()).getHostAddress();
    }
}

